// modifydl.cpp : implementation file
//

#include "stdafx.h"
#include "modify.h"
#include "modifydl.h" 
#include <windowsx.h>

#include "mainfrm.h"
#include "detaildl.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CModifyDlg dialog

CModifyDlg::CModifyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CModifyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModifyDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT  
}

void CModifyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModifyDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CModifyDlg, CDialog)
	//{{AFX_MSG_MAP(CModifyDlg)
	ON_BN_CLICKED(IDC_ADD, OnClickedAdd)
	ON_BN_CLICKED(IDC_MODIFY, OnClickedModify)
	ON_BN_CLICKED(IDC_REMOVE, OnClickedRemove)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModifyDlg message handlers   


BYTE CModifyDlg::GetTable(void)
{
	return this->Table;
}

void CModifyDlg::SetTable(BYTE bParam)
{
	this->Table = bParam;
}

// A ce niveau, utiliser le PTable pour passer n'importe quelle table,
// puis utiliser BuffFieldNP pour tous les BuffBytes
void AddLineToCustomeCombo(PTable pTable ,int i, CListBox*	DetailList)
{
	struct sCustom
				{
				char Name[30];
				char Address[255];
				char Phone[20];
				}far* lpCustomer;      
   LPSTR		lpstrName;
   int		Status;	
	
	lpstrName 	= (LPSTR)GlobalAllocPtr(GHND,sizeof(sCustom));
	lpCustomer = (sCustom far*)TbGetRecordAddress(pTable,i);
	if (lpCustomer != NULL)  
		{
		_fstrcpy(lpstrName,lpCustomer->Name); 
		_fstrcat(lpstrName,"\t"); 
		_fstrcat(lpstrName,lpCustomer->Address);
		_fstrcat(lpstrName,"\t"); 
		_fstrcat(lpstrName,lpCustomer->Phone);                    
		if (i<=DetailList->GetCount())
		   Status = DetailList->InsertString(i-1,lpstrName);
		else                                              
			Status = DetailList->AddString(lpstrName);
		if (Status == LB_ERR)
			AfxMessageBox("Customer List Error");
		}
	GlobalFreePtr(lpstrName);
}


void AddLineToTraderCombo(PTable pTable ,int i, CListBox*	DetailList)
{
	struct sTraders
				{
				char Name[30];
				char FirstName[20];
				char Address[255];
				char Phone[20];
				}far* lpTrader;      
   LPSTR		lpstrName;
   int		Status;	
	
	lpstrName 	= (LPSTR)GlobalAllocPtr(GHND,sizeof(sTraders));
	lpTrader = (sTraders far*)TbGetRecordAddress(pTable,i);
	if (lpTrader != NULL)  
		{
		_fstrcpy(lpstrName,lpTrader->Name); 
		_fstrcat(lpstrName,"\t");  
		_fstrcat(lpstrName,lpTrader->FirstName); 
		_fstrcat(lpstrName,"\t"); 
		_fstrcat(lpstrName,lpTrader->Phone);                    
		_fstrcat(lpstrName,"\t"); 
		_fstrcat(lpstrName,lpTrader->Address);
		
		if (i<=DetailList->GetCount())
		   Status = DetailList->InsertString(i-1,lpstrName);
		else                                              
			Status = DetailList->AddString(lpstrName);
		if (Status == LB_ERR)
			AfxMessageBox("Trader List Error");
		}
	GlobalFreePtr(lpstrName);
}


BOOL CModifyDlg::OnInitDialog()
{  
	CListBox*	DetailList;
	PTable		CustomTable	;
	CModifyApp*	MyApp;
   WORD			uDlgWidthUnit;                  
   WORD			tabStop[4];
   WORD 			uCursor; 
   
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	// Code Starts Here
	MyApp = (CModifyApp*)AfxGetApp();
	uCursor = MyApp->uCursor;

	DetailList  = (CListBox*) GetDlgItem(IDC_LIST);
	

	// Set tabstops in the Dialogs list
	uDlgWidthUnit = LOWORD(GetDialogBaseUnits())/4;
	
	tabStop[0] = uDlgWidthUnit*4*8;
	tabStop[1] = uDlgWidthUnit*4*20;
	tabStop[2] = uDlgWidthUnit*4*25;
	tabStop[3] = uDlgWidthUnit*4*30;
	                      
	DetailList->SetTabStops(4,(LPINT)&tabStop);
	
	// Fill List
	switch (this->Table)
		{
		case 1:
			CustomTable = GetTableInfo(uCursor,"CUSTOME");                                
			if (CustomTable!= NULL)
				for(UINT i=1;i<= CustomTable->NbRecs;i++)
					AddLineToCustomeCombo(CustomTable,i,DetailList);
			else
				AfxMessageBox("Table CUSTOMER Not Found ...");
			break;
		case 2:                                    
			CustomTable = GetTableInfo(uCursor,"TRADERS");                                
			if (CustomTable!= NULL)
				for(UINT i=1;i<= CustomTable->NbRecs;i++)
					AddLineToTraderCombo(CustomTable,i,DetailList);
			else
				AfxMessageBox("Table TRADERS Not Found ...");
			break;
		
		}
	
		
		
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CModifyDlg::OnClickedAdd()
{
	// TODO: Add your control notification handler code here
	
	CDetailDlg  Dlg;        
	CListBox*   DetailList;
	PTable		CustomTable;
	CModifyApp*	MyApp; 
	  
	// Code starts Here
	MyApp = (CModifyApp*)AfxGetApp();
	 
	
	DetailList =(CListBox*) GetDlgItem(IDC_LIST);
	Dlg.SetDataIndex(LB_ERR);
	Dlg.SetTable(this->Table);
	Dlg.DoModal(); 
		if (Dlg.GetDataIndex()!=LB_ERR)
			{
			int i = (int)Dlg.GetDataIndex();
			switch (this->Table)
				{
				case 1:
					CustomTable = GetTableInfo(MyApp->uCursor,"CUSTOME");                                	
					AddLineToCustomeCombo(CustomTable,i+1,DetailList);
					break;
				case 2:  
					CustomTable = GetTableInfo(MyApp->uCursor,"TRADERS");                                	
					AddLineToTraderCombo(CustomTable,i+1,DetailList);
					break;
				}
			DetailList->SetCurSel(i);
			}
}

void CModifyDlg::OnClickedModify()
{
	// TODO: Add your control notification handler code here
   
   CDetailDlg  Dlg;
	CListBox*   DetailList;
	int         iCurSel;
	PTable		CustomTable;
	CModifyApp*	MyApp;   
	WORD 			uCursor; 
	
	// Code Starts Here       
	MyApp = (CModifyApp*)AfxGetApp();
	uCursor = MyApp->uCursor;
	
	DetailList =(CListBox*) GetDlgItem(IDC_LIST);
	iCurSel = DetailList->GetCurSel();
	if (iCurSel!=LB_ERR)
		{         
		Dlg.SetDataIndex(iCurSel); 
		Dlg.SetTable(this->Table);
		Dlg.DoModal(); 
		if (Dlg.GetDataIndex()!=LB_ERR)
			{ 
			
			DetailList->DeleteString(iCurSel);
			int i = (int)Dlg.GetDataIndex();           
			switch (this->Table)
				{
				case 1:
					CustomTable = GetTableInfo(uCursor,"CUSTOME"); 
					AddLineToCustomeCombo(CustomTable,i+1,DetailList);
					break;
				case 2:  
					CustomTable = GetTableInfo(uCursor,"TRADERS"); 
					AddLineToTraderCombo(CustomTable,i+1,DetailList);
					break;
				
				} 	
			
			DetailList->SetCurSel(i);
			}
		}
	else
		AfxMessageBox("Please select a line to modify ...");	
}

void CModifyDlg::OnClickedRemove()
{
	// TODO: Add your control notification handler code here
	CDetailDlg  Dlg;
	CListBox*   DetailList;
	int         iCurSel;
	PTable		CustomTable;
	CModifyApp*	MyApp;   
	WORD 			uCursor; 
	
	// Code Starts Here       
	MyApp = (CModifyApp*)AfxGetApp();
	uCursor = MyApp->uCursor;
	                                
	DetailList =(CListBox*) GetDlgItem(IDC_LIST);
	iCurSel = DetailList->GetCurSel();
	if (iCurSel!=LB_ERR)
		{
		DetailList->DeleteString(iCurSel);         
		switch (this->Table)
		{  
		case 1:
			CustomTable = GetTableInfo(uCursor,"CUSTOME");
			TbDeleteRecord(CustomTable,iCurSel+1);
			break;
		case 2:  
			CustomTable = GetTableInfo(uCursor,"TRADERS");
			TbDeleteRecord(CustomTable,iCurSel+1);
			break;
		   
		}
		if (iCurSel+1 <= DetailList->GetCount())
			DetailList->SetCurSel(iCurSel);
		else                              
			DetailList->SetCurSel(iCurSel-1);
			   
		}
}
