'these are all general routines for any program
Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function GetProfileInt Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Integer) As Integer
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName As String) As Integer
Declare Function WriteProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any) As Integer

Declare Function GetSystemDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

Declare Function GetVersion Lib "Kernel" () As Long

Function GetPPKeyString$ (AppName$, KeyName$, Default$, FileName$)
Size% = 255
ReturnString$ = Space$(Size%)
ValidLength% = GetPrivateProfileString(AppName$, KeyName$, Default$, ReturnString$, Size%, FileName$)
GetPPKeyString$ = Left$(ReturnString$, ValidLength%)
End Function

Function GetSPKeyString$ (AppName$, KeyName$, Default$)
'get the windows directory
WinDir$ = Space$(144)
Result% = GetWindowsDirectory(WinDir$, 144)
If Result% = 0 Then
    GetSPKeyString$ = Default$
    Exit Function
Else
    i% = InStr(WinDir$, Chr$(0))
    If i% Then
        WinDir$ = Left$(WinDir$, i% - 1)
    End If
    WinDir$ = Trim$(WinDir$)
    If Right$(WinDir$, 1) <> "\" Then
        WinDir$ = WinDir$ & "\"
    End If
End If
'check system.ini as private profile
FileName$ = WinDir$ & "system.ini"
GetSPKeyString$ = GetPPKeyString$(AppName$, KeyName$, Default$, FileName$)
End Function

Function GetWPKeyString$ (AppName$, KeyName$, Default$)
Size% = 255
ReturnString$ = Space$(Size%)
ValidLength% = GetProfileString(AppName$, KeyName$, Default$, ReturnString$, Size%)
GetWPKeyString$ = Left$(ReturnString$, ValidLength%)
End Function

Function INISetup% (FileName$)
'this function checks to see if the ini file exists. if
'not it attempts to create it. returns false if it can't
INISetup% = False
If Dir$(FileName$) = "" Then    'not there then make
    On Error GoTo INIError
    FileNum% = FreeFile
    Open FileName$ For Output As FileNum%
    Close #FileNum%
    On Error GoTo 0
End If
INISetup% = True
Exit Function
INIError:
    Resume INIExit
INIExit:
End Function

Function IsWavePlay% ()
'this function makes sure the computer can play wave files
'it may be a little over kill. it just checks some key
'settings in the system.ini file. returns false if something
'needed is not there
IsWavePlay% = False     'assume no wave playing
Default$ = "nowave"
s$ = GetSPKeyString$("boot", "sound.drv", Default$)
If s$ = "nowave" Then Exit Function
s$ = GetSPKeyString$("boot", "drivers", Default$)
If s$ = "nowave" Then Exit Function
s$ = GetSPKeyString$("drivers", "wave", Default$)
If s$ = "nowave" Then Exit Function
s$ = GetSPKeyString$("mci", "WaveAudio", Default$)
If s$ = "nowave" Then Exit Function
IsWavePlay% = True
End Function

Function WritePPKeyString% (AppName$, KeyName$, SetName$, FileName$)
Dim DeleteIt As Long
DeleteIt = 0&
If SetName$ = "" Then       'Delete KeyName
    Result% = WritePrivateProfileString(AppName$, KeyName$, DeleteIt, FileName$)
ElseIf KeyName$ = "" Then   'delete section
    Result% = WritePrivateProfileString(AppName$, DeleteIt, "", FileName$)
Else
    Result% = WritePrivateProfileString(AppName$, KeyName$, SetName$, FileName$)
End If
WritePPKeyString% = Result%
End Function

Function WriteWPKeyString% (AppName$, KeyName$, SetName$)
Dim DeleteIt As Long
DeleteIt = 0&
If SetName$ = "" Then       'Delete KeyName
    Result% = WriteProfileString(AppName$, KeyName$, DeleteIt)
ElseIf KeyName$ = "" Then   'delete section
    Result% = WriteProfileString(AppName$, DeleteIt, "")
Else
    Result% = WriteProfileString(AppName$, KeyName$, SetName$)

End If
WriteWPKeyString% = Result%
End Function

