Option Explicit

    Type RECT
	Left As Integer
	Top As Integer
	Right As Integer
	Bottom As Integer
    End Type

    Global Const GWW_HINSTANCE = (-6)
    
    Global Const RDW_INVALIDATE = &H1
    Global Const RDW_ERASE = &H4
    Global Const RDW_ALLCHILDREN = &H80

    Global Const COLOR_BACKGROUND = 1
    Global Const COLOR_ACTIVECAPTION = 2
    
    Declare Function GetFreeSpace& Lib "Kernel" (ByVal wFlags%)
    Declare Function GetFreeSystemResources% Lib "User" (ByVal fuSysResource%)
    Declare Function GetWinFlags& Lib "Kernel" ()
    Declare Function GetVersion& Lib "Kernel" ()
    Declare Function GetModuleHandle% Lib "Kernel" (ByVal lpModuleName$)
    Declare Function LoadString% Lib "User" (ByVal hInstance%, ByVal wID%, ByVal lpBuffer$, ByVal nBufferMax%)
    Declare Function SelectObject% Lib "GDI" (ByVal hDC%, ByVal hObject%)
    Declare Function CreateSolidBrush% Lib "GDI" (ByVal crColor&)
    Declare Function DeleteObject% Lib "GDI" (ByVal hObject%)
    Declare Function GetDC% Lib "User" (ByVal hWnd%)
    Declare Sub GetWindowRect Lib "User" (ByVal hWnd%, lpRect As RECT)
    
    Declare Sub InflateRect Lib "User" (lpRect As RECT, ByVal X%, ByVal Y%)
    Declare Function GetDesktopWindow% Lib "User" ()
    Declare Function CreateRectRgnIndirect% Lib "GDI" (lpRect As RECT)
    Declare Function RedrawWindow% Lib "User" (ByVal hWnd%, lprcUpdate As RECT, ByVal hrgnUpdate%, ByVal fuRedraw%)
    Declare Function FrameRgn% Lib "GDI" (ByVal hDC%, ByVal hRgn%, ByVal hBrush%, ByVal nWidth%, ByVal nHeight%)
    Declare Function GetSysColor& Lib "User" (ByVal nIndex%)
    
    Declare Function Rectangle% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
    Declare Function ReleaseDC% Lib "User" (ByVal hWnd%, ByVal hDC%)
    Declare Function GetWindowsDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
    Declare Function GetSystemDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
    Declare Function GetCurrentTask% Lib "Kernel" ()
    Declare Function GetModuleFileName% Lib "Kernel" (ByVal hModule%, ByVal lpFilename$, ByVal nSize%)
    Declare Function GetWindowWord% Lib "User" (ByVal hWnd%, ByVal nIndex%)
    Declare Function ExtractIcon% Lib "Shell" (ByVal hInst%, ByVal FileName$, ByVal iIcon%)
    Declare Function DestroyIcon% Lib "user" (ByVal hIcon%)
    Declare Function GlobalSize& Lib "kernel" (ByVal hGlobal%)
    Declare Function GlobalLock& Lib "kernel" (ByVal hGlobal%)
    Declare Function GlobalUnlock% Lib "kernel" (ByVal hGlobal%)
    Declare Sub hmemcpy Lib "kernel" (ByVal hpDest&, ByVal hpSource&, ByVal cbCopy&)

Function AppIcon2Pic% (Pic As PictureBox)

    Dim hIcon%
    Dim Rc%
    Dim hInst%

    hInst% = GetWindowWord%(Pic.hWnd, GWW_HINSTANCE)
    
    hIcon% = ExtractIcon%(hInst%, ExeName$(hInst%), 0)
    If hIcon% Then
	AppIcon2Pic% = CopyIcon%(hIcon%, (Pic.Picture))
	Rc% = DestroyIcon%(hIcon%)
    End If

End Function

Sub ClearDesktop (MyRect As RECT)
    
    Dim hDeskTop%
    Dim hDeskRgn%
    Dim ret%
    
    hDeskTop% = GetDesktopWindow%()
    hDeskRgn% = CreateRectRgnIndirect%(MyRect)
    If hDeskRgn% Then
	ret% = RedrawWindow%(hDeskTop%, MyRect, hDeskRgn%, RDW_ERASE + RDW_INVALIDATE + RDW_ALLCHILDREN)
	ret% = DeleteObject%(hDeskRgn%)
    End If

End Sub

Function CopyIcon% (hSource%, hDest%)
    
'~~~~~ Copies the icon from *hSource to *hDest, provided the
'~~~~~ memory blocks at *hSource and *hDest are the same size.
'~~~~~ hSource and hDest are Handles to Icons
    
    Dim sizeSource&, sizeDest&
    Dim fpSource&, fpDest&
    Dim Rc%
    
    CopyIcon% = False
    
    ' get size of memory blocks
    sizeSource& = GlobalSize&(hSource%)
    sizeDest& = GlobalSize&(hDest%)
    
    If sizeDest& <> sizeSource& Then
	If sizeSource& <> 288 Then  ' not a monochrome icon
	    Exit Function
	End If
    End If
    
    ' lock memory and get far pointers to Source & Destination
    fpSource& = GlobalLock&(hSource%)
    fpDest& = GlobalLock&(hDest%)
    
    ' copy Source to Destination
    hmemcpy fpDest&, fpSource&, sizeSource&
    
    ' unlock memory
    Rc% = GlobalUnlock%(hDest)
    Rc% = GlobalUnlock%(hSource)

    CopyIcon% = True

End Function

Function ExeName$ (hInst%)
    
    Dim Temp$
    Dim NameLen%
    
    Temp$ = String(255, Chr$(0))
    NameLen% = GetModuleFileName%(hInst%, Temp$, Len(Temp$))
    If NameLen% Then
	ExeName$ = Left$(Temp$, NameLen%)
    Else
	ExeName$ = "<Unknown>"
    End If

End Function

Function FormatLong$ (TheNum&)
    
    Dim TheStr$

    TheStr$ = Space$(11)

    RSet TheStr$ = Format$(TheNum&, "###,###,##0")

    FormatLong$ = TheStr$

End Function

Sub FormCenter (Frm As Form)
    
    Dim TheTop%, TheLeft%

    TheTop% = (Screen.Height - Frm.Height) / 2
    TheLeft% = (Screen.Width - Frm.Width) / 2

    Frm.Move TheLeft%, TheTop%

End Sub

Sub FormExplode (Frm As Form)

' "explodes" a form by drawing successively larger rectangles,
' using the form's background color, to fill the form area.
' Should be called prior to show method

'~~~~~ Number of pixels to increase/decrease each time.
'~~~~~ Smaller sizes result in a slower but smoother "explosion."
    Const STEP_SIZE = 2

    Dim MyRect As RECT
    Dim XLimit%
    Dim YLimit%
    Dim TheWidth%
    Dim TheHeight%
    Dim XInflate%
    Dim YInflate%
    Dim hDCScreen%
    Dim hBrush%
    Dim OldObj%
    Dim ret%

'~~~~~ How big is the form?
    GetWindowRect Frm.hWnd, MyRect

'~~~~~ We need to stay within this boundary
    XLimit% = MyRect.Left%
    YLimit% = MyRect.Top%
    
'~~~~~ Determine the rectangle at the center of the form
    TheWidth% = MyRect.Right% - MyRect.Left%
    TheHeight% = MyRect.Bottom% - MyRect.Top%
    InflateRect MyRect, (TheWidth% \ 2) * -1, (TheHeight% \ 2) * -1

'~~~~~ Get right proprtion of vertical and horizontal
'~~~~~ increments
    If TheWidth% > TheHeight% Then
	XInflate% = STEP_SIZE
	YInflate% = XInflate% * (TheWidth% / TheHeight%)
    Else
	YInflate% = STEP_SIZE
	XInflate% = YInflate% * (TheHeight% / TheWidth%)
    End If

'~~~~~ Get the screen's device context.
    hDCScreen% = GetDC%(0)

    If hDCScreen% Then
    '~~~~~ Create a solid brush that uses the form's background color.
	hBrush% = CreateSolidBrush%(Frm.BackColor)
	If hBrush% Then
	    OldObj% = SelectObject%(hDCScreen%, hBrush%)
	'~~~~~ Draw successively larger rectangles
	    Do While (MyRect.Left% > XLimit%) And (MyRect.Top% > YLimit%)
		ret% = Rectangle%(hDCScreen%, MyRect.Left%, MyRect.Top%, MyRect.Right%, MyRect.Bottom%)
		InflateRect MyRect, XInflate%, YInflate%
	    Loop
	'~~~~~ Restore the DC
	    If OldObj% Then
		OldObj% = SelectObject%(hDCScreen%, OldObj%)
	    End If
	'~~~~~ Delete the brush
	    ret% = DeleteObject%(hBrush%)
	End If
    '~~~~~ Release the device context and brush
	ret% = ReleaseDC%(0, hDCScreen%)
    End If
    
End Sub

Sub FormImplode (Frm As Form)

' "implodes" a form by drawing successively smaller rectangles,
' using the form's background color
' Should be called instead of Hide method

'~~~~~ Number of pixels to increase/decrease each time.
'~~~~~ Smaller sizes result in a slower but smoother "implosion."
    Const STEP_SIZE = 3

    Dim MyRect As RECT
    Dim SaveRect As RECT
    Dim XLimit%
    Dim YLimit%
    Dim TheWidth%
    Dim TheHeight%
    Dim XInflate%
    Dim YInflate%
    Dim XBorder%
    Dim YBorder%
    Dim hDeskTop%
    Dim hDCScreen%
    Dim hBrush%
    Dim hBrush2%
    Dim hBrush3%
    Dim hDeskRgn%
    Dim Clr&
    Dim OldObj%
    Dim ret%

'~~~~~ How big is the form?
    GetWindowRect Frm.hWnd, MyRect
    SaveRect = MyRect
    
'~~~~~ Determine the rectangle at the center of the form
    TheWidth% = MyRect.Right% - MyRect.Left%
    TheHeight% = MyRect.Bottom% - MyRect.Top%
    InflateRect MyRect, (TheWidth% \ 2) * -1, (TheHeight% \ 2) * -1

'~~~~~ This is as far as we will go
    XLimit% = MyRect.Left%
    YLimit% = MyRect.Top%

    MyRect = SaveRect
    
'~~~~~ Get right proprtion of vertical and horizontal
'~~~~~ increments
    If TheWidth% > TheHeight% Then
	XInflate% = STEP_SIZE
	YInflate% = XInflate% * (TheWidth% / TheHeight%)
    Else
	YInflate% = STEP_SIZE
	XInflate% = YInflate% * (TheHeight% / TheWidth%)
    End If

    XBorder% = XInflate%
    YBorder% = YInflate%

'~~~~~ Cause us to decrease in size
    XInflate% = XInflate% * -1
    YInflate% = YInflate% * -1

'~~~~~ Get the screen's device context.
    'hDeskTop% = GetDesktopWindow%()
    hDeskTop% = 0
    hDCScreen% = GetDC%(hDeskTop%)

    If hDCScreen% Then
    '~~~~~ Need a brush that looks like the form's background.
	hBrush% = CreateSolidBrush%(Frm.BackColor)
    '~~~~~ Another that matche the background of the desktop
	Clr& = GetSysColor&(COLOR_BACKGROUND)
	hBrush2% = CreateSolidBrush%(Clr&)
    '~~~~~ And one that looks like the form's border.
	Clr& = GetSysColor&(COLOR_ACTIVECAPTION)
	hBrush3% = CreateSolidBrush%(Clr&)
    '~~~~~ If we have all of them
	If hBrush% And hBrush2% And hBrush3% Then
	'~~~~~ Set up to draw "form background"
	    OldObj% = SelectObject%(hDCScreen%, hBrush%)
	'~~~~~ Make it look like a form
	    ret% = Rectangle%(hDCScreen%, MyRect.Left%, MyRect.Top%, MyRect.Right%, MyRect.Bottom%)
	    hDeskRgn% = CreateRectRgnIndirect%(MyRect)
	    If hDeskRgn% Then
		ret% = FrameRgn%(hDCScreen%, hDeskRgn%, hBrush3%, XBorder%, YBorder%)
		ret% = DeleteObject%(hDeskRgn%)
	    End If
	'~~~~~ Now that we covered it, hide the form
	    Frm.Hide
	'~~~~~ Draw successively larger rectangles
	    Do While (MyRect.Left% < XLimit%) And (MyRect.Top% < YLimit%)
	    
	    '~~~~~ Make the old rect look like the desktop
		hDeskRgn% = CreateRectRgnIndirect%(MyRect)
		If hDeskRgn% Then
		    ret% = FrameRgn%(hDCScreen%, hDeskRgn%, hBrush2%, XBorder%, YBorder%)
		    ret% = DeleteObject%(hDeskRgn%)
		End If
	    '~~~~~ Crank it down one step
		InflateRect MyRect, XInflate%, YInflate%
	    '~~~~~ Make it look like a form
		ret% = Rectangle%(hDCScreen%, MyRect.Left%, MyRect.Top%, MyRect.Right%, MyRect.Bottom%)
		hDeskRgn% = CreateRectRgnIndirect%(MyRect)
		If hDeskRgn% Then
		    ret% = FrameRgn%(hDCScreen%, hDeskRgn%, hBrush3%, XBorder%, YBorder%)
		    ret% = DeleteObject%(hDeskRgn%)
		End If
	    Loop

	    ClearDesktop SaveRect

	    '~~~~~ Make the old rect look like the desktop
		hDeskRgn% = CreateRectRgnIndirect%(MyRect)
		If hDeskRgn% Then
		    ret% = FrameRgn%(hDCScreen%, hDeskRgn%, hBrush2%, XBorder%, YBorder%)
		    ret% = DeleteObject%(hDeskRgn%)
		End If
	
	'~~~~~ Restore the DC
	    If OldObj% Then
		OldObj% = SelectObject%(hDCScreen%, OldObj%)
	    End If
	'~~~~~ Delete the brushes
	    ret% = DeleteObject%(hBrush%)
	    ret% = DeleteObject%(hBrush2%)
	    ret% = DeleteObject%(hBrush3%)
	End If
    '~~~~~ Release the device context and brush
	ret% = ReleaseDC%(hDeskTop%, hDCScreen%)
    End If

End Sub

Sub main ()

    Dim ProductName$
    Dim ProductVersion$
    Dim Copyright$

    ProductName$ = "AboutWin"
    ProductVersion$ = "1.1a"
    Copyright$ = "Copyright  1994 by XYZ."
    
    Load frmAbout
    frmAbout!lblVersion.Caption = ProductName$ & " Version " & ProductVersion$ & " is licensed to:"
    frmAbout!lblCopyright.Caption = Copyright$
    Call FormExplode(frmAbout)
    frmAbout.Show

End Sub

Sub ShowAbout (ProductId$, Copyright$)
    
    Load frmAbout
    Call FormExplode(frmAbout)
    frmAbout.Show

End Sub

Function SysDir$ ()
    
    Dim Temp$
    Dim NameLen%
    
    Temp$ = String(255, Chr$(0))
    NameLen% = GetSystemDirectory%(Temp$, Len(Temp$))
    If NameLen% Then
	SysDir$ = Left$(Temp$, NameLen%)
    Else
	SysDir$ = "<Unknown>"
    End If

End Function

Function WinDir$ ()
    
    Dim Temp$
    Dim NameLen%
    
    Temp$ = String(255, Chr$(0))
    NameLen% = GetWindowsDirectory%(Temp$, Len(Temp$))
    If NameLen% Then
	WinDir$ = Left$(Temp$, NameLen%)
    Else
	WinDir$ = "<Unknown>"
    End If

End Function

