Option Explicit
Global Const WF_CPU286 = &H2
Global Const WF_CPU386 = &H4
Global Const WF_CPU486 = &H8
Global Const WF_80x87 = &H400
Global Const WF_STANDARD = &H10
Global Const WF_ENHANCED = &H20
Global Const WF_WINNT = &H4000
Global Const WHITE = &HFFFFFF
Global Const DARK_GRAY = &H808080
Type SYSHEAPINFO
   dwSize As Long
   wUserFreePercent As Integer
   wGDIFreePercent As Integer
   hUserSegment As Integer
   hGDISegment As Integer
End Type
Declare Function GetVersion% Lib "Kernel" ()
Declare Function GetWinFlags& Lib "Kernel" ()
Declare Function GetFreeSpace& Lib "Kernel" (ByVal wFlags%)
Declare Function GlobalCompact& Lib "Kernel" (ByVal dwMinFree&)
Declare Function SystemHeapInfo% Lib "toolhelp.dll" (shi As SYSHEAPINFO)
Declare Function GetSystemDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
Global gnProgVer!, gnDBVer!
Global gsLicensedUser$, gsDataPath$, gsProgSer$
Global gvDateLastCleanup As Variant

Sub Center (AnyForm As Form)
   AnyForm.Left = (Screen.Width - AnyForm.Width) / 2
   AnyForm.Top = (Screen.Height - AnyForm.Height) / 2
End Sub

Sub MakeAll3D (AnyForm As Form)
   'Global Const WHITE = &HFFFFFF
   'Global Const DARK_GRAY = &H808080
   Dim i%
   For i = 0 To (AnyForm.Controls.Count - 1)
      If TypeOf AnyForm.Controls(i) Is ComboBox Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is CommandButton Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is DirListBox Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is DriveListBox Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is FileListBox Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is HScrollBar Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is Label Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is ListBox Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is PictureBox Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is TextBox Then
         MakeCtl3D AnyForm.Controls(i)
      ElseIf TypeOf AnyForm.Controls(i) Is VScrollBar Then
         MakeCtl3D AnyForm.Controls(i)
      End If
   Next i
End Sub

Sub MakeCtl3D (TargetControl As Control)
   Dim iControlTop%, iControlLeft%, iControlRight%, iControlBottom%
   Dim OriginalDrawWidth%, OriginalAutoRedraw%, iOriginalScaleMode%
   OriginalDrawWidth = TargetControl.Parent.DrawWidth    'Save Original DrawWidth
   OriginalAutoRedraw = TargetControl.Parent.AutoRedraw  'Save Original AutoRedraw
   iOriginalScaleMode = TargetControl.Parent.ScaleMode   'Save Original ScaleMode
   TargetControl.Parent.DrawWidth = 1                    'Lines will be draw 1 unit thick
   TargetControl.Parent.AutoRedraw = True                'Let Windows automatically redraw
   TargetControl.Parent.ScaleMode = 1                    'Set ScaleMode to Twips
   iControlTop = TargetControl.Top - Screen.TwipsPerPixelY
   iControlLeft = TargetControl.Left - Screen.TwipsPerPixelX
   iControlRight = TargetControl.Left + TargetControl.Width
   iControlBottom = TargetControl.Top + TargetControl.Height
   TargetControl.Parent.Line (iControlLeft, iControlTop)-(iControlRight, iControlTop), DARK_GRAY
   TargetControl.Parent.Line (iControlLeft, iControlTop)-(iControlLeft, iControlBottom), DARK_GRAY
   TargetControl.Parent.Line (iControlLeft, iControlBottom)-(iControlRight + Screen.TwipsPerPixelY, iControlBottom), WHITE
   TargetControl.Parent.Line (iControlRight, iControlTop)-(iControlRight, iControlBottom + Screen.TwipsPerPixelX), WHITE
   TargetControl.Parent.DrawWidth = OriginalDrawWidth    'Reset Original DrawWidth
   TargetControl.Parent.AutoRedraw = OriginalAutoRedraw  'Reset Original AutoRedraw
   TargetControl.Parent.ScaleMode = iOriginalScaleMode   'Reset Original ScaleMode
End Sub

Sub MakeFrm3D (TargetForm As Form)
   Dim iFormTop%, iFormLeft%, iFormRight%, iFormBottom%
   Dim OriginalDrawWidth%, OriginalAutoRedraw%, iOriginalScaleMode%
   OriginalDrawWidth = TargetForm.DrawWidth    'Save Original DrawWidth
   OriginalAutoRedraw = TargetForm.AutoRedraw  'Save Original AutoRedraw
   iOriginalScaleMode = TargetForm.ScaleMode   'Save Original ScaleMode
   TargetForm.DrawWidth = 1                    'Lines will be drawn 1 unit thick
   TargetForm.AutoRedraw = True                'Let Windows automatically repaint lines
   TargetForm.ScaleMode = 1                    'Set ScaleMode to Twips
   iFormTop = 0
   iFormLeft = 0
   iFormRight = TargetForm.ScaleWidth - Screen.TwipsPerPixelY
   iFormBottom = TargetForm.ScaleHeight - Screen.TwipsPerPixelX
   TargetForm.Line (iFormLeft, iFormTop)-(iFormRight, iFormTop), WHITE
   TargetForm.Line (iFormLeft, iFormTop)-(iFormLeft, iFormBottom), WHITE
   TargetForm.Line (iFormLeft, iFormBottom)-(iFormRight + Screen.TwipsPerPixelY, iFormBottom), DARK_GRAY
   TargetForm.Line (iFormRight, iFormTop)-(iFormRight, iFormBottom + Screen.TwipsPerPixelX), DARK_GRAY
   TargetForm.DrawWidth = OriginalDrawWidth    'Reset Original DrawWidth
   TargetForm.AutoRedraw = OriginalAutoRedraw  'Reset Original AutoRedraw
   TargetForm.ScaleMode = iOriginalScaleMode   'Reset Original ScaleMode
End Sub

Function WindowsDir$ ()
   WindowsDir = Environ$("windir")
End Function

