/****************************************************************************
**      DISCLAIMER
**
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:   Volume.c
**
**   Desc: This program will find the volume information that is usually
**         reported in chkvol.  Or if the path to a directory is added on the
**         command line you can get back that directories information instead.
**         You need to pass in the server name volume name and/or the name of
**         a directory in the volume.
**
**
*/

/***************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

  /*------------------------------------------------------------------
  **   ANSI
  */
  #define DEBUG   /* rem out this line for debug info to print */

  #include <stdio.h>         /* printf()          */
  #include <stdlib.h>        /* exit()            */
  #include <string.h>        /* strcpy() strupr() */
  #include <conio.h>         /* clrscr()          */
  #include <ctype.h>         /* toupper           */

  /*------------------------------------------------------------------
  **   NetWare
  */
  #include <nwcalls.h>

/****************************************************************************
**   Program Start  Complete program in main
*/

void main (int argc, char *argv[])
{
  int               ccode;
  NWVOL_NUM         volNumber;
  char              volName[48];
  char              serverName[48];
  char              directory[128];
  DIR_SPACE_INFO    spaceInfo;
  NWCONN_HANDLE     connID;
  NWDIR_HANDLE      dirHandle;
  NWACCESS_RIGHTS   rightsMask;
  int               blocksize;
  unsigned long     totalsize,
                    availsize,
                    purgesize,
                    notyetpurgesize;


  ccode=NWCallsInit(NULL,NULL);
  if (ccode)
     exit(1);

  strcpy(serverName,strupr(argv[1]));

  if (argc>=2){
     ccode=NWGetConnectionHandle(serverName,NULL,&connID,NULL);
     if (ccode){
        printf("NWGetConnectionHandle failed with error code %x\n",ccode);
        exit (ccode);
     }
  }
  switch(argc){
     case 3:
        strcpy(volName,strupr(argv[2]));
        /* get the volume number  */
        ccode = NWGetVolumeNumber(connID, volName, &volNumber);
        if (ccode){
           printf("NWGetVolumeNumber fatal error= %X\n",ccode);
           exit(1);
        }

        dirHandle=0; /* volume info will be returned */
        break;
     case 4:
        strcpy(volName,strupr(argv[2]));
        strcpy(directory,strupr(argv[3]));
        volNumber=0; /* directory info will be returned */

        /*----------------------------------------------------------------
        **  The following code will allocate a temporary directory handle 
        **  for use in the NWGetDirSpaceInfo() function
        */

        ccode = NWAllocTemporaryDirectoryHandle(  connID,
                                                  NULL,
                                                  directory,
                                                  &dirHandle,
                                                  &rightsMask);
        if (ccode){
           printf("NWAllocTemproaryDirectoryHandle failed error code= %X\n",
                    ccode);
           exit(1);
        }
        volNumber = 0; /* because only dir info is being gotten. */
        break;

     default:
        clrscr();
        printf("USAGE: volume <server name> <volume name> <directory>\n");
        printf("\n       Directory information EXAMPLE:\n");
        printf("            volume server1 sys sys:users\\jsmith\n");
        printf("\n       Volume information EXAMPLE:\n");
        printf("            volume server1 sys ");
        exit(1);
  }

  /*----------------------------------------------------------------------
  ** The code dealing with NWGetDirSpaceInfo is dealing with block
  ** information in 32bit mode on any NetWare Server. 
  **     If dealing only in 16bit mode you can use the call 
  ** NWGetVolumeInfoWithNumber() but it will not work properly on any 
  ** drive that is greater than 1 gig this call was originally written to 
  ** work only on 256 meg volumes (2.x)  and therefore shouldn't be used on
  ** 3.x and 4.x any volume greater than 256 meg.
  **
  ** NOTE: if you take the sectors per Block say 8 and multiple by 512 (the
  ** size of a sector you will get the block size on the server.
  ** The best thing to do is 8/2=4k block size then you can multiply
  ** 4XtotalBlocks to come up with the total bytes available etc.
  **
  ** NOTE: If the dirHandle is passed in as 0 then volume info is returned
  **       but if the volNumber is 0 then directory info is returned.
  */


  ccode = NWGetDirSpaceInfo(connID,dirHandle,volNumber,&spaceInfo);

  blocksize=spaceInfo.sectorsPerBlock/2;

  totalsize=spaceInfo.totalBlocks * blocksize;
  availsize=spaceInfo.availableBlocks * blocksize;
  purgesize =spaceInfo.purgeableBlocks * blocksize;
  notyetpurgesize = spaceInfo.notYetPurgeableBlocks * blocksize;



  if (ccode){
     printf("NWGetDirSpaceInfo fatal error= %X\n",ccode);
     exit(1);
  }
  /*------------------------------------------------------------------------
  **  If purgeableBlocks is 0 then dirHandle is not 0 and directory info
  **  will be returned if purgeable Blocks is non 0 then volume inforamtion
  **  will be returned.
  */
  if (spaceInfo.purgeableBlocks==0){

     clrscr();
     printf("             DIRECTORY INFORMATION\n\n");
#ifndef DEBUG
     printf("Directory Name %s\n",directory);
     printf("totalBlocks %ld\n",spaceInfo.totalBlocks);
     printf("availableBlocks %ld\n",spaceInfo.availableBlocks);

     printf("purgeable Blocks = %ld\nnot yet purgeable blocks = %ld\n",
              spaceInfo.purgeableBlocks,
              spaceInfo.notYetPurgeableBlocks);

     printf("total dir entries = %ld\navailable dir entries = %ld\n",
              spaceInfo.totalDirEntries,
              spaceInfo.availableDirEntries);

     printf("sectors per block = %d\n",spaceInfo.sectorsPerBlock);
#endif

     printf("Total dir space:                    %ld\t K Bytes\n",totalsize);

     printf("Space used by files:                %ld\t K Bytes\n",totalsize-
              (availsize+purgesize-notyetpurgesize));

     printf("Space remaining on dir:             %ld\t K Bytes\n",availsize+
              purgesize-notyetpurgesize);

  }
  else{
     clrscr();
     printf("             VOLUME INFORMATION\n\n");
     printf("VolName = %s\n", volName);

#ifndef DEBUG
     printf("totalBlocks %ld\n",spaceInfo.totalBlocks);
     printf("availableBlocks %ld\n",spaceInfo.availableBlocks);

     printf("purgeable Blocks = %ld\nnot yet purgeable blocks = %ld\n",
              spaceInfo.purgeableBlocks,
              spaceInfo.notYetPurgeableBlocks);

     printf("total dir entries = %ld\navailable dir entries = %ld\n",
              spaceInfo.totalDirEntries,
              spaceInfo.availableDirEntries);

     printf("sectors per block = %d\n",spaceInfo.sectorsPerBlock);
#endif
     printf("Total volume space:                 %ld\t K Bytes\n",totalsize);
     printf("Space used by files:                %ld\t K Bytes\n",totalsize-
              (availsize+purgesize-notyetpurgesize));

     printf("Space in use by deleted files:      %ld\t K Bytes\n", purgesize+
              notyetpurgesize);

     printf("Space available from deleted files: %ld\t K Bytes\n", purgesize-
              notyetpurgesize);

     printf("Space remaining on volume:          %ld\t K Bytes\n",availsize+
              purgesize-notyetpurgesize);

  }
}
