/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.
**   
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**   File:   SUBMTJOB.C
**   
**   Desc:   Sample Code for NWCloseFileAndStartQueueJob2.
**   
**       This code will open a filehandle for a print job on the server and
**       queue specified on the command line.  It will then write a line of
**       data "this is a test" to the file and close it so it will then be
**       printed out to the printer serviced by that queue.
**
**
**
**   Parameter descriptions:    > input
**                              < output
**
**   Programmers:
**
**   Ini   Who      Company                  Firm
**   -----------------------------------------------------------------------
**   ARM   A. Ray Maxwell   Novell Developer Support.
**
**   History:
**
**   When      Who   What
**   -----------------------------------------------------------------------
**   10-12-94   ARM   First code.
*/


/****************************************************************************
**   Include headers, macros, etc.
*/   
   /*------------------------------------------------------------------------
   **   Borland C.
   */
   #include <stdlib.h>  /* exit()    */
   #include <stdio.h>   /* printf()  */
   #include <string.h>  /* strupr()  */
   #include <io.h>      /* write()   */
   #include <conio.h>   /* clrscr()  */
  
   /*------------------------------------------------------------------------
   **   NetWare Library
   */
   #include <nwcalls.h>

   /*------------------------------------------------------------------------
   **   defines
   */
   #define NWDOS
   #define   IDK_1          0x0100
   #define   IDK_2          0x0200
   #define   KEEP_ON        0x0400
   #define   NO_FORM_FEED   0x0800
   #define   NOTIFICATION   0x1000
   #define   DELETE_FILE    0x2000
   #define   EXPAND_TABS    0x4000
   #define   PRINT_BANNER   0x8000


/****************************************************************************
** Global variables.
*/
/*========================================================
  This structure is overlayed on the QMS
  WQueueJobStruct.clientRecordArea to define a print job.
  I is not used in any of the print services APIs.
  (Formerly called NWPS_PJob.)
NOTE: This structure is in NWPS_JOB.h in the volume one or v10e SDK
  ========================================================*/


typedef struct {
  BYTE                  versionNumber;
  BYTE                  tabSize;
  WORD                  numberOfCopies;
  WORD                  printControlFlags;
  WORD                  maxLinesPerPage;
  WORD                  maxCharsPerLine;
  BYTE                  formName[13];
  BYTE                  reserve[9];
  BYTE                  bannerNameField[13];
  BYTE                  bannerFileField[13];
  BYTE                  headerFileName[14];
  BYTE                  directoryPath[80];
} NWPS_ClientRecord;


/****************************************************************************
** Main program start.
*/
void main(int argc, char *argv[]){

  NWCCODE ccode;
  NWCONN_HANDLE connHandle;
  NWOBJ_ID printQID;
  NWQueueJobStruct jobInfo;
  NWFILE_HANDLE jobFile;
  NWPS_ClientRecord *psInfo;        /* this is the struct pointer for the
                                        clientRecordArea in jobInfo         */
  char server[48];
  char queueName[48];

  int   rVal;
  int   x, cnt;

  if (argc < 2){
     clrscr();
     printf("USAGE: QUEUE <serverName> <queueName>\n");
     goto EXIT;
  }
  ccode = NWCallsInit(NULL, NULL);
  
  if(ccode)
     exit(1);

  strcpy(server,strupr(argv[1]));
  strcpy(queueName,strupr(argv[2]));
  /*------------------------------------------------------------------------
  ** Get the connection handle to the file server.  Must already
  ** be attached to this file server
  */

  ccode = NWGetConnectionHandle(
          /* > servername        */ server,
          /*   Novell Reserved1  */ 0,
          /* < connection Handle */ &connHandle,
          /*   Novell Reserved2  */ NULL);

  switch(ccode)
     {
     case SUCCESSFUL:
        break;
        
     case INVALID_CONNECTION:
        printf("ERROR:  Invalid connection.\n");
        goto EXIT;
        
     case 0x880F:
        printf("ERROR:  You are not connected to fileserver [%s]!\n", server);
        goto EXIT;
     
     default:
        printf("ERROR:  Unknown error NWGetConnectionHandle:0x%04X\n", ccode);
        goto EXIT;
     }
  
  /*------------------------------------------------------------------------
  ** Get the object ID for the desired print queue to print to.
  */
  ccode=NWGetObjectID(
        /*   >   connection   */   connHandle,
        /*   >   objectName   */   queueName,
        /*   >   objectType   */   OT_PRINT_QUEUE,
        /*   <   objectID     */   &printQID);

  switch(ccode)
     {
     case SUCCESSFUL:
        break;
        
     case INVALID_CONNECTION:
        printf("ERROR:  Invalid connection.\n");
        goto EXIT;
     
     default:
        printf("ERROR:  Unknown error NWGetObjectID: %d\n", ccode);
        goto EXIT;
     }
  
  /*------------------------------------------------------------------------
  **   Fill out jobInfo structure.
  */
  memset(&jobInfo, 0x00, sizeof(jobInfo));   /* zero out structure */
   
  /*------------------------------------------------------------------------
  **   Wildcard: any print server may service this job.
  */
  
   jobInfo.targetServerID = 0xFFFFFFFFL;
  
   memset(jobInfo.targetExecutionTime, 0xFF, 6);   /* 0xFFFFFFFFFFFF: ASAP */
   jobInfo.jobControlFlags |= 0x10;
  
  /*------------------------------------------------------------------------
  **   Fill out NetWare Print Server specific information in the clientRecord
  ** Area of the jobInfo structure.
  */
  psInfo = (NWPS_ClientRecord *)(jobInfo.clientRecordArea);
  psInfo->versionNumber      =   0;
  psInfo->tabSize            =   8;
  psInfo->numberOfCopies     =   NWWordSwap(1);
  psInfo->printControlFlags  =   NO_FORM_FEED;
  psInfo->maxLinesPerPage    =   NWWordSwap(66);
  psInfo->maxCharsPerLine    =   NWWordSwap(132);
  psInfo->formName[0]        =   '\0';
  /* psInfo->reserved[9]; */
  strcpy(psInfo->bannerNameField,"BannerName");
  strcpy(psInfo->bannerFileField,"BannerFile");
  strcpy(psInfo->headerFileName, "HeaderName");   
  psInfo->directoryPath[0]   =   '\0';
  
  /*------------------------------------------------------------------------
  ** Create a queue file using the known ID and connection handle
  */
  ccode=NWCreateQueueFile2(
     /* >  connection      */ connHandle,
     /* >  queueID         */ printQID,
     /* <> jobStructure    */ &jobInfo,
     /* <  fileHandle      */ &jobFile
     );
  switch(ccode)
     {
     case SUCCESSFUL:
        break;
     
     case INVALID_CONNECTION:
        printf("ERROR:  Invalid connection.\n");
        goto EXIT;
     
     case 0x89D3:
        printf("ERROR:  NO rights to print queue: %s.\n", queueName);
        goto EXIT;
     
     default:
        printf("ERROR:  Unknown error NWCreateQueueFile2: 0x%04X\n", ccode);
        goto EXIT;
     }
  
  
  /*------------------------------------------------------------------------
  ** Print job
  */
  write(jobFile,"this is a test",14);
  
  
  /*------------------------------------------------------------------------
  ** Close print job now that data has been sent.
  */
  ccode=NWCloseFileAndStartQueueJob2(
        /* >  connection  */   connHandle,
        /* >  queueID     */   printQID,
        /* >  jobNumber   */   jobInfo.jobNumber,
        /* >   fileHandle  */   jobFile);
  
  switch(ccode)
     {
     case SUCCESSFUL:
        break;
     
     case DIRECTORY_FULL:
        printf("ERROR:  Queue directory full.\n");
        break;
     
     case ERR_Q_IO_FAILURE:
        printf("ERROR:  Queue I/O failure.\n");
        break;
     
     case ERR_NO_QUEUE:
        printf("ERROR:  No such queue.\n");
        break;
     
     case ERR_NO_Q_SERVER:
        printf("ERROR:  No queue server.\n");
        break;
     
     case ERR_NO_Q_RIGHTS:
        printf("ERROR: NO rights to print in queue.\n");
        break;
     
     case 0x89D4: /* ERR_QUEUE_FULL */
        printf("ERROR: Print queue full.\n");
        break;
     
     case ERR_NO_Q_JOB:
        printf("ERROR: Invalid job number specified.\n");
        break;
     
     case ERR_NO_Q_JOB_RIGHTS:
        printf("ERROR: NO rights to place a job into this queue\n.");
        break;
     
     case ERR_Q_IN_SERVICE:
        printf("ERROR: Queue being serviced now and not accepting jobs\n.");
        break;
     
     case ERR_Q_NOT_ACTIVE:
        printf("ERROR: Queue currently not active and not accepting jobs\n.");
        break;
     
     case ERR_Q_STN_NOT_SERVER:
        printf("ERROR:  The Queue Station is not a Server\n.");
        break;
     
     case ERR_Q_HALTED:
        printf("ERROR:  Queue is currently halted and not accepting jobs\n.");
        break;
     
     case ERR_Q_MAX_SERVERS:
        printf("ERROR:  Too many servers\n.");
        break;
     
     case   0x89FF:
        printf("ERROR:   General failure NWCloseFileAndStartQueueJob2\n.");
        break;                                                                  
     
     default:
        printf("Unknown error NWCloseFileAndStartQueueJob2: %d\n", ccode);
        break;
     }
  
  EXIT:
  
} 
