/****************************************************************************
**	File:	EDIT.C
**
**	Desc:	Sample SPX chat program.	
**
**		This Sample code demonstrates how to set up and use SPX
**		communications to communicate between 2 nodes.
**		
**		
**		
**
**		DISCLAIMER  
**  
**	Novell, Inc. makes no representations or warranties with respect to
**	any NetWare software, and specifically disclaims any express or
**	implied warranties of merchantability, title, or fitness for a
**	particular purpose.  
**
**	Distribution of any NetWare software is forbidden without the
**	express written consent of Novell, Inc.  Further, Novell reserves
**	the right to discontinue distribution of any NetWare software.
**	
**	Novell is not responsible for lost profits or revenue, loss of use
**	of the software, loss of data, costs of re-creating lost data, the
**	cost of any substitute equipment or program, or claims by any party
**	other than you.  Novell strongly recommends a backup be made before
**	any software is installed.   Technical support for this software
**	may be provided at the discretion of Novell.
**
**	Programmers:
**
**		Ini	Who						Firm
**		-----------------------------------------------------------------------
**		TDOC  Technical Documentation Team
**		KLB	Karl Bunnell				Novell Developer Support.
**
**	History:
**
**		When		Who	What
**		-----------------------------------------------------------------------
**		10-25-88	TDOC	First code.
**		01-27-95 KLB   Ported this example to the NetWare Client SDK
*/

/****************************************************************************
**	Include headers, macros, function prototypes, etc.
*/
	/*------------------------------------------------------------------------
	**	MACROS
	*/
	#define NWDOS


	/*------------------------------------------------------------------------
	**	ANSI
	*/
	#include <stdio.h>
	#include <dos.h>


	/*------------------------------------------------------------------------
	**	NetWare
	*/
	#include <nwcalls.h>
	#include <nwipxspx.h>
	#include "chat.h"


	/*------------------------------------------------------------------------
	**	Globals
	*/


	void 	Dispatcher();
	void 	DisplayChar();
	int 		InputChar();
	void 	DeleteChar();
	void 	DisplayOff();

	extern int	PRINT_FLAG,
				RECEIVE_FLAG;

	char	charBuffer;

	int 	sendRow = TOP_SEND_ROW,
			sendCol = FIRST_TEXT_COL,
			receiveRow = TOP_RECEIVE_ROW,
			receiveCol = FIRST_TEXT_COL;


void Dispatcher(key)
char	key;
{
	int		ccode;

	if (key == TAB)
		ClearSendBox();
	
	else if (key == ENTER)
	{
		sendRow++;
		if (sendRow > LAST_SEND_ROW) 
		{
			sendRow = LAST_SEND_ROW;
			ScrollUp (1, TOP_SEND_ROW, LAST_SEND_ROW, FIRST_TEXT_COL, LAST_TEXT_COL);
		}
		sendCol = FIRST_TEXT_COL;
		SetCursor(sendRow,sendCol);
	}
	
	else if (key == BACKSPACE)
	{
		if (sendCol > FIRST_TEXT_COL)
			DeleteChar (&sendCol, &sendRow);
	}
	
	else if ( key == 0 || (key > 6 && key < 20) )
	{
		key = 2;
		DisplayChar(key);
	}
	else
		DisplayChar(key);
	
	SendPacket(&key);
}						


void DisplayChar(key)
char	key;
{
	if(sendCol == LAST_TEXT_COL)
	{
		sendCol = FIRST_TEXT_COL;
		sendRow++;
		if (sendRow > LAST_SEND_ROW) 
		{
			sendRow = LAST_SEND_ROW;
			ScrollUp (1, TOP_SEND_ROW, LAST_SEND_ROW, FIRST_TEXT_COL, LAST_TEXT_COL);
		}
	}
	SetCursor(sendRow,sendCol++);
	WriteChar(key);
	SetCursor(sendRow,sendCol);
}


void DeleteChar(col,row)
int		*col, *row;
{
	--*col;
	SetCursor(*row, *col);
	WriteChar(' ');
	SetCursor(*row, *col);
}


