/****************************************************************************
**	File:	CHAT.C
**
**	Desc:	Sample SPX chat program.	
**
**			This Sample code demonstrates how to set up and use SPX
**			communications to communicate between 2 nodes.
**		
**		
**		
**
**		DISCLAIMER  
**  
**	Novell, Inc. makes no representations or warranties with respect to
**	any NetWare software, and specifically disclaims any express or
**	implied warranties of merchantability, title, or fitness for a
**	particular purpose.  
**
**	Distribution of any NetWare software is forbidden without the
**	express written consent of Novell, Inc.  Further, Novell reserves
**	the right to discontinue distribution of any NetWare software.
**	
**	Novell is not responsible for lost profits or revenue, loss of use
**	of the software, loss of data, costs of re-creating lost data, the
**	cost of any substitute equipment or program, or claims by any party
**	other than you.  Novell strongly recommends a backup be made before
**	any software is installed.   Technical support for this software
**	may be provided at the discretion of Novell.
**
**	Programmers:
**
**		Ini	Who						Firm
**		-----------------------------------------------------------------------
**		TDOC  Technical Documentation Team
**		KLB	Karl Bunnell				Novell Developer Support.
**
**	History:
**
**		When		Who	What
**		-----------------------------------------------------------------------
**		10-25-88	TDOC	First code.
**		01-27-95 KLB   Ported this example to the NetWare Client SDK
*/

/****************************************************************************
**	Include headers, macros, function prototypes, etc.
*/
	/*------------------------------------------------------------------------
	**	MACROS
	*/
	#define NWDOS


	/*------------------------------------------------------------------------
	**	ANSI
	*/
	#include <stdio.h>
	#include <string.h>


	/*------------------------------------------------------------------------
	**	NetWare
	*/
	#include <nwcalls.h>
	#include <nwipxspx.h>
	#include "chat.h"


	/*------------------------------------------------------------------------
	**	Globals
	*/
	extern	void	SendMessage();
	extern	void	TearDownConnection();
	extern	int 	PollForPacket();
	extern	void	SetUpSendECBs();
	extern	void	SetUpReceiveECBs();
	extern 	ECB	   *SetUpInitialECB();
	extern 	void	DrawScreen();
	extern	void	Dispatcher();
	extern 	void	ClearScreen();

	extern WORD		SPXConnectionNumber, Socket, connectionID,
				listeningConnection, preferredConnectionID;
	extern int		ACTIVE_CONNECTION;


	char	hangUp[] = "I hung up.  Call me back when you get a chance.";
	NWCONN_HANDLE	connHandle;


void main(argc,argv)
int		argc;
char	*argv[];
{
	int	   	ccode;
	NWCCODE		cCode;
	char	key, userName[48], callerName[48], currentServer[48],
			preferredServer[48], *command;
	NWFLAGS	result;
			
 /* Test for the correct number of arguments on command line */ 
	if (argc != 2) 
	{
		printf ("CHAT.EXE v1.01\n");
		printf ("by Novell Technical Documentation\n\n");
		printf ("Format: Chat fileserver/userName\n");
		printf ("Example: Chat Server_1/Rasputin\n");
		exit (); 
	}


	NWCallsInit(NULL, NULL);

	command = argv[1];
	ParseDestination (preferredServer, userName, command);

//	CheckServer (currentServer, preferredServer);

	cCode = NWGetConnectionHandle(
				/* server name    */ preferredServer,
				/* reserved       */ 0,
				/* conn handle    */ &connHandle,
				/* reserved       */ 0
			   );

	GetConnectionAndNode (preferredServer, userName, &listeningConnection);

	ccode = SayHello (&listeningConnection);
	if (ccode)
		Error ("Sorry, there's no answer.");

 /* Format the screen */
	DrawScreen ();

 /* Establish a connection */
	ccode =	EstablishCallingSide ();
	if (ccode)
	{
		NWSendBroadcastMessage (connHandle, hangUp, 1, &listeningConnection, &result);
		Error ("So much for that.");
	}

 /* While connection is active, poll for and send messages */
 	Update ("Connection is established.");
	while (ACTIVE_CONNECTION)
	{
 		while (!kbhit())
		{
			if ( (ACTIVE_CONNECTION = PollForPacket()) == 0)
			{
				Update ("Your partner hung up.  Press ESCAPE twice to close.");
				break;
			}
		}

	 /* A key was hit */
	 	if ( (key = getch()) == ESCAPE)
		{
			Update ("Press ESCAPE to hang up / ENTER to resume.");
			if ( (key = getch()) == ESCAPE)
			{
				Update ("Closing connection...");
				ACTIVE_CONNECTION = 0;
				break;
			}
			Update ("Connection is active.");
		}
		else
			Dispatcher (key);		
 	}

	TearDownConnection ();

//	if (preferredConnectionID);
//		SetPreferredConnectionID (connectionID);

}


EstablishCallingSide ()
{
	int		ccode, returnCode = 0, keepTrying = 1;
	char	key;
	BYTE	retryCount = 0x00, watchDog = 0x00, majRevNumber, minRevNumber;
	WORD	tempIDNumber, maxConnections, maxConnAvailable;
	ECB		*initialECB;

 /* See if SPX is installed */
	ccode =	SPXInitialize (&majRevNumber,&minRevNumber,&maxConnections,
				&maxConnAvailable);
	if (ccode != SPX_INSTALLED)
		Error ("SPX is not installed on this machine.");

 /* Open an IPX socket */
	ccode = IPXOpenSocket ( (BYTE *)&Socket, (BYTE)0 );
	if (ccode)
		Error ("Unable to open a socket.");

 /* Set up an initial ECB for listening and some ECBs for receiving */
 	SetUpReceiveECBs ();
	initialECB = SetUpInitialECB ();

 /* Try to establish a connection */
	while (keepTrying)
	{
		Update ("Waiting for someone to answer...");
		ccode = SPXEstablishConnection (  (BYTE)retryCount, (BYTE)watchDog,
			&SPXConnectionNumber, initialECB );
		if (ccode)
			Error ("Connection error.  Unable to continue.");

		while (initialECB->inUseFlag)
		{
			IPXRelinquishControl ();
		}

	 	keepTrying = initialECB->completionCode;
		if (keepTrying)
		{
			Update ("No answer.  Press ESCAPE to hang up / ENTER to keep trying.");
			if ( (key = getch()) == ESCAPE)
			{
				keepTrying = 0;
				returnCode = -1;
			}
		}
		else
			SetUpSendECB ();
	}
	return (returnCode);
}
