/****************************************************************************
**    DISCLAIMER  
**
** Novell, Inc. makes no representations or warranties with respect to
** any NetWare software, and specifically disclaims any express or
** implied warranties of merchantability, title, or fitness for a
** particular purpose.  
**
** Distribution of any NetWare software is forbidden without the
** express written consent of Novell, Inc.  Further, Novell reserves
** the right to discontinue distribution of any NetWare software.
** 
** Novell is not responsible for lost profits or revenue, loss of use
** of the software, loss of data, costs of re-creating lost data, the
** cost of any substitute equipment or program, or claims by any party
** other than you.  Novell strongly recommends a backup be made before
** any software is installed.   Technical support for this software
** may be provided at the discretion of Novell.
****************************************************************************
**
** File:   SPARMAP.C
**
** Desc:   This program will allow you to input the file server name
**         and the full path to the sparse file you wish to have the
**         bit map done of.  It will then print out the bit map.
**
** Parameter descriptions:    > input
**                            < output
**
**
** Netware API Calls:         NWCallsInit()
**                            
**
**        
** Programmers:
** Ini   Who                Firm
** ------------------------------------------------------------------
** ARM   A. Ray Maxwell     Novell Developer Support.
**                            
** History:
**     
** ------------------------------------------------------------------
** 06-22-94   ARM   First code.
*/

/****************************************************************************
** Include Headers, Macros & function Prototypes.
*/
   /*-------------------------------------------------------------------
   ** Borland C.
   */
   #include <stdlib.h>
   #include <stdio.h>
   #include <string.h>      /*strcpy() */
   #include <conio.h>
   #include <fcntl.h>
   #include <sys\stat.h>
   #include <share.h>
   #include <conio.h>
   #include <io.h>
   #include <math.h>
   #include <dos.h>


   /*-------------------------------------------------------------------
   ** NWCalls
   */
   #define NWDOS

   #include <nwcalls.h>

   /*------------------------------------------------------------------------
   ** Prototypes
   */
   void usage (void);
   
   /*------------------------------------------------------------------------
   ** Globals
   */

/****************************************************************************
** Program start.
*/
void main (int argc, char **argv)
{  
   /*---------------------------------------------------------------------
   **  This line is to increase the stack from 4 (borland) to 16.
   */

   int ccode,fh,i,counter;
   NWCONN_HANDLE  conn;
   NWLOCAL_SCOPE scopeFlag;
   NWLOCAL_MODE res1;        /* reserve flags for NWGetConnectionHandle */
   NWLOCAL_SCOPE res2;       /* set to NULL */
   LONG blockSize;
   BYTE bitMap[512];
   char filepath[256];

   if (argc == 3){
      ccode = NWCallsInit(NULL, NULL);
      strupr (argv[1]);
      strupr (argv[2]);
      ccode = NWGetConnectionHandle (argv[1],res1,&conn,&res2);

      if (ccode != 0){
         printf ("Error in NWGetConnectionHandle. Status = %d\n",ccode);
         exit(-1);
      }

      memset (filepath,0x00,256);
      strcpy (filepath, argv[1]);
      strcat (filepath, "\\");
      strcat (filepath,argv[2]);

      fh = open (filepath, O_CREAT | O_WRONLY, S_IREAD | S_IWRITE );

      if (fh == -1){
         printf ("Error in opening %s\n",argv[1]);
         exit(-1);
      }

      ccode = NWGetSparseFileBitMap (conn,fh,0,0x00000000,&blockSize,bitMap);

      if (ccode != 0){
         printf ("Error in opening %s\n",argv[1]);
         exit(-1);
      }

      clrscr();
      printf ("Sparse file bit map for %s\n\n",filepath);
      counter = 0;
      for (i=0; i<512; i++){
         printf (" %X",bitMap[i]);
         counter++;
         if (counter == 32){
            printf ("\n");
            counter = 0;
         }
      } /* end for */
   } /* end if */
   else
     usage();

}


/****************************************************************************
** Usage
*/
void usage (void)
{
printf ("\n\n");
printf ("Usage: SPARMAP <FILESERVER> <PATH>\n");
printf ("<FILESERVER>: Name of the fileserver bitmap will be created on.\n");
printf ("<PATH>      : Full path to sparse file.(VOLUME:\SUBDIR\FILENAME)\n");
}
