;-----------------------------------------------------------------------
; SHPRSET.ASM
;
; (c) Copyright 1989, LAN Sharks, P.O. Box 825, Reisterstown, MD 21136
;
; Written by Brett Warthen
;
;-----------------------------------------------------------------------
code segment
assume cs:code,ds:code,es:code

; Offsets in the PSP that contain the command line and length of command line
org 80h
param_length label byte
org 81h
parameter    label byte

; .COM files start at 100h
org 100h

start:
          mov  ah,9                           ; Display LAN Sharks
          mov  dx,offset ego_message          ;  copyright notice
          int  21h

          xor  bh,bh                          ; Zero terminate parameter
          mov  bl,param_length                ; string (make ASCIIZ)
          mov  byte ptr parameter[bx],0

          xor  bx,bx
get_parms:
          cmp  bl,param_length                ; loop until end
          jae  end_parms

          cmp  byte ptr parameter[bx],' '     ; white space?
          jbe  next_please                    ; Yes...get next char

          cmp  byte ptr parameter[bx],'/'     ; command line delimiter?
          jz   @F                             ; YES
          cmp  byte ptr parameter[bx],'\'
          jz   @F                             ; YES
          cmp  byte ptr parameter[bx],'-'
          jz   @F                             ; YES
          jmp  end_parms                      ; No

@@:
          inc  bx                             ; Get printer number
          mov  al,byte ptr parameter[bx]
          sub  al,'0'+1                       ; 0=LPT1, 1=LPT2, 2=LPT3
          jb   next_please                    ; below LPT1
          cmp  al,2
          ja   next_please                    ; beyond LPT3
          mov  default_printer,al             ; save it

next_please:
          inc  bx                             ; read next char on
          jmp  get_parms                      ;  command line

; done with command line
end_parms:
          cmp  byte ptr parameter[bx],' '
          ja   @F

          mov  dx,offset no_file_msg          ; No filename specified
          jmp  error_exit

@@:
          mov  ah,3Dh                         ; Open setup file
          mov  al,40h                         ; Read only/Deny none
          mov  dx,offset parameter
          add  dx,bx
          int  21h
          jnc  @F                             ; file opened ok

          mov  ah,9                           ; file not opened ok
          mov  dx,offset file_not_found_msg
          int  21h

          xor  bh,bh
          mov  bl,param_length
          mov  byte ptr parameter[bx],'$'

          mov  ah,9
          mov  dx,offset parameter
          int  21h

          mov  ah,9
          mov  dx,offset cr_lf_msg
          int  21h

          jmp  error_exit                     ; get out

@@:
          mov  bx,ax                          ; file opened ok -- read
          mov  ah,3Fh
          mov  cx,BUFFER_AREA_SIZE
          mov  dx,offset buffer_area
          int  21h

          jnc  @F
          xor  ax,ax                          ; if error -- 0 bytes read
@@:
          cmp  ax,0                           ; zero bytes, don't check
          jz   @F                             ;  for EOF

          mov  si,ax                          ; if editor put an EOF
          dec  si                             ;  char (CTRL-Z) in the
          cmp  byte ptr buffer_area[si],26    ;  file, then strip it...
          jnz  @F
          mov  byte ptr buffer_area[si],0
          dec  ax
@@:
          mov  actual_buffer_size,ax

          mov  ah,3Eh                         ; close setup file
          int  21h

          mov  ah,0B8h                        ; Get specific capture
          mov  al,2                           ;  flags for printer
          mov  cx,63                          ;  no. requested
          mov  bx,offset reply_buffer
          mov  dh,default_printer
          int  21h

          cmp  al,0
          jz   @F

          mov  dx,offset netware_error_msg    ; NetWare error
          jmp  error_exit

@@:
          cmp  lpt_capture_flag,0             ; Is a capture active
          jnz  got_capture                    ;  on specified device?
          cmp  file_capture_flag,0
          jnz  got_capture

          mov  al,default_printer             ; No, display error
          add  al,'0'+1
          mov  not_capturing_no,al

          mov  dx,offset not_capturing_msg
          jmp  error_exit

got_capture:
          mov  ax,setup_buffer_hi             ; Get address of where
          mov  es,ax                          ;  NetWare stores
          mov  di,setup_buffer_lo             ;  setup_buffer
          mov  ax,actual_buffer_size
          cmp  word ptr es:[di],ax            ; First word is size
          jae  @F                             ;  of buffer

          mov  dx,offset buffer_too_big_msg   ; We can't fit into
          jmp  error_exit                     ;  default buffer size

@@:
          inc  di
          inc  di
          mov  ax,actual_buffer_size          ; Next word contains
          mov  word ptr es:[di],ax            ;  actual size of
          inc  di                             ;  setup string
          inc  di

          mov  cx,actual_buffer_size          ; copy our setup string
          mov  si,offset buffer_area          ;  over
          rep  movsb

exit:
          mov  ax,4C00h                       ; Done
          int  21h

error_exit:
          push dx

          mov  ah,9                           ; Error -- display
          mov  dx,offset usage_msg            ;  usage info
          int  21h

          pop  dx                             ; ...and error msg
          mov  ah,9
          int  21h

          mov  ax,4CFFh                       ; SCRAM!
          int  21h

;-----------------------------------------------------------------------
; data area
;-----------------------------------------------------------------------

ego_message  db 'SHPRSET.COM -- (c) Copyright 1989 LAN Sharks',13,10
             db '                                  P.O. Box 825',13,10
             db '                                  Reisterstown, MD 21136',13,10,13,10,'$'

usage_msg    db 13,10
             db 'Usage:  SHPRSET [/p] setup_file',13,10
             db 'Where p is the printer number (1, 2 or 3)',13,10
             db '      setup_file is the name of a file containing a printer setup string',13,10
             db 13,10,'$'

default_printer    db 0

file_not_found_msg db 'File Not Found:  ',7,'$'
cr_lf_msg          db 13,10,'$'

no_file_msg        db 'No setup file specified.',7,13,10,'$'

netware_error_msg  db 'UNKNOWN NetWare Error',7,13,10,'$'

not_capturing_msg  db 'LPT'
not_capturing_no   db ?
                   db ' is not being captured.',7,13,10,'$'

buffer_too_big_msg db 'PRINT HEADER Buffer Size is too large.',7,13,10
                   db ' Increase value of PRINT HEADER= in SHELL.CFG or',13,10
                   db ' decrease the size of the setup string',13,10,'$'

actual_buffer_size dw ?
BUFFER_AREA_SIZE EQU 256
buffer_area db BUFFER_AREA_SIZE dup (0)

reply_buffer label byte                       ; info returned from
   status             db ?                    ;  set specific capture
   print_flags        db ?                    ;  flags
   tab_size           db ?
   server_printer     db ?
   num_of_copies      db ?
   form_type          db ?
                      db ?
   banner_text        db 14 dup (?)
   local_device       db ?
   flush_timeout      dw ?
   flush_on_close     db ?
   max_lines          dw ?
   max_chars          dw ?
   form_name          db 13 dup (?)
   lpt_capture_flag   db ?
   file_capture_flag  db ?
   timing_out_flag    db ?
   setup_buffer_lo    dw ?
   setup_buffer_hi    dw ?
   reset_buffer_lo    dw ?
   reset_buffer_hi    dw ?
   server_queuing     db ?
   in_progress        db ?
   queue_flag         db ?
   valid_flag         db ?
   queue_id_no        dd ?
   job_no             dw ?

code ends
end start
