/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File: SCANTRST.C   
**
**   Desc: Scans a specified directory and shows the trustee assignments for
**         that directory.  
**
**        
**   Programmers:
**   Ini   Who                Firm
**   ------------------------------------------------------------------
**   ARM   A. Ray Maxwell     Novell Developer Support.
**
**   History:
**       
**   ------------------------------------------------------------------
**   01-31-95   ARM   First code.
*/

/***************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

   /*------------------------------------------------------------------
   **   ANSI
   */
   #include <stdlib.h>      /* exit(), atol()        */
   #include <stdio.h>       /* sprintf()             */
   #include <string.h>      /* strupr()              */
   #include <conio.h>       /* clrscr()              */
   /*------------------------------------------------------------------
   **   NetWare
   */
   #include <nwcalls.h>



/***************************************************************************
**   Program Start
*/
void main(int argc, char *argv[])
{

   NWSEQUENCE           sequence;
   NWNUM_ENTRIES        numberOfEntries;
   char                 dirPath[255+1];
   char                 serverName[47+1];
   NWET_INFO            entryTrusteeInfo;
   NWCCODE              ccode;
   NWCONN_HANDLE        connHandle;
   NWDIR_HANDLE         dirHandle;
   NWACCESS_RIGHTS      rightsMask;
   char                 objectName[48];
   int                  count;
   int                  objCount=0;

   switch(argc){
      case  3:
         strcpy(serverName,strupr(argv[1]));
         strcpy(dirPath,strupr(argv[2]));
         break;
      default:
         clrscr();
         printf("USAGE: scantrst <server name> <directory>\n");
         printf("\n       Trustee information EXAMPLE:\n");
         printf("            scantrst server1 sys:users\\jsmith\n");
         exit(1);
   }

   ccode=NWCallsInit(NULL,NULL);
   if (ccode)
      exit(1);

   ccode = NWGetConnectionHandle(
           /* > servername        */ serverName,
           /*   Novell Reserved1  */ 0,
           /* < connection Handle */ &connHandle,
           /*   Novell Reserved2  */ NULL);

   //ccode= NWGetDefaultConnectionID(&connHandle);
/*--------------------------------------------------------------------------
** check for validity of the directory path.
*/
   ccode = NWAllocTemporaryDirectoryHandle(
           /* Connection Handle            */ connHandle,
           /* Directory Handle             */ NULL,
           /* Pointer to Absolute dir path */ dirPath,
           /* Pointer to New dir Handle    */ &dirHandle,
           /* Pointer to trustee rights    */ &rightsMask);
   if(ccode){
      printf("NWAllocTemporaryDirectoryHandle failed %X\n",ccode);
      printf("Check for input of valid path\n");
      exit(1);
   }

   if (ccode)
      exit(1);

   sequence=0L;
/*--------------------------------------------------------------------------
** Get all the trustee assignments for the specified directory
*/
   while((ccode!=0x899C)&&(ccode==0)){
      ccode=NWScanForTrustees(
            /* connection Handle          */ connHandle,
            /* NWDIR_HANDLE               */ 0,
            /* NWDIR_PATH                 */ dirPath,
            /* sequence number            */ &sequence,
            /* NWNUM number of entries    */ &numberOfEntries,
            /* trustee info stuct pointer */ &entryTrusteeInfo);

      if(ccode==0){
         printf("\nTrustees of %s\n", dirPath);

         if (numberOfEntries == 0){
            printf("\nNo trustee entries found!\n");
            exit(1);
         }

         for (count=0; count<numberOfEntries; ++count){
             ccode = NWGetObjectName(
                     /* > conn Hand   */ connHandle,
                     /* > Object ID   */ entryTrusteeInfo.trusteeList[count].objectID,
                     /* < Obj name    */ objectName,
                     /*   Obj Type    */ NULL);
             if (ccode){
                printf("NWGetObjectName returned %X \n",ccode);
                exit(1);
             }

				 if ((entryTrusteeInfo.trusteeList[count].objectID !=0)
                  && (ccode == 0)){
                objCount = objCount + 1;
                
                /*----------------------------------------------------------
                ** The TR_READ etc. are found defined in the nwdentry.h.
                */
                printf("\n\t%-08s\t [%c%c%c%c%c%c%c%c]",objectName,
                (entryTrusteeInfo.trusteeList[count].objectRights & TR_SUPERVISOR)  ? 'S' : ' ',
                   (entryTrusteeInfo.trusteeList[count].objectRights & TR_READ)        ? 'R' : ' ',
                   (entryTrusteeInfo.trusteeList[count].objectRights & TR_WRITE)       ? 'W' : ' ',
                   (entryTrusteeInfo.trusteeList[count].objectRights & TR_CREATE)      ? 'C' : ' ',
                   (entryTrusteeInfo.trusteeList[count].objectRights & TR_DELETE)      ? 'E' : ' ',
                   (entryTrusteeInfo.trusteeList[count].objectRights & TR_ACCESS_CTRL) ? 'A' : ' ',
                   (entryTrusteeInfo.trusteeList[count].objectRights & TR_FILE_SCAN)   ? 'F' : ' ',
                   (entryTrusteeInfo.trusteeList[count].objectRights & TR_MODIFY)      ? 'M' : ' ');

             }

             if (objCount == 0){
                printf("\nNo trustee entries found!\n");
                exit(1);
             }

         } /* end for */
      } /* end if */
      else
         switch (ccode){
            case 0x899c : printf("All trustees found\n");
                          break;
            case 0x8801  :printf("Invalid connection\n");
                          break;
            case 0x8998  :printf("Volume does not exist\n");
                          break;
            case 0x899B  :printf("Bad Directory Handle\n");
            default      :printf("Unknown error on find of Trustees\n");
                          break;
         }
   }
}

