
/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:   log.c
**
**   Desc: Program that allows a user to login to a specified file server.
**         This code comes from the v1.0e manuals and has corrections that
**         allow the code to actually work! It should be noted that you 
**         login and are automatically map rooted to the login subdirectory.
**         Code would have to be written to map you to other directories or
**         for testing copy the map.exe file to the login subdirectory so you
**         can map elswhere.
**        
**   Parameter descriptions:    > input
**                              < output
**
**   Programmers:
**   Ini   Who                Firm
**   ------------------------------------------------------------------
**   ARM   A. Ray Maxwell     Novell Developer Support.
**
**   History:
**       
**   ------------------------------------------------------------------
**   06-28-94   ARM   First code.
*/

/****************************************************************************
** Include Headers, Macros & function Prototypes.
*/
   /*-------------------------------------------------------------------
   ** Borland C.
   */
   #include <stdio.h>
   #include <stdlib.h>
   #include <string.h>
   #include <conio.h>

   #define RETURN '\r'

   /*-------------------------------------------------------------------
   ** NetWare API's
   */
   #include <nwcalls.h>
      
/****************************************************************************
** Program start.
*/
void main(int argc, char *argv[ ])
{
   NWCONN_HANDLE   connHandle;
   CONNECT_INFO    connInfo;
   NWCCODE         ccode;
   char            *ptr;
   char            server[50],
                   objName[50],
                   password[128];

   if(argc != 3) {
      printf("Usage: LOGIN <servername> <username>\n");
      exit(1);
   }

   strcpy(server,  strupr(argv[1]));
   strcpy(objName, strupr(argv[2]));

   ccode = NWCallsInit(NULL, NULL);

   if(ccode)
      exit(1);

   ccode = NWGetConnectionHandle(
           /* > servername        */ server,
           /*   Novell Reserved1  */ 0,
           /* < connection Handle */ &connHandle,
           /*   Novell Reserved2  */ NULL);

   if(ccode){
      ccode = NWAttachToFileServer(
              /* > servername       */ server,
              /*   Novell Reserved1 */ 0,
              /* < Now conn Handle  */ &connHandle);
      if(ccode)
    exit(1);
   }
   else{
      ccode = NWGetConnectionStatus(
              /* > conn Handle             */ connHandle,
              /* < pointer to CONNECT_INFO */ &connInfo,
              /* > size of structure       */ sizeof(CONNECT_INFO));
      if(ccode)
         exit(1);
      if(connInfo.connectFlags & CONNECTION_NDS){
         printf("An NDS connection is already established to %s.\n",server);
         exit(0);
      }
      if(connInfo.connectFlags & CONNECTION_LOGGED_IN){
         printf("Already logged in: %s as %s.\n", server,connInfo.clientName);
         exit(0);
      }
   }
   memset(password,'\0',sizeof(password));
   printf("Password: ");
  
   
  /*------------------------------------------------------------------------
  **  Get the Password
  */
   ptr = password;

	while(*(--ptr) != RETURN){
		*ptr=getch();
		ptr++;
	}
	*ptr=='\0';

   strupr(password);
   
   ccode = NWLoginToFileServer(
           /* > conn Handle             */ connHandle,
           /* > pointer to login object */ objName,
           /* > object type             */ OT_USER,
           /* > pointer to password     */ password);

   if(ccode)
      printf("Unable to log into %s error code is %X.\n",server, ccode);
   else
      printf("You are logged into %s.\n", server);

}
                                                                                                                                                            
