/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
*****************************************************************************
**
**   File: Cap.c   
**
**   Desc:  The program will capture to the specified queue.
**          Print the data "this is a test to the queue and flush the queue.
**          Reset the queue to it's original queue upon exiting the program.
**          NOTE: This program will distingush between NDS and Bindery mode
**                on the work station and capture accordingly.
**
**        
**   Programmers:
**   Ini   Who               Firm
**   ------------------------------------------------------------------------
**   ARM   A. Ray Maxwell    Novell Developer Support.
**
**   History:
**       
**   ------------------------------------------------------------------------
**   07-13-94   ARM   First code.
**   09-08-94   ARM   Added comments to API calls.
**   01-08-95   ARM   Added checking for DS connections status.
*/
/****************************************************************************
** Include Headers, Macros & function Prototypes.
*/
   /*------------------------------------------------------------------------
   ** Borland C.
   */
   #include <stdio.h>    /* getch()       */
   #include <stdlib.h>   /* exit() atoi() */
   #include <conio.h>    /* cputs()       */
   #include <string.h>   /* strcpy()      */

   /*------------------------------------------------------------------------
   ** Netware NWCALLS etc.
   */
   #include <nwnet.h>
   #include <nwcalls.h>
   #include <nwlocale.h>

   /*------------------------------------------------------------------------
   ** Defines
   */
   #define MAX_PATH 48
   #define RELEASEJOB    0x04
   #define SUPFORMFEED   0x08
   #define TEXTFILE      0x40
   #define PRINTBANNER   0x80
   #define MARGIN        60

   /*------------------------------------------------------------------------
   **  Prototypes
   */
   void checkConnectionType(void);
   void captureTheQueue(void);
   void printData(void);
   void resetOriginalCapture(void);
   void helpScreen(void);

/*---------------------------------------------------------------------------
**  Global variables.
*/
   NWCAPTURE_FLAGS1   f1;         /* new capture flags for queue         */
   NWCAPTURE_FLAGS1   f1temp;     /* temp buffer for old capture flags   */
   NWCAPTURE_FLAGS2   f2;         /* new capture flags for queue         */
   NWCAPTURE_FLAGS2   f2temp;     /* temp buffer for old capture flags   */
   NWCONN_HANDLE      connHandle; /* connection handle                   */
   NWOBJ_ID           *objectID;  /* Bindery object ID                   */
   NWDSContextHandle  dContext;   /* DS context                          */
   LCONV              lconvInfo;  /* UNICODE tables                      */
   int                capture;    /* is there already a capture on port? */
   int                captured;   /* Label queue is now captured         */
   int                lptPort;    /* buffer for lpt                      */
   BYTE NWFAR         *server;    /* server name                         */
   char NWFAR         *printQueue;/* print queue name                    */
   NWCCODE            ccode;      /* error code buffer                   */
   CONNECT_INFO       connInfo;

/****************************************************************************
**   Program Start
*/
void main (int argc, char **argv)
{
   if ((argc < 2) || (argc == 3) || (argc > 4)){
      helpScreen();
      exit(-1);
   }

   lptPort=atoi(argv[3]);                           /* set up the port */
   server=strupr(argv[1]);                          /* server name     */
   printQueue=strupr(argv[2]);                      /* print queue name*/
   ccode = NWCallsInit(NULL, NULL);
   if (ccode != 0x0000){
      printf("NWCallsInit failed with ccode =%X\n",ccode);
   }

   ccode = NWGetConnectionHandle(
           /* server name     >  */ server,
           /* Novell reserved >  */ 0,
           /* Conn Handle     <  */ &connHandle,
           /* Novell Reserved <  */ NULL);

   if (ccode){
      printf("NWGetConnectionHandle failed with ccode =%X\n",ccode);
      exit(-1);
   }

   checkConnectionType();
   captureTheQueue();
   printData();
   resetOriginalCapture();
}


/****************************************************************************
** Check for bindery or DS connection and get the appropriate ObjectID
*/
void checkConnectionType()
{
   /*------------------------------------------------------------------------
   ** check for DS connection
   */
   ccode = NWGetConnectionStatus(
           /* > conn Handle             */ connHandle,
           /* < pointer to CONNECT_INFO */ &connInfo,
           /* > size of structure       */ sizeof(CONNECT_INFO));
   if(ccode)
      exit(1);
   if(connInfo.connectFlags & (WORD)CONNECTION_NDS){
      printf("An NDS connection is already established to %s.\n",server);

      NWLsetlocale(LC_ALL, "");
      printf("\nNWLsetl.. OK");

      NWLlocaleconv(&lconvInfo);
      printf("\nCountry ID = %03d, Code Page = %04d\n",
              lconvInfo.country_id, lconvInfo.code_page);

      ccode = NWInitUnicodeTables(lconvInfo.country_id, lconvInfo.code_page);

      printf("NWInitUnicodeTables() = %04X\n",ccode);
      if(ccode){
         NWFreeUnicodeTables();
               exit(1);
      }


      dContext = NWDSCreateContext();
      printf("NWDSCreateContext() = %04X\n",dContext);

      if(dContext == ERR_CONTEXT_CREATION){
         NWFreeUnicodeTables();
         NWDSFreeContext(dContext);
         exit(1);
      }
      
      ccode=NWDSMapNameToID(
            /* > NWDSContextHandle   */ dContext,
            /* > connection handle   */ connHandle,
            /* > object name         */ printQueue,
            /* < pointer to objectID */ &objectID);
      if(ccode){
         printf("NWDSMapNameToID returned: %04X\n",ccode);
         NWFreeUnicodeTables();
         exit(1);
      }
   }
   else{
      ccode = NWGetObjectID( 
              /* conn Handle      > */ connHandle,
              /* queue name       > */ printQueue,
              /* Bindery Obj type > */ OT_PRINT_QUEUE,
              /* pointer to ID    < */ objectID);
       
      if (ccode){
         printf("NWGetObjectID failed with ccode =%X\n",ccode);
         exit(-1);
      }
   }
}

/****************************************************************************
** Captures the specified queue and prints the test data "this is a test"
*/
void captureTheQueue(void)
{
   /*---------------------------------------------------------------------
   ** Check the capture status and if captured put the queue flags1 and 2
   ** into temp buffers.
   */
   ccode = NWGetCaptureStatus(lptPort);
   if (ccode ==0x00FF){
      /*------------------------------------------------------------
      ** Sets a flag telling us there was a previous capture.  This
      ** is used in resetOriginalCapture()
      */
      capture=TRUE;

      ccode = NWGetCaptureFlags(
              /* port 1,2,3    > */ lptPort,
              /* captureflags1 < */ &f1temp,
              /* captureflags2 < */ &f2temp);

      if (ccode){
         printf("NWGetCaptureFlags failed with ccode =%X\n",ccode);
         exit(-1);
      }

      ccode = NWEndCapture(lptPort);
      if (ccode){
         printf("NWEndCapture failed with ccode =%X\n",ccode);
         exit(-1);
      }
   }
   else
      capture = FALSE;

   ccode = NWStartQueueCapture(
           /* conn Handle    > */ connHandle,
           /* port 1,2,3     > */ lptPort,
           /* object ID      > */ *objectID,
           /* queue name     > */ printQueue);

   if (ccode){
      printf("NWStartQueueCapture failed with ccode =%X\n",ccode);
      exit(-1);
   }

   ccode = NWGetCaptureFlags(
           /* port 1,2,3    > */ lptPort,
           /* captureflags1 < */ &f1, 
           /* captureflags2 < */ &f2);
   
   if (ccode){
      printf("NWGetCaptureFlags failed with ccode =%X\n",ccode);
      exit(-1);
   }

   /*---------------------------------------------------------------------
   ** Sets the printFlags to nt nb nff
   **
   ** 0x04 RELEASEJOB If set, the print job is released for printing if
   **      the capture is interrupted by a loss of connection time to the
   **      server. 
   ** 0x08 SUPFORMFEED If set, the print service suppresses
   **      automatic form feed after the print job is printed. 
   ** 0x40 TEXTFILE If set, tab size and other printer control sequences 
   **      are interpreted by the print service. If not set, the job is 
   **      interpreted as a byte stream.
   ** 0x80 PRINTBANNER If set, the print service precedes the print job 
   **      with a banner page.
   */
   f1.printFlags = (RELEASEJOB|TEXTFILE|PRINTBANNER);

   strcpy(f1.jobDescription,"job Desc.");
   f1.tabSize=10;
   f1.numCopies=2;
   strcpy(f1.bannerText,"bannertext");

   ccode = NWSetCaptureFlags(
           /* conn Handle    > */ connHandle,
           /* port 1,2 or 3  > */ lptPort,
           /* captureflags1  > */ &f1); 

   if (ccode){
      printf ("NWSetCaptureFlags error ccode=%X\n",ccode);
      exit(-1);
   }
 }


/****************************************************************************
** Usage and help screen.
*/
void helpScreen (void)
{
   clrscr();
   gotoxy (34,5);
   cputs ("CAP Usage");
   gotoxy (11,7);
   cprintf("Usage: CAP <server> <queue> <lpt port>");
   gotoxy (15,8);
   cputs("server   = the name of the server the queue is on.");
   gotoxy (15,9);
   cputs("queue    = the name of the print queue.\n");
   gotoxy (15,10);
   cputs("lpt port = the port 1,2,3 that you are captured to.");
   gotoxy (31,16);
   cputs ("Hit Return to Exit");
   getch();
}


/****************************************************************************
** Print the data from the label input screen to the queue then flush the
** queue and leave the capture in place.
*/
void printData(void)
{
   fprintf (stdprn,"This is a test\n");
   NWFlushCapture(lptPort);
}

/****************************************************************************
** Reset the original capture that was in place before program was run.
*/
void resetOriginalCapture(void)
{
   ccode = NWEndCapture(lptPort);
   if (ccode){
      printf("NWEndCapture failed with ccode =%X\n",ccode);
      exit(-1);
   }

   if(capture==TRUE){
      ccode = NWGetObjectID(
              /* conn Handle      > */ connHandle,
              /* queue name       > */ f2temp.queueName,
              /* Bindery Obj type > */ OT_PRINT_QUEUE,
              /* pointer to ID    < */ objectID);
      if (ccode){
         printf("NWGetObjectID failed with ccode =%X\n",ccode);
               exit(-1);
      }
      
      ccode = NWStartQueueCapture(
              /* conn Handle    > */ connHandle,
              /* port 1,2,3     > */ lptPort,
              /* object ID      > */ *objectID,
              /* queue name     > */ f2temp.queueName);
      if (ccode){
         printf("NWStartQueueCapture failed with ccode =%X\n",ccode);
         exit(-1);
      }

      ccode = NWSetCaptureFlags(
              /* conn Handle    > */ connHandle,
              /* port 1,2 or 3  > */ lptPort,
              /* captureflags1  > */ &f1temp); 
      if (ccode){
         printf ("NWSetCaptureFlags error ccode=%X\n",ccode);
         exit(-1);
      }
   }
}

                                                                                                                                                           
                                                                                                                                                             
                                                                                                                                                             

 
                                                                                                                                                             
                                                                                                                                                             
                                                                                                                                                             
                    
 
