/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *
 Program : PWD_C.C
 Author  : Dr. Wolfgang Schreiber    (Dec  91)

 Function: Call NetWare functions from command line with encrypted passwords.

           If developers do NOT use Novell's C Library no encrypted
           passwords can be sent to the file server.  Some servers
           running NetWare 386 however will only accept encrypted
           passwords (for security reasons).
           This limits the functionality of programs written without
           Novell's CLIB.  3 functions are affected:
                   ChangeBinderyObjectPassword
                   VerifyBinderyObjectPassword
                   LoginToFileServer

           PWD_C.EXE can be called by other applications with an EXEC call.

           See PWD_P.PAS as an example of how to use password encryption from
           TurboPascal programs.

 Syntax  : All parameters are entered as command options.
           PWD_C <fct> <ObjectName> <ObjectType> <CurrentPassword> [newPassword]
                 all parameters are case-sensitive

           <fct> is
             1 (ChangeBinderyObjectPassword)   or
		     2 (VerifyBinderyObjectPassword)   or
		     3 (LoginToFileServer)

           <ObjectName> is the name of an existing bindery object.
           <ObjectType> is the object type of <ObjectName> (e.g. '1' for users)
           <CurrentPassword> is the object's current password
           <newPassword> is the object's new password (only with <fct>=1)

           Examples:
             PWD_C 1 WSCHREIB 1 SESAME SECRET   (change password)
             PWD_C 3 PSERVER 7 PS               (login as print server)

 Output  : No screen/file output.
           NetWare's return code is returned as DOS errorlevel and must
           be checked by the calling application.

                0  Successful
               99  Invalid function / number of parameters
              150  Server out of memory
              240  Wildcard not allowed
              251  No such property
              252  No such object
              254  Server bindery locked
              255  No such object / bad password


 Genesis : Turbo C++ 1.0

 This software is provided as is and carries no warranty whatsoever.
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */




#include <stdio.h>
#include <nwbindry.h>

int main(argc,argv)
   int   argc;
   char  *argv[];

{
   int   ccode;
   char  objectName[48];
   int   objectType;
   char  oldPassword[80], newPassword[80];

   ccode = 99;  /*  default return code  */
   if (argc<4) return(ccode);

   strcpy(objectName,  argv[2]);
   objectType = strtol(argv[3], NULL,  10);
   strcpy(oldPassword, argv[4]);

   switch (strtol(argv[1], NULL,  10))
	  {case 1:
		/* Change Password */
		 if (argc < 5) return(ccode);
		 strcpy(newPassword, argv[5]);
		 ccode = ChangeBinderyObjectPassword(objectName, objectType, oldPassword, newPassword);
		 break;
	   case 2:
		/* Verify Password */
		 ccode = VerifyBinderyObjectPassword(objectName, objectType, oldPassword);
		 break;
	   case 3:
		/* Login Object */
		 ccode = LoginToFileServer(objectName, objectType, oldPassword);
		 break;
	   }

	/*	printf("Return Code: %d (%x)", ccode, ccode);  */

	return(ccode);
}
