/****************************************************************************
**	File:	NWGETP.C
**
**	Desc:	Example of how to get a directory path from a directory entry.
**
**		
**			Usage: NWGETP <File Server Name>
**			  e.g: NWGETP FileServer
**		
**		
**		
**		
**		
**
**		DISCLAIMER  
**  
**	Novell, Inc. makes no representations or warranties with respect to
**	any NetWare software, and specifically disclaims any express or
**	implied warranties of merchantability, title, or fitness for a
**	particular purpose.  
**
**	Distribution of any NetWare software is forbidden without the
**	express written consent of Novell, Inc.  Further, Novell reserves
**	the right to discontinue distribution of any NetWare software.
**	
**	Novell is not responsible for lost profits or revenue, loss of use
**	of the software, loss of data, costs of re-creating lost data, the
**	cost of any substitute equipment or program, or claims by any party
**	other than you.  Novell strongly recommends a backup be made before
**	any software is installed.   Technical support for this software
**	may be provided at the discretion of Novell.
**
**	Programmers:
**
**		Ini	Who						Firm
**		-----------------------------------------------------------------------
**		KLB	Karl Bunnell				Novell Developer Support.
**
**	History:
**
**		When		Who	What
**		-----------------------------------------------------------------------
**		08-12-94	klb	First code.
**		08-16-94 kbl   Added the NWSubmitRequest() function. This function
**							returns the amount of actual data received back from
**							from the Server if the VLMs are used.
*/

/****************************************************************************
**	Include headers, macros, function prototypes, etc.
*/

	/*------------------------------------------------------------------------
	**	Macros
	*/
	#define NWDOS
	#define VLM_ID_TRAN	 0x0020
	#define TRAN_REQ		 6
	#define SET_PREFERRED 0xF000

	/*------------------------------------------------------------------------
	**	ANSI
	*/
	#include <stdio.h>
	#include <string.h>


	/*------------------------------------------------------------------------
	**	NetWare
	*/
	#include <nwcalls.h>
	#include <nwmisc.h>

	/*------------------------------------------------------------------------
	**	Structure typedef's
	*/

	typedef struct
	{
		WORD				bufLen;
		BYTE				subFunctionCode;
		BYTE				volumeNumber;
		NWDIR_ENTRY		dirEntry;
		NWNAME_SPACE 	nameSpace;
	} REQBUFFER;

	typedef struct
	{
		char				path[256];
	} REPLYBUFFER;


/****************************************************************************
**	This program demonstrates the proper use of NWGetPathFromDirEntry.
**
*/



NWCCODE NWSubmitRequest(
  			NWCONN_HANDLE 	conn,
  			WORD 				function,
  			WORD 				numReqFrags,
  			NW_FRAGMENT 	*reqFrags,
  			WORD 				numReplyFrags,
  			NW_FRAGMENT 	*replyFrags,
  			WORD 				*actualReplyLen)
{
WORD i;
NWCCODE ccode;
REGISTERS regs;

   if(conn && !NWIsIDInUse(conn))
      return(INVALID_CONNECTION);


   if(conn > 8)
   {
      regs.w.ax = function;
      regs.w.bx = numReqFrags;
      regs.w.cx = conn;
      regs.w.dx = 1;
      regs.p.requestBuffer = reqFrags;
      regs.p.replyBuffer   = replyFrags;

      ccode = NWVLMRequest(0, VLM_ID_TRAN, TRAN_REQ, &regs, USE_DS | USE_ES);
      
      *actualReplyLen = regs.w.dx;
   }
   else
   {
      regs.w.ax = SET_PREFERRED;  /* Set Preferred Connection ID (0xf000) */
      regs.w.dx = conn;
      NWShellRequest(&regs, 0);

      regs.p.requestBuffer = reqFrags[0].fragAddress;
      regs.w.cx = reqFrags[0].fragSize;

      regs.w.ax = (function & 0x00ff) | 0xf200;
      regs.p.replyBuffer = replyFrags[0].fragAddress;
      regs.w.dx = replyFrags[0].fragSize;

      NWShellRequest(&regs, USE_DS | USE_ES);
      ccode = regs.b.al ? (WORD)regs.b.al | 0x8900 : 0;

      *actualReplyLen = replyFrags[0].fragSize;

   }


   return ccode;
}



NWCCODE NWGetPathFromDirEntry(
			  NWCONN_HANDLE connHandle,
			  BYTE 			 volumeNumber,
			  NWDIR_ENTRY   dirEntry,
			  NWNAME_SPACE  nameSpace,
			  char			 *path)
{
	int			totalLen = 0;
	NWCCODE		cCode;
	REQBUFFER	reqBuffer;
	NW_FRAGMENT	reqFrag[1],
					replyFrag[1];
	REPLYBUFFER	replyBuffer;
	char			*ptr;
	WORD			actualDataSize;

	memset(&replyBuffer, 0, 256);
	reqBuffer.bufLen = NWWordSwap(7);
	reqBuffer.subFunctionCode = 243;
	reqBuffer.volumeNumber = volumeNumber;
	reqBuffer.dirEntry  = dirEntry;
	reqBuffer.nameSpace = nameSpace;
	reqFrag[0].fragAddress = &reqBuffer;
	reqFrag[0].fragSize	  = sizeof(reqBuffer);
	replyFrag[0].fragAddress = &replyBuffer;
	replyFrag[0].fragSize    = sizeof(replyBuffer);

	cCode = NWSubmitRequest(
				/* > Conn Handle  */ connHandle,
				/* > Function code*/ 23,
				/* > Num Req Frags*/ 1,
				/* > Request Frag */ reqFrag,
				/* > Num Reply Frg*/ 1,
				/* > reply Frag   */ replyFrag,
				/* < Size of Data */ &actualDataSize
				);

	if (cCode)
		return(cCode);

	memset(path, 0, 256);

	ptr = replyBuffer.path;

	while ((*ptr != '\0') || (totalLen < actualDataSize))
		{
		totalLen = (totalLen + *ptr);
		strncat(path, ptr+1, *ptr);
		path[totalLen] = '\\';
		++ totalLen;
		ptr = (ptr + *ptr) + 1;
		}

	path[totalLen-1] = '\0';
	return(cCode);
}

void main(int argC, char *argV[])
{
	NWCCODE			cCode,cCode2;
	NWCONN_HANDLE		connHandle;
	NWCONN_NUM		connNumber;
	NWLAST_RECORD 		lastRec = 0;
	OPEN_FILE_CONN_CTRL	openCtrl;
	OPEN_FILE_CONN		openFile;
	NWNUMBER		connInUse;
	NWNUMBER 		maxConnections;
	char			*ptr;
	NWNAME_LEN		pLength;
	char			volumeName[16+1];
	char			path[256];
	int			i;

	cCode = NWCallsInit(NULL, NULL);

	printf("\nNWCallsInit returned: %04X", cCode);
	ptr = strupr(argV[1]);  /* Convert Server Name to upper case */

	cCode = NWGetConnectionHandle(ptr, 0, &connHandle, 0);
	printf("\nNWGetConnectionHandle returned: %04X", cCode);

	cCode = NWGetFileServerInformation(
				/* Connection Handle    */ connHandle,
				/* Server name          */ NULL,
				/* Major Version        */ NULL,
				/* Minor Version        */ NULL,
				/* Revision             */ NULL,
				/* Max Connections      */ NULL,
				/* Max Connection Used  */ &maxConnections,
				/* Connections in use   */ &connInUse,
				/* Number of Volumes    */ NULL,
				/* SFT Level            */ NULL,
				/* TTS Level            */ NULL
				);

	if (cCode)
		{
		printf("NWGetFileServerInformation returned: %04X", cCode);
		exit(1);
		}

	for (i=1; i<maxConnections; ++i)
	{
	printf("\n\nConnection: %d\n", i);

	lastRec = 0;
	connNumber = i;

	while(lastRec != -1)
		{
		cCode = NWScanOpenFilesByConn2(
					/* Connection Handle */ connHandle,
					/* Connection Number */ connNumber,
					/* Last Record       */ &lastRec,
					/* Open Control      */ &openCtrl,
					/* Open File struc   */ &openFile
					);


		if((cCode != 0) && (cCode != 0x88FF))
			{
			printf("\nNWScanOpenFilesByConn2 returned %04X", cCode);
			exit(1);
			}

		if(!cCode)
			{

			cCode2 = NWGetPathFromDirEntry(
						/* > Connection Handle */ connHandle,
						/* > Volume Number	  */ openFile.volNumber,
						/* > Direct. Entry     */ openFile.dirEntry,
						/* > Name Space        */ openFile.nameSpace,
						/* < Path              */ path
						);


			if(cCode2)
				{
				printf("\nNWGetPathFromDirEntry returned %04X", cCode2);
				exit(1);
				}

			NWGetVolumeName(
				/* > Conn Handle */ connHandle,
				/* > volume Num  */ openFile.volNumber,
				/* < volume Name */ volumeName
				);


			printf("\nComplete Path: %s:%s", volumeName, path);

			}

			if (cCode == 0x88FF)
				break;
		}
	}
}
