{============================}
{ Novell Netware Application }
{ Programming Interface Unit }
{ Richard Casey              }
{ CIS 72247,151              }
{============================}

{===========================================================================

Types:
         None

Procedures:
         None

Functions:

         NovellLogicalID            Returns logical id (or station number)
         NovellPhysicalID           Returns physical network address
         NovellLogonName            Returns logon name (or ?????)

===========================================================================}

unit NovAPI;

interface

uses dos;

function NovellLogicalID : byte;
  inline($B4/$DC/          {MOV AH,DC}
         $CD/$21);         {INT 21}

function NovellPhysicalID : word;
  inline($B4/$EE/          {MOV AH,EE}
         $CD/$21);         {INT 21}

function NovellLogonName : string;

implementation

function NovellLogonName : string;
  var
    i             : integer;
    tmp           : string;
    r             : Registers;
    RequestPacket : record
                      PacketLength : word;
                      LogFunction  : byte;
                      Connection   : byte;
                    end;
    ReplyPacket   : record
                      ReturnLength : word;
                      UniqueID     : longint;
                      ReturnType   : word;
                      ObjectName   : array[1..48] of char;
                      LogTime      : array[1..8] of byte;
                    end;
  begin
    RequestPacket.PacketLength:=2;
    RequestPacket.LogFunction:=22;
    RequestPacket.Connection:=NovellLogicalID;
    ReplyPacket.ReturnLength:=64;
    with r do begin
      DS:=seg(RequestPacket);
      SI:=ofs(RequestPacket);
      ES:=seg(ReplyPacket);
      DI:=ofs(ReplyPacket);
      AH:=$E3;
    end;
    MsDOS(r);
    tmp:='?????';
    if r.AL=0 then begin
      i:=1;
      while (ReplyPacket.ObjectName[i]<>#0) and (i<48) do inc(i);
      move(ReplyPacket.ObjectName[1],tmp[1],i);
      tmp[0]:=char(i);
    end;
    NovellLogonName:=tmp;
  end;

end.
