; Program:  NETDRIVE
; Purpose:  Used to find the first network drive that contains a directory
;           called \LOGIN, then switches to that drive and directory.
; Author:   Dave Holden
; Version:  1.00  06-19-90

CODE    SEGMENT
        ASSUME  CS:CODE,DS:CODE
        ORG     100h
BEG:    JMP     START

DRV     DB      00                      ; Drive counter variable
OLD     DB      00                      ; Variable to save beginning drive
PATH    DB      '\LOGIN',00             ; Login path (ASCIIZ string)
NONET   DB      07h,0Dh,'Network shell not loaded!',0Dh,0Ah,24h ; No shell msg

START:  MOV     AH,19h                  ; Get Current Drive function
        INT     21h                     ; Returns drive number in AL
        MOV     byte ptr CS:OLD,AL      ; Save current drive

        MOV     AH,0DBh                 ; Get # of Logical Drives (Novell)
        INT     21h
        CMP     AL,00                   ; If AL=0 then shell not loaded,
        JE      NETERR                  ; jump to NETERR
        MOV     byte ptr CS:DRV,AL      ; Otherwise, save logical drv count

CHGDR:  MOV     AH,0Eh                  ; Set Drive function
        MOV     DL,byte ptr CS:DRV      ; Move next drive (to try) into DL
        INT     21h

        MOV     AX,CS                   ; Move Segment Address of PATH (CS)
        MOV     DS,AX                   ;  into Data Segment (DS)
        MOV     AH,3Bh                  ; Change Current Directory function
        MOV     DX,offset CS:PATH       ; Set DX to offset of PATH
        INT     21h

        JNC     EXIT                    ; Change Dir worked if Carry Flag=0
        ADD     byte ptr CS:DRV,1       ; Otherwise, inc Drive counter
        CMP     byte ptr CS:DRV,0Fh     ; If drive number is too high,
        JG      RESTDR                  ;  restore drive and stop.
        CLC
        JMP     CHGDR                   ; If drive number is okay then try
                                        ;  again.
RESTDR: MOV     AH,0Eh                  ; Set Drive function
        MOV     DL,byte ptr CS:OLD      ; Move previously saved drive to DL
        INT     21h                     ; Restore drive
        MOV     AH,4Ch                  ; Terminate function
        MOV     AL,01h                  ; Set ERRORLEVEL to 1  (no net drive)
        INT     21h

NETERR: MOV     AX,CS                   ; Move Segment Address of PATH (CS)
        MOV     DS,AX                   ; into Data Segment (DS)
        MOV     AH,09h                  ; Print String function
        MOV     DX,offset CS:NONET      ; Set DX to offset of NONET string
        INT     21h
        MOV     AH,4Ch                  ; Terminate function
        MOV     AL,02h                  ; Set ERRORLEVEL to 2  (no shell)
        INT     21h

EXIT:   MOV     AH,4Ch                  ; Terminate function
        MOV     AL,00h                  ; Set ERRORLEVEL to 0  (all okay)
        INT     21h

CODE    ENDS
        END     BEG
