{**********************************************************}
{*                  NETUSERS.PAS 1.01                     *}
{*      Released to the public domain by the author       *}
{*         Rob Roberts    74017,3503    7/28/90           *}
{**********************************************************}

{
  This unit interfaces three functions, GetUserName, CurrentUserIsMemberOf,
  and CurrentUserIsSupervisorEquivalent. They work only on Novell networks, and
  have been tested on ELS II v2.15, and NetWare 386 v3.0.

  Requires the NetWare unit from TurboPower Software's B-Tree Filer 5.0.
}


{$S-,R-,I-,V-,B-,F-}
unit NetUsers;

interface

uses Dos, NetWare;

function GetUserName : ObjectStr;
{ returns login name of current user }

function CurrentUserIsMemberOf(GroupName : ObjectStr) : boolean;
{ returns TRUE if current user is a member of group GroupName }

function CurrentUserIsSupervisorEquivalent : boolean;
{ returns TRUE if current user is Supervisor or Supervisor-equivalent }

implementation

type Str15 = string[15];

function IsBinderyObjInSet(ObjectName   : ObjectStr;
                           ObjectType   : BinderyObject;
                           PropertyName : Str15;
                           MemberType   : BinderyObject;
                           MemberName   : ObjectStr) : boolean;

var
  NovRegs          : Registers;
  Request          : record
                       Len      : Word;
                       SubF     : Byte;
                       ObjType  : Word;
                       Filler   : string[113]
                     end;
  Reply            : Word;
  W                : Word;
  I                : byte;

begin
  with Request do
    begin
      Len := 8 + length(ObjectName) + length(PropertyName) + length(MemberName);
      SubF    := $43;
      ObjType := Swap(Word(Ord(ObjectType)));
      Filler  := ObjectName;
      I       := length(ObjectName)+1;
      move(PropertyName, Filler[I], length(PropertyName)+1);
      inc(I, length(PropertyName)+1);
      W := Swap(Word(Ord(MemberType)));
      move(W, Filler[I], 2);
      inc(I, 2);
      move(MemberName, Filler[I], length(MemberName)+1)
    end;
  with NovRegs do
    begin
      AH := $E3;
      DS := Seg(Request);  {DS:SI points to request}
      SI := Ofs(Request);
      ES := Seg(Reply);    {ES:DI points to reply}
      DI := Ofs(Reply);
      MsDos(NovRegs)
    end;
  IsBinderyObjInSet := NovRegs.AL = 0
end;


function GetUserName : ObjectStr;

var
    ConnInfo : ConnInfoType;
    LoggedIn : boolean;

begin
  if NetwareLoaded(LoggedIn) and LoggedIn then
    begin
      GetConnInfo(GetConnNo, ConnInfo);
      GetUserName := ConnInfo.ObjectName
    end
  else GetUserName := 'UNKNOWN'
end;  { GetUserName }


function CurrentUserIsMemberOf(GroupName : ObjectStr) : boolean;

var LoggedIn : boolean;

begin
  if NetwareLoaded(LoggedIn) and LoggedIn then
    CurrentUserIsMemberOf := IsBinderyObjInSet(GetUserName, ObjUser,
                                 'GROUPS_I''M_IN', ObjGroup, GroupName)
  else CurrentUserIsMemberOf := false
end;  { CurrentUserIsMemberOf }


function CurrentUserIsSupervisorEquivalent : boolean;

var
    LoggedIn : boolean;
    UserName : string[48];

begin
  if NetwareLoaded(LoggedIn) and LoggedIn then
    begin
      UserName := GetUserName;
      CurrentUserIsSupervisorEquivalent := (UserName = 'SUPERVISOR') or
          IsBinderyObjInSet(GetUserName, ObjUser, 'SECURITY_EQUALS', ObjUser, 'SUPERVISOR')
    end
  else CurrentUserIsSupervisorEquivalent := false
end;  { CurrentUserIsMemberOf }


end.  { NetUsers }


