//
// $Id: ttt.cpp 1.6 1992/08/29 19:49:20 rthomas Exp $
//
// The Press-Enterprise Co.
// 3512 Fourteenth Street
// Riverside, California 92501-3878
// (c) Copyright 1992
//
// Author: Randolph Thomas
// 
// $Log: ttt.cpp $
// Revision 1.6  1992/08/29  19:49:20  rthomas
// Send more info in Info packets regarding play status.
//
// Revision 1.5  1992/08/28  23:08:26  rthomas
// Corrected the autoplay and added more debug info.
//
// Revision 1.4  1992/08/28  18:12:28  rthomas
// Moved the AI routines to ai.cpp.  Now if you're in both
// Computer and Friendly modes, it will randomly pick other players
// to play.
//
// Revision 1.3  1992/08/27  23:57:36  rthomas
// Changed the screen some, made the computer smarter.
//
// Revision 1.2  1992/08/27  22:08:48  rthomas
// It's now playable.  Includes computer and friendly modes.
//
// Revision 1.1  1992/08/26  16:20:30  rthomas
// Initial revision
//
//

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <string.h>
#include <time.h>
#include <novell.h>
#include "ttt.h"

void SetupListenECBs( WORD socket );
int FindNextECBin( void );
void SetupListenECB(ECB *e, IPXpacket *p, WORD socket);
void SetupSendECB(ECB *e, IPXpacket *p, BYTE *net, BYTE *node, WORD socket);
void GetMyName( void );
void ClearScreen( void );
void GotoXY(BYTE x, BYTE y);
Player *FindPartner( void );
void ChangePlayerInfo(Player **playerlist, IPXpacket *ipx);
void ShowPlayers(Player *playlist);
Player *FindPlayer(Player *plist, IPXpacket *ipx);
void RemovePlayer(Player **playerlist, IPXpacket *ipx);
void DrawGrid( void );
void PlayWith(Player *oppon);
void MarkO(int i, int j);
void MarkX(int i, int j);
int EvalBoard(int Board[3][3]);
int ComputerPickSquare(int Board[3][3]);

static char Copyright[]="Copyright 1992, The Press-Enterprise Co.";
static char RcsID[]="$Id: ttt.cpp 1.6 1992/08/29 19:49:20 rthomas Exp $";
static BYTE BroadcastAddress[]={0xff,0xff,0xff,0xff,0xff,0xff};
BYTE OurAddress[10];
char MyName[15];
WORD socket;

IPXpacket incomingIPX[ MAX_PACKETS ];
IPXpacket outgoingIPX;
ECB ECBin[ MAX_PACKETS ];
ECB ECBout;

static int PositionsI[]={10,22,34};
static int PositionsJ[]={3,9,15};
Player *players;
int ComputerMode=0,DebugLevel=0, FriendlyMode=0;
int Wins=0,Loses=0,Ties=0;

void main(int argc, char **argv)
{
	Player *oppon;
	int i;

	GetMyName();
	if (argc>1)
	{
		for (i=1;i<argc;i++)
		{
			if (argv[i][0]=='-')
			{
				switch (argv[i][1])
				{
					case 'n':
						if (++i<argc)
							strncpy(MyName,argv[i],14);
						break;
					case 'h':
						printf("Network Tic-Tac-Toe\n");
						printf("Usage:\n%s [-n name] [-h] [-d]\n",argv[0]);
						exit(0);
						break;
					case 'd':
						DebugLevel++;
						break;
					default:
						fprintf(stderr,"Huh?\n");
						exit(5);
						break;
				}
			}
		}
	}
	if (!IPXInitialize())
	{
		fprintf(stderr,"IPX must be loaded first.\n");
	}
	socket = TTT_SOCKET;
	if (IPXOpenSocket(&socket,0))
	{
		fprintf(stderr,"Can't open socket.\n");
	}
	IPXGetInternetworkAddress(&OurAddress[0]);
	SetupListenECBs(socket);
	players=NULL;
	srand( (unsigned)time( NULL ) );
	while (oppon=FindPartner())
	{
		PlayWith(oppon);
	}
	IPXCloseSocket(socket);
}

void SetupListenECBs( WORD socket )
{
	int i;

	for (i=0;i<MAX_PACKETS;i++)
	{
		SetupListenECB(&ECBin[i],&incomingIPX[i],socket);
		IPXListenForPacket(&ECBin[i]);
	}
}

int FindNextECBin( void )
{
	int i;

	for (i=0;i<MAX_PACKETS;i++)
		if (!ECBin[i].InUseFlag)
			return i;
	return -1;
}

void SetupListenECB(ECB *e, IPXpacket *p, WORD socket)
{
	e->LinkAddress=0;
	e->ESRAddress=0;
	e->SocketNumber=(((socket>>8)&0xFF)|((socket<<8)&0xFF00));
	e->FragmentCount=1;
	e->FragmentAddress1=p;
	e->FragmentSize1=sizeof(IPXpacket);
	p->Checksum=0;
	p->Length=0;
	p->TransportControl=0;
	p->PacketType=0;
}

void SetupSendECB(ECB *e, IPXpacket *p, BYTE *net, BYTE *node, WORD socket)
{
	e->ESRAddress=0;
	e->InUseFlag=0;
	memmove(e->ImmediateAddress,node,6);
	e->SocketNumber=(((socket>>8)&0xFF)|((socket<<8)&0xFF00));
	e->FragmentCount=1;
	e->FragmentAddress1=p;
	e->FragmentSize1=p->Length;
	p->TransportControl=0;
	p->PacketType=0;
	memmove(p->DestinationNetwork,net,4);
	memmove(p->DestinationNode,node,6);
	p->DestinationSocket[1]=socket&0xFF;
	p->DestinationSocket[0]=(socket&0xFF00)>>8;
	memmove(outgoingIPX.SourceNetwork,&OurAddress[0],10);
	p->SourceSocket[1]=socket&0xFF;
	p->SourceSocket[0]=(socket&0xFF00)>>8;
}

void GetMyName( void )
{
	int connection=GetConnectionNumber();
	WORD objectType;
	long objectID;
	BYTE loginTime[7];
	char objectName[48];

	strcpy(MyName,"Unknown");	// assume name is unknown
	if (connection)
	{
		if (!GetConnectionInformation(connection,objectName,&objectType,
			&objectID,loginTime))
		{
			strncpy(MyName,objectName,14);
		}
	}
}

void ClearScreen( void )
{
	_asm
	{
		mov	ax,0600h
		mov bh,7
		mov cx,0
		mov dx,184Fh
		int 10h
	}
}

void GotoXY(BYTE x, BYTE y)
{
	_asm
	{
		mov	ah,2
		mov	bh,0
		mov	dh,y
		mov	dl,x
		int 10h
	}
}

Player *FindPartner( void )
{
	int done,InPacket,i;
	unsigned int key;
	Player *plist;
	time_t start_secs;

	ClearScreen();
	GotoXY(0,0);
	printf("Looking ...\n");
	outgoingIPX.Length=30 + 1 + 15;
	outgoingIPX.Data[0]=Query;
	strcpy((char *)&outgoingIPX.Data[1],MyName);
	SetupSendECB(&ECBout,&outgoingIPX,&OurAddress[0],
		BroadcastAddress,socket);
	IPXSendPacket(&ECBout);
	time(&start_secs);
	done=0;
	while (!done)
	{
		if (_bios_keybrd(_KEYBRD_READY))
		{
			key=_bios_keybrd(_KEYBRD_READ) & 0xFF;
			switch (key)
			{
				case 'q':
				case 0x1B:	// Escape?
					done=1;
					outgoingIPX.Length=30 + 1 + 15;
					outgoingIPX.Data[0]=Quitting;
					strcpy((char *)&outgoingIPX.Data[1],MyName);
					SetupSendECB(&ECBout,&outgoingIPX,&OurAddress[0],
						BroadcastAddress,socket);
					IPXSendPacket(&ECBout);
					printf("Quitting ...\n");
					break;
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					i=1;
					key-='0';	// make into integer
					plist=players;
					while ((plist!=NULL)&&(i!=key))
					{
						i++;
						plist=plist->next;
					}
					if (plist!=NULL)
					{
						plist->info->WantedForPlay=1;
						outgoingIPX.Length=30 + 1 + 15;
						outgoingIPX.Data[0]=QueryPlay;
						strcpy((char *)&outgoingIPX.Data[1],MyName);
						SetupSendECB(&ECBout,&outgoingIPX,
							(BYTE *)&plist->address[0],
							(BYTE *)&plist->address[4],socket);
						IPXSendPacket(&ECBout);
						if ((plist->info->Status==Available)&&
							(plist->info->WantsPlay))
							return plist;
					}
					break;
				case 'c':
					if (ComputerMode)
					{
						ComputerMode=0;
					}
					else
					{
						ComputerMode=1;
						time(&start_secs);
					}
					ClearScreen();
					GotoXY(0,0);
					ShowPlayers(players);
					break;
				case 'f':
					if (FriendlyMode)
					{
						FriendlyMode=0;
					}
					else
					{
						FriendlyMode=1;
						time(&start_secs);
					}
					ClearScreen();
					GotoXY(0,0);
					ShowPlayers(players);
					break;
				default:
					break;
			}
		}
		if ((InPacket=FindNextECBin())!=-1)	// have we received a packet?
		{
			//
			// Ignore packets that have bad Completions, don't have data
			// or came from ourselves.
			//
			if ((!ECBin[InPacket].CompletionCode)&&
				(incomingIPX[InPacket].Length!=0x1e00)&&
				memcmp(incomingIPX[InPacket].SourceNode,&OurAddress[4],6))
			{
				switch (incomingIPX[InPacket].Data[0])
				{
					case Query:
						if (DebugLevel>1)
							printf("Queried by %s\n",incomingIPX[InPacket].Data[1]);
						while (ECBout.InUseFlag);	// wait around
						outgoingIPX.Length=30 + 1 + 1 + 15 + 1;
						outgoingIPX.Data[0]=Info;
						outgoingIPX.Data[1]=Available;
						strcpy((char *)&outgoingIPX.Data[2],MyName);
						outgoingIPX.Data[17]=FriendlyMode;
						SetupSendECB(&ECBout,&outgoingIPX,
							incomingIPX[InPacket].SourceNetwork,
							incomingIPX[InPacket].SourceNode,socket);
						IPXSendPacket(&ECBout);
						plist=FindPlayer(players,&incomingIPX[InPacket]);
						if (plist==NULL)	// Were they in our list?
						{
							while (ECBout.InUseFlag);	// wait around
							outgoingIPX.Length=30 + 1 + 15;
							outgoingIPX.Data[0]=Query;
							strcpy((char *)&outgoingIPX.Data[1],MyName);
							SetupSendECB(&ECBout,&outgoingIPX,
								incomingIPX[InPacket].SourceNetwork,
								incomingIPX[InPacket].SourceNode,socket);
							IPXSendPacket(&ECBout);
						}
						break;
					case Info:
						if (DebugLevel>1)
							printf("Sent info to %s\n",incomingIPX[InPacket].Data[1]);
						ChangePlayerInfo(&players,&incomingIPX[InPacket]);
						ClearScreen();
						GotoXY(0,0);
						ShowPlayers(players);
						break;
					case QueryPlay:
						plist=FindPlayer(players,&incomingIPX[InPacket]);
						if (plist!=NULL)	// Were they in our list?
						{
							if (plist->info->WantedForPlay)
								return plist;
							if (FriendlyMode)
							{
								outgoingIPX.Length=30 + 1 + 15;
								outgoingIPX.Data[0]=QueryPlay;
								strcpy((char *)&outgoingIPX.Data[1],MyName);
								SetupSendECB(&ECBout,&outgoingIPX,
									(BYTE *)&plist->address[0],
									(BYTE *)&plist->address[4],socket);
								IPXSendPacket(&ECBout);
								return plist;
							}
							plist->info->WantsPlay=1;
						}
						ClearScreen();
						GotoXY(0,0);
						ShowPlayers(players);
						break;
					case Quitting:
						RemovePlayer(&players,&incomingIPX[InPacket]);
						ClearScreen();
						GotoXY(0,0);
						ShowPlayers(players);
						break;
					case QuitGame:
					case QueryRandom100:
					case Random100:
					case Move:
						break;
					default:
						printf("Unknown packet type receieved!\n");
				}
			}
			SetupListenECB(&ECBin[InPacket],&incomingIPX[InPacket],socket);
			IPXListenForPacket(&ECBin[InPacket]);
		}
		if (ComputerMode&&FriendlyMode&&((time(NULL)-start_secs)>3))
		{
			key=0;
			plist=players;
			while (plist!=NULL)	// count the number of players
			{
				key++;
				plist=plist->next;
			}
			if (key)
			{
				key=rand()%key;
				i=0;
				plist=players;
				while ((plist!=NULL)&&(i!=key))
				{
					i++;
					plist=plist->next;
				}
				if ((plist!=NULL)&&(!plist->info->WantedForPlay))
				{
					plist->info->WantedForPlay=1;
					outgoingIPX.Length=30 + 1 + 15;
					outgoingIPX.Data[0]=QueryPlay;
					strcpy((char *)&outgoingIPX.Data[1],MyName);
					SetupSendECB(&ECBout,&outgoingIPX,
						(BYTE *)&plist->address[0],
						(BYTE *)&plist->address[4],socket);
					IPXSendPacket(&ECBout);
					if ((plist->info->Status==Available)&&
						(plist->info->WantsPlay))
						return plist;
				}
			}
			time(&start_secs);
		}
	}
	return 0;
}

void ChangePlayerInfo(Player **playerlist, IPXpacket *ipx)
{
	Player *plist,*newp;

	plist=*playerlist;
	while ((plist!=NULL)&&
		(memcmp(plist->address,ipx->SourceNetwork,10)))
	{
		plist=plist->next;
	}
	if (plist==NULL)	// Not found?
	{
		newp=(Player *)malloc(sizeof(Player));
		memmove(newp->address,ipx->SourceNetwork,10);
		newp->next=NULL;
		newp->info=(InfoPacket *)malloc(sizeof(InfoPacket));
		newp->info->WantsPlay=0;
		newp->info->WantedForPlay=0;
		newp->info->IsFriendly=0;
		if ((plist=*playerlist)!=NULL)	// Not the first node?
		{
			while (plist->next!=NULL) plist=plist->next;
			plist->next=newp;
		}
		else
		{
			*playerlist=newp;
		}
		plist=newp;
	}
	// Found them within the list, update their info
	plist->info->Status=(InfoStatusType)ipx->Data[1];
	memmove(plist->info->MyName,&ipx->Data[2],15);
	if (plist->info->Status==Available)
		plist->info->IsFriendly=ipx->Data[17];
	else
	{
		memmove(plist->info->Opponent,&ipx->Data[17],15);
		plist->info->PlayingStatus=(PlayStatusTypes)ipx->Data[32];
	}
}

void ShowPlayers(Player *playlist)
{
	int i=1;

	while (playlist!=NULL)
	{
		printf("%d. %s ",i++,playlist->info->MyName);
		switch (playlist->info->Status)
		{
			case Available:
				printf("is available");
				if (playlist->info->WantsPlay)
				{
					printf(" and wants to play");
				}
				else
				{
					if (playlist->info->IsFriendly)
						printf(" and friendly");
				}
				printf("\n");
				break;
			case Playing:
				switch (playlist->info->PlayingStatus)
				{
					case Won:
						printf("beat %s\n",playlist->info->Opponent);
						break;
					case Lost:
						printf("lost to %s\n",playlist->info->Opponent);
						break;
					case Tie:
						printf("tied with %s\n",playlist->info->Opponent);
						break;
					case OpponentQuit:
						printf("was too hard for %s\n",playlist->info->Opponent);
						break;
					default:
						printf("is playing %s\n",playlist->info->Opponent);
						break;
				}
				break;
			default:
				printf("is doing who knows what?\n");
				break;
		}
		playlist=playlist->next;
	}
	printf("\nWins: %3d Loses: %3d Ties: %3d\n",Wins,Loses,Ties);
	GotoXY(5,24);
	if (ComputerMode)
		printf("Computer");
	else
		printf("        ");
	GotoXY(14,24);
	if (FriendlyMode)
		printf("Friendly");
	else
		printf("        ");
}

Player *FindPlayer(Player *plist, IPXpacket *ipx)
{
	while ((plist!=NULL)&&
		(memcmp(plist->address,ipx->SourceNetwork,10)))
	{
		plist=plist->next;
	}
	return plist;
}

void RemovePlayer(Player **playerlist, IPXpacket *ipx)
{
	Player *plist,*plast;

	plist=*playerlist;
	plast=NULL;
	while ((plist!=NULL)&&
		(memcmp(plist->address,ipx->SourceNetwork,10)))
	{
		plast=plist;
		plist=plist->next;
	}
	if (plist!=NULL)	// found them
	{
		if (plast==NULL)	// beginning of list?
		{
			*playerlist=plist->next;
		}
		else
		{
			plast->next=plist->next;
		}
		free(plist->info);
		free(plist);
	}
}

void DrawGrid( void )
{
	GotoXY(0,2);
	printf("                                          \n");
	printf("                                          \n");
	printf("               1          2          3    \n");
	printf("                                          \n");
	printf("                                          \n");
	printf("          \n");
	printf("                                          \n");
	printf("                                          \n");
	printf("               4          5          6    \n");
	printf("                                          \n");
	printf("                                          \n");
	printf("          \n");
	printf("                                          \n");
	printf("                                          \n");
	printf("               7          8          9    \n");
	printf("                                          \n");
	printf("                                          \n");
}

void PlayWith(Player *oppon)
{
	int done,InPacket,i,j,move,SentEndGameStatus=0;
	unsigned int key;
	Player *plist;
	int PlayStatus=PickingFirst;
	BYTE OurRoll,TheirRoll,TheirMove;
	int Board[3][3];
	time_t	wait_secs, start_secs;

	while (ECBout.InUseFlag);	// wait around
	outgoingIPX.Length=30 + 1 + 1 + 15 + 15 + 1;
	outgoingIPX.Data[0]=Info;
	outgoingIPX.Data[1]=Playing;
	strcpy((char *)&outgoingIPX.Data[2],MyName);
	strcpy((char *)&outgoingIPX.Data[17],oppon->info->MyName);
	outgoingIPX.Data[32]=PlayStatus;
	SetupSendECB(&ECBout,&outgoingIPX,&OurAddress[0],
		BroadcastAddress,socket);
	IPXSendPacket(&ECBout);
	OurRoll=(BYTE)(rand()%100);
	time(&start_secs);
	while ((time(NULL)-start_secs)<2)
		IPXRelinquishControl();
	while (ECBout.InUseFlag);	// wait around
	outgoingIPX.Length=30 + 1;
	outgoingIPX.Data[0]=QueryRandom100;
	SetupSendECB(&ECBout,&outgoingIPX,(BYTE *)&oppon->address[0],
		(BYTE *)&oppon->address[4],socket);
	IPXSendPacket(&ECBout);
	time(&start_secs);
	for (i=0;i<3;i++)
		for (j=0;j<3;j++)
			Board[i][j]=None;
	ClearScreen();
	DrawGrid();
	GotoXY(0,19);
	printf("Opponent: %s\n",oppon->info->MyName);
	printf("Rolling die");
	move=0;
	done=0;
	while (!done)
	{
		if (_bios_keybrd(_KEYBRD_READY))
		{
			key=_bios_keybrd(_KEYBRD_READ) & 0xFF;
			switch (key)
			{
				case 'c':
					if (ComputerMode)
					{
						ComputerMode=0;
					}
					else
					{
						ComputerMode=1;
						time(&start_secs);
					}
					break;
				case 'q':
				case 0x1B:	// Escape?
					done=1;
					while (ECBout.InUseFlag);	// wait around
					outgoingIPX.Length=30 + 1;
					outgoingIPX.Data[0]=QuitGame;
					SetupSendECB(&ECBout,&outgoingIPX,
						(BYTE *)&oppon->address[0],
						(BYTE *)&oppon->address[4],socket);
					IPXSendPacket(&ECBout);
					while (ECBout.InUseFlag);	// wait around
					outgoingIPX.Length=30 + 1 + 1 + 15;
					outgoingIPX.Data[0]=Info;
					outgoingIPX.Data[1]=Available;
					strcpy((char *)&outgoingIPX.Data[2],MyName);
					SetupSendECB(&ECBout,&outgoingIPX,&OurAddress[0],
						BroadcastAddress,socket);
					IPXSendPacket(&ECBout);
					oppon->info->WantsPlay=0;
					oppon->info->WantedForPlay=0;
					break;
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					if (PlayStatus==OurTurn)
					{
						key-='1';	// make into integer 0-8
						i=key%3;
						j=key/3;
						if (Board[i][j]==None)
						{
							while (ECBout.InUseFlag);	// wait around
							outgoingIPX.Length=30 + 1 + 1;
							outgoingIPX.Data[0]=Move;
							outgoingIPX.Data[1]=key;
							SetupSendECB(&ECBout,&outgoingIPX,
								(BYTE *)&oppon->address[0],
								(BYTE *)&oppon->address[4],socket);
							IPXSendPacket(&ECBout);
							PlayStatus=TheirTurn;
							Board[i][j]=Us;
							MarkX(i,j);
							if (DebugLevel)
							{
								GotoXY(60,7+move++);
								printf("Us   = %d",key);
							}
							switch (EvalBoard(Board))
							{
									case Us:
										GotoXY(0,20);
										printf("You won!!           ");
										Wins++;
										PlayStatus=Won;
										break;
									case Them:
										GotoXY(0,20);
										printf("Boo!  You lost.     ");
										Loses++;
										PlayStatus=Lost;
										break;
									case Tied:
										GotoXY(0,20);
										printf("Tie game.           \n");
										Ties++;
										PlayStatus=Tie;
										break;
									case None:
										GotoXY(0,20);
										printf("Waiting for them ...\n      \n");
										GotoXY(20,20);
										break;
							}
							time(&start_secs);
						}
						else
						{
							GotoXY(0,21);
							printf("Taken!");
							GotoXY(15,20);
						}
					}
				default:
					break;
			}
		}
		if ((InPacket=FindNextECBin())!=-1)	// have we received a packet?
		{
			//
			// Ignore packets that have bad Completions, don't have data
			// or came from ourselves.
			//
			if ((!ECBin[InPacket].CompletionCode)&&
				(incomingIPX[InPacket].Length!=0x1e00)&&
				memcmp(incomingIPX[InPacket].SourceNode,&OurAddress[4],6))
			{
				switch (incomingIPX[InPacket].Data[0])
				{
					case Query:
						if (!memcmp(&incomingIPX[InPacket].SourceNode,
							&oppon->address[4],6))
						{	// This should only happen if they bombed.
							if ((PlayStatus!=Won)&&(PlayStatus!=Lost)&&(PlayStatus!=Tie))
							{
								GotoXY(10,19);
								printf("%s just quit the game.",oppon->info->MyName);
								PlayStatus=OpponentQuit;
							}
						}
						while (ECBout.InUseFlag);	// wait around
						outgoingIPX.Length=30 + 1 + 1 + 15 + 15 + 1;
						outgoingIPX.Data[0]=Info;
						outgoingIPX.Data[1]=Playing;
						strcpy((char *)&outgoingIPX.Data[2],MyName);
						strcpy((char *)&outgoingIPX.Data[17],oppon->info->MyName);
						outgoingIPX.Data[32]=PlayStatus;
						SetupSendECB(&ECBout,&outgoingIPX,
							incomingIPX[InPacket].SourceNetwork,
							incomingIPX[InPacket].SourceNode,socket);
						IPXSendPacket(&ECBout);
						plist=FindPlayer(players,&incomingIPX[InPacket]);
						if (plist==NULL)	// Were they in our list?
						{
							while (ECBout.InUseFlag);	// wait around
							outgoingIPX.Length=30 + 1 + 15;
							outgoingIPX.Data[0]=Query;
							strcpy((char *)&outgoingIPX.Data[1],MyName);
							SetupSendECB(&ECBout,&outgoingIPX,
								incomingIPX[InPacket].SourceNetwork,
								incomingIPX[InPacket].SourceNode,socket);
							IPXSendPacket(&ECBout);
						}
						break;
					case Info:
						ChangePlayerInfo(&players,&incomingIPX[InPacket]);
						break;
					case QueryPlay:
						plist=FindPlayer(players,&incomingIPX[InPacket]);
						if (plist!=NULL)	// Were they in our list?
						{
							plist->info->WantsPlay=1;
						}
						break;
					case Quitting:
						RemovePlayer(&players,&incomingIPX[InPacket]);
						break;
					case QuitGame:
						if (!memcmp(&incomingIPX[InPacket].SourceNode,
							&oppon->address[4],6))
						{
							if ((PlayStatus!=Won)&&(PlayStatus!=Lost)&&(PlayStatus!=Tie))
							{
								GotoXY(10,19);
								printf("%s just quit the game.",oppon->info->MyName);
								PlayStatus=OpponentQuit;
							}
						}
						break;
					case QueryRandom100:
						if (!memcmp(&incomingIPX[InPacket].SourceNode,
							&oppon->address[4],6))
						{
							while (ECBout.InUseFlag);	// wait around
							outgoingIPX.Length=30 + 1 + 1;
							outgoingIPX.Data[0]=Random100;
							outgoingIPX.Data[1]=OurRoll;
							SetupSendECB(&ECBout,&outgoingIPX,
								(BYTE *)&oppon->address[0],
								(BYTE *)&oppon->address[4],socket);
							IPXSendPacket(&ECBout);
						}
						break;
					case Random100:
						if (!memcmp(&incomingIPX[InPacket].SourceNode,
							&oppon->address[4],6)&&(PlayStatus==PickingFirst))
						{
							TheirRoll=incomingIPX[InPacket].Data[1];
							if (OurRoll==TheirRoll)	// shucks, roll again
							{
								while (ECBout.InUseFlag);	// wait around
								outgoingIPX.Length=30 + 1 + 1;
								outgoingIPX.Data[0]=Random100;
								OurRoll=(BYTE)(rand()%100);
								outgoingIPX.Data[1]=OurRoll;
								SetupSendECB(&ECBout,&outgoingIPX,
									(BYTE *)&oppon->address[0],
									(BYTE *)&oppon->address[4],socket);
								IPXSendPacket(&ECBout);
							}
							else
							{
								GotoXY(0,1);
								if (DebugLevel)
									printf("OurRoll(%d) TheirRoll(%d)",OurRoll,TheirRoll);
								GotoXY(0,20);
								if (OurRoll>TheirRoll)
								{
									if (ComputerMode)
									{
										key=ComputerPickSquare(Board);
										i=key%3;
										j=key/3;
										while (ECBout.InUseFlag);	// wait around
										outgoingIPX.Length=30 + 1 + 1;
										outgoingIPX.Data[0]=Move;
										outgoingIPX.Data[1]=key;
										SetupSendECB(&ECBout,&outgoingIPX,
											(BYTE *)&oppon->address[0],
											(BYTE *)&oppon->address[4],socket);
										IPXSendPacket(&ECBout);
										PlayStatus=TheirTurn;
										Board[i][j]=Us;
										MarkX(i,j);
										if (DebugLevel)
										{
											GotoXY(60,7+move++);
											printf("Us   = %d",key);
										}
										switch (EvalBoard(Board))
										{
												case Us:
													GotoXY(0,20);
													printf("You won!!           ");
													Wins++;
													PlayStatus=Won;
													break;
												case Them:
													GotoXY(0,20);
													printf("Boo!  You lost.     ");
													Loses++;
													PlayStatus=Lost;
													break;
												case Tied:
													GotoXY(0,20);
													printf("Tie game.           \n");
													Ties++;
													PlayStatus=Tie;
													break;
												case None:
													GotoXY(0,20);
													printf("Waiting for them ...\n      \n");
													GotoXY(20,20);
													break;
										}
									}
									else
									{
										PlayStatus=OurTurn;
										printf("Pick a Square:      ");
										GotoXY(15,20);
									}
								}
								else
								{
									PlayStatus=TheirTurn;
									printf("Waiting for them ...");
								}
							}
						}
						break;
					case Move:
						if (!memcmp(&incomingIPX[InPacket].SourceNode,
							&oppon->address[4],6))
						{
							if (PlayStatus==PickingFirst)
							{
								GotoXY(0,1);
								if (DebugLevel)
									printf("Prempted OurRoll(%d)",OurRoll);
								PlayStatus=TheirTurn;
							}
							if (PlayStatus==OurTurn)
							{
								GotoXY(0,22);
								printf("They cheated!");
							}
							TheirMove=incomingIPX[InPacket].Data[1];
							i=TheirMove%3;
							j=TheirMove/3;
							Board[i][j]=Them;
							MarkO(i,j);
							if (DebugLevel)
							{
								GotoXY(60,7+move++);
								printf("Them = %d",TheirMove);
							}
							switch (EvalBoard(Board))
							{
									case Us:
										GotoXY(0,20);
										printf("You won!!           ");
										Wins++;
										PlayStatus=Won;
										break;
									case Them:
										GotoXY(0,20);
										printf("Boo!  You lost.     ");
										Loses++;
										PlayStatus=Lost;
										break;
									case Tied:
										GotoXY(0,20);
										printf("Tie game.           \n");
										Ties++;
										PlayStatus=Tie;
										break;
									case None:
										if (ComputerMode)
										{
											key=ComputerPickSquare(Board);
											i=key%3;
											j=key/3;
											while (ECBout.InUseFlag);	// wait around
											outgoingIPX.Length=30 + 1 + 1;
											outgoingIPX.Data[0]=Move;
											outgoingIPX.Data[1]=key;
											SetupSendECB(&ECBout,&outgoingIPX,
												(BYTE *)&oppon->address[0],
												(BYTE *)&oppon->address[4],socket);
											IPXSendPacket(&ECBout);
											PlayStatus=TheirTurn;
											Board[i][j]=Us;
											MarkX(i,j);
											if (DebugLevel)
											{
												GotoXY(60,7+move++);
												printf("Us   = %d",key);
											}
											switch (EvalBoard(Board))
											{
												case Us:
													GotoXY(0,20);
													printf("You won!!           ");
													Wins++;
													PlayStatus=Won;
													break;
												case Them:
													GotoXY(0,20);
													printf("Boo!  You lost.     ");
													Loses++;
													PlayStatus=Lost;
													break;
												case Tied:
													GotoXY(0,20);
													printf("Tie game.           \n");
													Ties++;
													PlayStatus=Tie;
													break;
												case None:
													GotoXY(0,20);
													printf("Waiting for them ...\n      \n");
													GotoXY(20,20);
													break;
											}
										}
										else
										{
											GotoXY(0,20);
											printf("Pick a square:      ");
											GotoXY(15,20);
											PlayStatus=OurTurn;
										}
										break;
							}
							time(&start_secs);
						}
						break;
					default:
						printf("Unknown packet type receieved!\n");
				}
			}
			SetupListenECB(&ECBin[InPacket],&incomingIPX[InPacket],socket);
			IPXListenForPacket(&ECBin[InPacket]);
		}
		if ((PlayStatus==PickingFirst)&& ((time(NULL)-start_secs)>3))
		{
			while (ECBout.InUseFlag);	// wait around
			outgoingIPX.Length=30 + 1;
			outgoingIPX.Data[0]=QueryRandom100;
			SetupSendECB(&ECBout,&outgoingIPX,
				(BYTE *)&oppon->address[0],
				(BYTE *)&oppon->address[4],socket);
			IPXSendPacket(&ECBout);
			time(&start_secs);
		}
		if (((PlayStatus==Won)||(PlayStatus==Lost)||
			(PlayStatus==Tie)||(PlayStatus==OpponentQuit))
			&&((time(NULL)-start_secs)>3)&&!SentEndGameStatus)
		{	// Game is over and we're bored
			if (ComputerMode)	// We're a computer, so lets play some more.
			{
				done=1;
				outgoingIPX.Length=30 + 1 + 1 + 15;
				outgoingIPX.Data[0]=Info;
				outgoingIPX.Data[1]=Available;
				strcpy((char *)&outgoingIPX.Data[2],MyName);
				outgoingIPX.Data[17]=ComputerMode;
				SetupSendECB(&ECBout,&outgoingIPX,&OurAddress[0],
					BroadcastAddress,socket);
				IPXSendPacket(&ECBout);
				oppon->info->WantsPlay=0;
				oppon->info->WantedForPlay=0;
			}
			else	// We're human, so let's just tell our status
			{
				while (ECBout.InUseFlag);	// wait around
				outgoingIPX.Length=30 + 1 + 1 + 15 + 15 + 1;
				outgoingIPX.Data[0]=Info;
				outgoingIPX.Data[1]=Playing;
				strcpy((char *)&outgoingIPX.Data[2],MyName);
				strcpy((char *)&outgoingIPX.Data[17],oppon->info->MyName);
				outgoingIPX.Data[32]=PlayStatus;
				SetupSendECB(&ECBout,&outgoingIPX,
					&OurAddress[0],
					BroadcastAddress,socket);
				IPXSendPacket(&ECBout);
				SentEndGameStatus=1;
			}
		}
	}
}

void MarkO(int i, int j)
{
	i=PositionsI[i];
	j=PositionsJ[j];
	GotoXY(i,j);
	printf("   /\\  ");
	GotoXY(i,++j);
	printf("         ");
	GotoXY(i,++j);
	printf("   \\/  ");
}

void MarkX(int i, int j)
{
	i=PositionsI[i];
	j=PositionsJ[j];
	GotoXY(i,j);
	printf("    \\ /  ");
	GotoXY(i,++j);
	printf("     X    ");
	GotoXY(i,++j);
	printf("    / \\  ");
}

int EvalBoard(int Board[3][3])
{
	int i,j;

	for (i=0;i<3;i++)		// check down
		if (Board[i][0]!=None)
			if ((Board[i][0]==Board[i][1])&&(Board[i][0]==Board[i][2]))
				return Board[i][0];
	for (j=0;j<3;j++)		// check across
		if (Board[0][j]!=None)
			if ((Board[0][j]==Board[1][j])&&(Board[0][j]==Board[2][j]))
				return Board[0][j];
	if (Board[0][0]!=None)	// check diagonal
		if ((Board[0][0]==Board[1][1])&&(Board[0][0]==Board[2][2]))
			return Board[0][0];
	if (Board[0][2]!=None)	// check diagonal
		if ((Board[0][2]==Board[1][1])&&(Board[0][2]==Board[2][0]))
			return Board[0][2];
	for (i=0;i<3;i++)		// Check for empty spots
		for (j=0;j<3;j++)
			if (Board[i][j]==None)
				return None;
	return Tied;			// must be tied
}
