;Simulates a disk-drive light for network activity.  When a packet is sent or
;recieved, a block will flash at the upper, right corner of the screen.
;
;Andy Stevens   11/10/87

         page ,132
         name NetLight

CR                    equ 13
LF                    equ 10
Interrupt             equ 71h

CSeg     segment byte public 'CODE'
         org     100h
         assume  CS: CSeg, DS:CSeg, ES: nothing, SS: nothing

ENTRY    proc near
         jmp  initialize               ;skip over the resident part of program


OldVector label dword                  ;storage space for old interrupt vector
         VectorOff dw 0
         VectorSeg dw 0

CursorRow db 0
CursorCol db 0
Character db 0
Attribute db 0

Signature db 'NETLIGHT'

InterruptServiceRoutine proc far
         call Invert
         jmp  cs: dword ptr OldVector  ;call the old int 0x71 ISR
InterruptServiceRoutine endp

Invert proc near
         push  ax
         push  bx
         push  cx
         push  dx

         mov  ah, 3                    ;get cursor position
         xor  bh, bh                   ;page 0
         int  10h
         mov  cs: byte ptr CursorRow, dh            ;save for later
         mov  cs: byte ptr CursorCol, dl

         mov  ah, 2                    ;set cursor position
         mov  dl, 79                   ;colum 79
         xor  dh, dh                   ;row 0
         xor  bh, bh                   ;page 0
         int  10h

         mov  ah, 8                    ;get character and attribute
         xor  bh, bh                   ;page 0
         int  10h
         mov  cs: byte ptr Character, al   ;save for later
         mov  cs: byte ptr Attribute, ah

         mov  ah, 9                    ;put character and attribute
         mov  al, 219                  ;block character
         mov  bl, ah
         not  bl                       ;reverse the attribute
         xor  bh, bh                   ;page 0
         mov  cx, 1                    ;one character
         int  10h

         mov  cx, 100                  ;brief delay
l1:      nop
         loop l1

         mov  ah, 9                        ;put character and attribute
         mov  al, cs: byte ptr Character   ;restore old character
         mov  bl, cs: byte ptr Attribute   ;and attribute
         xor  bh, bh                       ;page 0
         mov  cx, 1                        ;one character
         int  10h

         mov  ah, 2                        ;set cursor position
         mov  dh, cs: byte ptr CursorRow   ;restore old cursor position
         mov  dl, cs: byte ptr CursorCol
         xor  bh, bh
         int  10h

         pop  dx
         pop  cx
         pop  bx
         pop  ax
         ret
Invert endp


     page
;***************************************************************************
;* The remainder of code will perform the folowing functions:
;*
;*    1) verify that the computer is running a NetWare shell.
;*    2) check for previous installation of NetLight.
;*    3) terminate and stay resident, leaving only the ISR
;*
;*
;*  Everything below this point will be discarded when the program TSR's
;*

Initialize:
     call CheckForIPX             ;check for an IPX module
     call CheckPrevious           ;check for previous installations

     mov ax, 3500h + Interrupt    ;save old interrupt vector
     int 21h                      ;returned in ES:BX

     mov VectorSeg, es
     mov VectorOff, bx

     mov ax, cs
     mov ds, ax
     mov dx, offset InterruptServiceRoutine
     mov ax, 2500h + Interrupt
     int 21h

     mov  dx, offset message1       ;confirmation message
     mov  ah, 9
     int  21h                       ;display message
     mov  dx, offset Initialize
     int  27h                       ;TSR
ENTRY endp

CheckForIPX proc near
     mov  ax, 357Ah                 ;get interrupt address of int 0x7A
     int  21h                       ;vector returned in ES:BX
     sub  bx, 6                     ;IPX signature begins 6 bytes before
     mov  di, bx                    ;the int 0x7A handler
     mov  si, offset IPXString
     mov  cx, 4
     cli
     repz cmpsb
     jnz  NoIPX
     ret
NoIPX:
     mov  ah, 9
     mov  dx, offset message2       ;no IPX module present
     int  21h                       ;display message
     int  20h                       ;abort
CheckForIPX endp


CheckPrevious proc near
     mov  ax, 3500h + Interrupt     ;get interrupt address of interrupt
     int  21h                       ;vector returned in ES:BX
     sub  bx, 8                     ;signature is 8 bytes befor ISR
     mov  di, bx
     mov  si, offset NetString
     mov  cx, 8                     ;signature length of 8 bytes
     cli
     repz cmpsb
     jz  Previous
     ret
Previous:
     mov  ah, 9
     mov  dx, offset message3       ;already installed
     int  21h                       ;display message
     int  20h                       ;abort
CheckPrevious endp

     page
;display messages
message1 db 'NetLight loaded',CR,LF,'$'
message2 db 'ERROR - No IPX module present.  Aborting',CR,LF,'$'
message3 db 'ERROR - NetLight already installed.  Aborting',CR,LF,'$'

;signature strings
IPXString db 'IPX',0
NetString db 'NETLIGHT'

CSeg  ends
      end ENTRY
