;  File: NETINFO.ASM   System: Net Utility   Version: 1.01  Date: 04-28-90  ;
 
;-----------------------------------------------------------------------------
; NETINFO displays Netware 2.1x objects/names from bindery files on current
; server.  First argument is hex-word object type (no argument or zero for all
; types).  Optional second argument 'U' forces uppercase name display.
;
;               Example:  NETINFO 1 U | SORT > USERS.TXT
;
; Known types starting from 1 are user/group/print queue/file server/job
; server/gateway/print server/...  Must be logged in for most types.  Some
; types may be locally defined and some types do not have full names.  Long
; objects/names are truncated on display.  Utility requires 1K RAM, plus
; environment copy.
;                                                  C. Hessel/ER Support/DOE.
;-----------------------------------------------------------------------------
Code_Seg   SEGMENT
           ASSUME cs:Code_Seg,ds:Code_Seg,es:Code_Seg
 
IDCAP      =     15                    ; Display width cap for object id
NAMECAP    =     45                    ; Display width cap for full name
STDERR     =     2                     ; Handle for initial message display
WILDTYPE   =     0FFFFh                ; Netware wildcard object type
IDPROPLEN  =     16                    ; Length of trailer data for ReadReq
SCANLEN    =     11                    ; Scan object input buffer size
READLEN    =     69                    ; Read property input buffer size
REPLYLEN   =     132                   ; Reply buffer size for scan/read
NEWSTACK   =     400h                  ; Offset leaves about .5K for stack
 
PspArg1    =     $ + 5Dh               ; First file name argument in PSP
PspArg2    =     $ + 6Dh               ; Second file name argument in PSP
ReplyBuf   =     $ + 80h               ; Shared 132-byte buffer for scan/read
NextObj    =     ReplyBuf + 2          ; Scan reply object id
ObjName    =     ReplyBuf + 8          ; Scan reply object name
FullName   =     ReplyBuf + 2          ; Read reply property name
 
           ORG 100h                    ; COM file start
;-----------------------------------------------------------------------------
; Get object type, check space, display message, and initialize data.
;-----------------------------------------------------------------------------
NetInfo:   mov   si,OFFSET PspArg1     ; Hex digits (only last 4 meaningful)
           xor   dx,dx                 ; Accumulate result to DX
           mov   cl,4                  ; AL zero (assuming no drive specifier)
                                       ;   so first iteration does nothing
hexloop:   cmp   al,'9'
           jbe   isdigit               ; Digit?  Then ahead
 
           add   al,9                  ; Else convert assumed A-F to 10-15
isdigit:   and   al,0Fh                ; Isolate 0 - 15
           shl   dx,cl                 ; Shift prior result left 4 bits
           or    dl,al                 ; Include current hex digit
           lodsb                       ; Get next hex digit
           cmp   al,'0'                ; Will exit for sure at 2nd PSP drive
           jnb   hexloop               ; Done when below '0' (e.g., space)
 
           test  dx,dx                 ; Check for no argument or zero
           je    iszero                ; Yes?  Then leave default wildcard
 
           xchg  dl,dh                 ; Else do Netware hi/lo reversal and
           mov   ScanType,dx           ;   fix object type for main loop
iszero:    inc   bp                    ; Set error flag to 1 (clear later)
           cmp   sp,NEWSTACK - 2       ; Check if less than 1K at load time
           jb    Abort                 ; Yes?  Then abort
 
           mov   sp,NEWSTACK           ; Reset stack safely
           mov   bx,NEWSTACK / 16
           mov   ah,4Ah                ; Release unneeded memory--should be no
           int   21h                   ;   error by virtue of previous check
 
           mov   dx,OFFSET Message     ; Display short message
           mov   cx,OFFSET EndMsg - OFFSET Message
           mov   bl,STDERR             ; BH zero from small stack offset
           mov   ah,40h                ; Message NOT piped/redirected to allow
           int   21h                   ;   uncluttered redirection of data
 
           mov   di,OFFSET ReplyBuf    ; Set DI and reply buffer header
           mov   WORD PTR [di],REPLYLEN - 2
           mov   bl,LOW OFFSET ObjName ; Constant reference--BH is zero
           mov   BYTE PTR [bx],0       ; Null first name, in case no network,
           jmp   SHORT Entry           ;   to force exit on first loop
;-----------------------------------------------------------------------------
; Main loop processes one object id each pass.
;-----------------------------------------------------------------------------
Mainloop:  mov   si,OFFSET NextObj
           mov   di,OFFSET LastObj
           movsw                       ; Copy object id for next iteration
           movsw
 
           mov   di,bx                 ; Object name pointer
           mov   cx,100h
           repne scasb                 ; Scan for null (AL is zero)
           not   cl                    ; CL now length of object name (47 max)
           jcxz  Abort                 ; Null name on first call?  No network
 
           xor   bp,bp                 ; Flag successful read
           mov   di,OFFSET ReadType
           movsw                       ; Copy returned object type
           mov   si,bx                 ; Object name pointer
           mov   al,cl
           stosb                       ; Set length of object name
           rep   movsb                 ; Copy object name
           mov   si,OFFSET PropCon
           mov   cl,IDPROPLEN
           rep   movsb                 ; Copy property trailer data
 
           mov   cl,IDCAP + 1          ; Cap object name display
           mov   si,bx                 ; Object name pointer
           call  DispStr
 
           mov   ah,0E3h               ; Netware bindery service--function
           mov   si,OFFSET ReadReq     ;   is third byte in request buffer
           mov   di,OFFSET ReplyBuf
           int   21h                   ; Get property full name for object id
 
           mov   cl,NAMECAP + 1        ; Cap full name display
           mov   si,OFFSET FullName
           and   al,al
           je    isname                ; Full name found?  Then ahead
 
           mov   BYTE PTR [si],0       ; Else force null full name
isname:    call  DispStr
 
           mov   dl,13                 ; Display CrLf
           int   21h                   ; AH is 2
           mov   dl,10
           int   21h
 
Entry:     mov   ah,0E3h               ; Netware bindery service
           mov   si,OFFSET ScanReq     ; DI still points to reply buffer
           int   21h                   ; Get next object id
           and   al,al
           je    Mainloop              ; Not end of list yet?  Then loop
;-----------------------------------------------------------------------------
; Exit with errorlevel 1 if insufficient memory, if no network, if no objects
; of specified type found, or if, e.g., logged out and specified type requires
; logged-in status for access.
;
; Exception:  Netware shell loses track of server if logout was from local
; (not network) drive and will terminate calling process with error message.
;-----------------------------------------------------------------------------
Abort:     mov   ax,bp                 ; If BP still 1, nothing was read
           mov   ah,4Ch                ;   successfully
           int   21h
;-----------------------------------------------------------------------------
; Display null-terminated string at DS:SI, capped at CX-1 bytes.  Force upper
; case if flagged by 'U' at second PSP argument.  Space pad to CX bytes.
;-----------------------------------------------------------------------------
dsloop:    cmp   BYTE PTR PspArg2,'U'
           jne   dsok                  ; Upper case not flagged?  Ahead
 
           cmp   al,'a'
           jb    dsok                  ; Below 'a'?  Ahead
 
           cmp   al,'z'
           ja    dsok                  ; Above 'z'?  Ahead
 
           sub   al,'a'-'A'            ; Else convert to upper case
dsok:      mov   dl,al
           int   21h
DispStr:   mov   ah,2                  ; Insure AH is 2, even on null string
           lodsb
           test  al,al
           loopne dsloop
 
           inc   cx                    ; At least one space
spcloop:   mov   dl,' '
           int   21h
           loop  spcloop
 
           ret
;-----------------------------------------------------------------------------
; Data area, besides reply buffer and uppercase flag in PSP.
;-----------------------------------------------------------------------------
PropCon    DB    1                     ; Property segment number (ignore later
                                       ;   segments--truncating anyway)
           DB    IDPROPLEN - 2         ; Length of property name
           DB    "IDENTIFICATION"      ; Property name for full object name
 
ScanReq    DW    SCANLEN - 2           ; Scan request buffer length, less 2
           DB    37h                   ; Scan object function
LastObj    DD    0FFFFFFFFh            ; Previous object number, initially -1
ScanType   DW    WILDTYPE              ; Wildcard is default type (any)
           DB    1                     ; Name length
           DB    '*'                   ; Wildcard name
 
ReadReq    DW    READLEN - 2           ; Read request buffer length, less 2
           DB    3Dh                   ; Read property function
ReadType   =     $                     ; Object type, name length, name,
                                       ;   then PropCon trailer data
;-----------------------------------------------------------------------------
; Syntax message here in read request buffer is overwritten later.
;-----------------------------------------------------------------------------
           DB    "Hessel/DOE "
Message    DB    "NETINFO [hexnum [U]] lists Netware objects/names",13,10
           DB    "0=All/1=User/2=Group/3=Print queue/4=File server/...",13,10
           DB    "U=Uppercase",13,10,10
EndMsg     =     $
 
Code_Seg   ENDS
           END NetInfo
 
