
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "ipx.h"

IPXADDRESS myaddress;
IPXECB recb;
IPXHEADER rheader;
unsigned char rbuffer[80];
int i;

//------------------------------------------------------------------------------
void main ( void )
{
    if(!ipxinit())
    {
        printf("IPX not installed\n");
        exit(1);
    }
    myaddress.socket=reverseword(0x2000);
    switch(ipxopensocket(0x00,&myaddress.socket))
    {
        case 0x00: // Success
            printf("Socket %04X\n",reverseword(myaddress.socket));
            break;
        case 0xFE:
            printf("Socket Table Full\n");
            exit(1);
        case 0xFF:
            printf("Socket Already Open\n");
            exit(1);
    }

    recb.socket=myaddress.socket;
    recb.esraddress=NULL;
    recb.fragcount=2;
    recb.fragaddr1=&rheader;
    recb.fragsize1=sizeof(IPXHEADER);
    recb.fragaddr2=rbuffer;
    recb.fragsize2=sizeof(rbuffer);
    ipxlistenforpacket(&recb);

    printf("Waiting for packet\n");
    while(!kbhit())
    {
        ipxrelenquishcontrol();
        if(!recb.inuse)
        {
            printf("Packet Received\n");
            printf("  from %02X:%02X:%02X:%02X  %02X:%02X:%02X:%02X:%02X:%02X\n",rheader.source.netadd[0],rheader.source.netadd[1],rheader.source.netadd[2],rheader.source.netadd[3],rheader.source.nodeadd[0],rheader.source.nodeadd[1],rheader.source.nodeadd[2],rheader.source.nodeadd[3],rheader.source.nodeadd[4],rheader.source.nodeadd[5]);
            printf("  from socket %04X\n",reverseword(rheader.source.socket));
            break;
        }
    }
    while(kbhit()) getch();
    ipxclosesocket(myaddress.socket);
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

