/*****************************************************************************
* IPX.H
*
* 91-04-05 Matt Hagen, Novell, Inc.
*****************************************************************************/

#include <nwtypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <nwsemaph.h>
#include <nwipxspx.h>
#include <signal.h>
#include <errno.h>

typedef struct ECBHOLDStructure
{
	struct ECBHOLDStructure *fLink;
	IPX_ECB *ecb;
}ECBHOLD;

typedef struct SessionStructure
{
	struct SessionStructure *fLink;
	IPX_ECB *rxHead;
	int semaphore;
	WORD socket;
	ECBHOLD *rxList;
	ECBHOLD *txList;
}SESSION;

extern SESSION *AllocateIPXResources(
	WORD socketValue,
	BYTE semaphoreValue,
	BYTE rxCount,
	LONG rxDataSize,
	BYTE txCount,
	LONG txDataSize);

extern void DeallocateIPXResources(
	SESSION *s);

ECBHOLD *AllocatePacket(
	LONG dataSize,
	WORD socket,
	LONG semaphore,
	IPX_ECB **head);

void DeallocatePacket(
	ECBHOLD *h);

/****************************************************************************/
/****************************************************************************/
