/*****************************************************************************
* LISTEN.C
*
* 91-04-05 Matt Hagen, Novell, Inc.
*****************************************************************************/

#include "ipx.h"

#define WELL_KNOWN_SOCKET 0x2361		/* backwards */
#define RX_DATA_SIZE 50
#define TX_DATA_SIZE 50
#define STATUS_RUN 0
#define STATUS_UNLOAD 1

extern void SignalRoutine(
	void);

SESSION *s;
BYTE statusFlag=STATUS_RUN;
int exitThread=NULL;

/*****************************************************************************
* main
*****************************************************************************/

main(
	int argc,
	char *argv[])
{
	IPX_ECB *rx;
	IPX_ECB *rxList;

	signal(SIGTERM,SignalRoutine);

	s=AllocateIPXResources(WELL_KNOWN_SOCKET,NULL,8,RX_DATA_SIZE,3,TX_DATA_SIZE);
	if(s==NULL)
	{
		ConsolePrintf("  Error allocating session.\n");
		statusFlag=STATUS_UNLOAD;
		goto exit0;
	}

	while(TRUE)
	{
		WaitOnLocalSemaphore(s->semaphore);

		if(statusFlag==STATUS_UNLOAD)
			goto exit1;

		rx=IpxGetAndClearQ(&s->rxHead);
		rxList=rx->prev;
		rx->prev=NULL;

		while(rxList!=NULL)
		{
			rx=rxList;
			rxList=rx->prev;

			/* process rx */

			ConsolePrintf(" ***  ");

			IpxReceive(NULL,rx);

			if(rxList!=NULL)
				WaitOnLocalSemaphore(s->semaphore);

			ThreadSwitch();

			if(statusFlag==STATUS_UNLOAD)
				goto exit1;
		}
	}

exit1:;
	DeallocateIPXResources(s);

exit0:;
	if(exitThread!=NULL)
		ResumeThread(exitThread);
}

/*****************************************************************************
* SignalRoutine
*****************************************************************************/

void SignalRoutine(
	void)
{
	exitThread=GetThreadID();
	statusFlag=STATUS_UNLOAD;
	SignalLocalSemaphore(s->semaphore);
	SuspendThread(exitThread);
}

/****************************************************************************/
/****************************************************************************/
