/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* Program : IPRINT. Nprint version IRCI                                    */
/* Author  : Marc Chauffour                                                 */
/* Date-written : 02/13/90 02:31pm                                          */
/* Last-updated : 03/13/90 11:11am                                          */
/*                                                                          */
/* Update : 1.10  02/16/90 Copie file server si possible, modification des  */
/*                libelles job decription et path file.                     */
/*          1.11  02/16/90 Possibilite de demander copy standard /NC        */
/*          1.12  02/19/90 Iprint *.LST possible                            */
/*          1.13  02/20/90 FileServerCopy est correcte ou copie standard    */
/*          1.14  02/20/90 On beep si probleme                              */
/*          1.15  02/20/90 Remaniement avec philippe et Test version DOS    */
/*          1.16  02/20/90 Ph.A. buffer de 32Ko                             */
/*          1.17  02/21/90 C.m. Option /S plus affichage progression copy   */
/*          1.18  02/22/90 Affichage taille reellement copiee               */
/*          1.20  02/23/90 /F=forms name avec NET$PRN.DAT                   */
/*          1.21  02/23/90 Preferred, Primary et Default server si echec    */
/*          1.22  03/01/90 Ph.A. Modif libelle                              */
/*	    1.23  03/13/90 Teste la presence de NET3, La version de Novell  */
/*          1.24  03/19/90 Ph.A. Modif libelle                              */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                          */
/*                                                                          */
/* IPRINT filename /f=Form_name /c=Copies_number  /q=Queue_name             */
/*                 /t=TabSize  /NT  /NC  /S                                 */
/*                                                                          */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */


/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* Inclusion des headers                                                    */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
#define _NIT_H
#include "z:\novellc\include\nwbindry.h"
#include "z:\novellc\include\nwconn.h"
#include "z:\novellc\include\nwfile.h"
#include "z:\novellc\include\nwmisc.h"
#include "z:\novellc\include\nwwrkenv.h"
#include "z:\novellc\include\nitq.h"
#include "z:\novellc\include\niterror.h"
#include <string.h>
#include <stdlib.h>
#include <io.h>
#include <stdio.h>
#include <conio.h>
#include <dir.h>
#include <fcntl.h>
#include <dos.h>
#include <sys\stat.h>
#include "..\tc\fullypth.h"


#define CAVAMAL    -1			/* En cas de probleme               */
#define DEFAUT     -1			/* Valeur par defaut                */
#define OK          0			/* Tout est Ok                      */
#define ARGERR      1			/* Argument Error                   */
#define NOSERVER    2			/* Not attached to server           */
#define NOQUEUE     3			/* Queue not found                  */
#define NOPRINTSERV 4			/* No print server                  */
#define NEWJOBERR   5			/* Unable to create new job         */
#define NOFILE      6 			/* File not found                   */
#define COPYERR     7 			/* File copy error                  */
#define STARTERR    8 			/* Start Error                      */
#define VERSERR     9 			/* Dos version error                */
#define NOMEM	   10			/* Not enough memory to MALLOC.     */
#define NOFRMSF    11			/* No Forms FIle                    */
#define BADFRMSF   12			/* Mauvais fichier NET$PRN.DAT      */
#define ZEROFRMS   13			/* Pas de forms dans le fichier     */
#define UNKNOWNF   14			/* Forms inconnu                    */
#define NONOVELL   15			/* Pas de novell charge             */
#define VERSNOVELL 16			/* Version trop vieille             */

#define MAXLINES   66			/* Nombre maxi de lignes            */
#define MAXCHAR   132			/* Nombre maximum de caracteres     */
#define TAILLEBUF  32*1024U		/* Gros Buffer.                     */
#define LENGTHDEF  66      		/* Length papier par defaut         */
#define WIDTHDEF  132 			/* Width papier par defaut          */
#define SRCHNUM    -2			/* Recherche numerique du form      */
#define SRCHTXT     0			/* recherche par nom du form        */

/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* Acces a NET$PRN.DAT Dans PUBLIC                                          */
/* On a tout d'abord une fin de fichier a chercher 0Dh 0Ah 1Ah              */
/* BYTE  - DUP(8) constant                                                  */
/* DWORD - ???                                                              */
/* DWORD - position info Device (Zero si pas de device)                     */
/* DWORD - position indo Forms  (Zero si pas de forms)                      */
/* DWORD - Position de la prochaine place libre                             */
/* DWORD - 00 00 00 00                                                      */
/* -------------------------------------------------------------------------*/
/* Zone FORMS :                                                             */
/* BYTE  - longueur du forms name                                           */
/* BYTE  - DUP(longueur du forms name)                                      */
/* WORD  - numero de forms                                                  */
/* WORD  - width  (largeur de la page)                                      */
/* WORD  - length (nombre de lignes)                                        */
/* BYTE  - DUP(longueur du forms name)                                      */
/* DWORD - position du debut de zone FORMS                                  */
/* DWORD - 00 00 00 00                                                      */
/* BYTE  - 00                                                               */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */

/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* Variables globales                                                       */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int nbarg;				/* Nombre d'argument                */
char qdefault[48]="Q_TEXT";		/* Nom de la queue par defaut       */
char ficcfg[80]="/SYS:PUBLIC\\NET$PRN.DAT";
int formsdef=0;				/* forms si rien de specifie        */
char *qname=NULL;			/* Nom de la queue concernee        */
int copy=DEFAUT;			/* Nombre de copie                  */

int forms=DEFAUT;			/* Forms pas initialise             */
char formsname[12]="";			/* Nom de forms par defaut          */
int formslength=DEFAUT;	 		/* Length papier                    */
int formswidth=DEFAUT;			/* width papier                     */

int stream=DEFAUT;			/* par defaut text Tabs=O           */
int sizetab=DEFAUT;			/* Tab Size                         */
int copymsg=DEFAUT;			/* Message pendant la phase de copy */
char fullypath[255];			/* Buffer du nom fichier            */
int flagcopy=DEFAUT;			/* copy reseau inhibe               */
char *buffer;				/* Pointeur au buffer de copie.	    */

/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* Declarations des fonctions                                               */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int testarg(char **);			/* Teste la liste des arguments     */
int test(char *);			/* Teste un argument                */
int copyfile(int, char *);		/* Copy d'un fichier sur l'autre    */
int traitfile(char *);			/* Traitement d'un fichier          */
int srchfrms( void );			/* on cherche le numero de forms    */
int main(int, char**);			/* Fonction principale              */
int testnovell( void);			/* regarde si novell present        */


/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* testarg : Verifie si les arguments sont correct			    */
/* Sortie : (int)  CAVAMAL - Mauvais argument				    */
/*			 0 - Pas de probleme				    */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int testarg(
    char **listarg)			/* Liste des arguments		    */
{
int i;					/* Compteur de boucle for	    */
int nbargu;				/* Nombre d'argument		    */
  nbargu = nbarg;			/* Egal au nombre d'argument passe  */
  switch(nbarg) {			/* en fonction du nombre d'argument */
    case 2 :
      if (strncmp("/",listarg[1],1) != 0) /* Si on a un nom de fichier Ok   */
	return(OK);			/* On peut sortir sans probleme     */
      else
	return(CAVAMAL);		/* On peut sortir sans probleme     */
    default :
      if (strncmp("/",listarg[1],1) != 0) /* Si on a un nom de fichier Ok   */
	{
	for (i = 2; i<nbargu; i++)
	  if(test(listarg[i]) == CAVAMAL)  /* On teste le premier argument  */
	    return(CAVAMAL);		/* On sort avec erreur		    */
	return(OK);			/* On sort avec result de TEST	    */
	}
      else
        return(CAVAMAL);         	/* Pas bon			    */
   }
}


/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* Fonction test							    */
/* Rend CAVAMAL si probleme et Zero autrement				    */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int test(char *arg)
{
 if (strncmp("/",arg,1) != 0)		/* Si on a un nom de fichier Ok     */
   return(CAVAMAL);			/* Pas de nom de fichier	    */
 if (strnicmp("/Q=",arg,3) == 0)	/* Si on demande une Queue specifiq */
   if (qname != NULL)			/* Si on est deja passe 	    */
     return(CAVAMAL);			/* On sort avec un probleme	    */
   else
     if(strlen(&arg[3]) > 0)		/* Si on a quelque chose derriere   */
       {
       qname=&arg[3];			/* on lui met l'adresse qu'il faut  */
       --nbarg; 			/* Un argument en moins 	    */
       return(OK);			/* Ok pas de probleme, on a le droit*/
       }
     else
       return(CAVAMAL); 		/* On ne peut pas		    */

if (stricmp("/NT",arg) == 0)		/* Si on demande un mode stream     */
  if (stream!=DEFAUT)			/* Si on est deja passe 	    */
    return(CAVAMAL);			/* On sort avec un probleme	    */
  else
    {
    stream=0;				/* on lui met le stream		    */
    --nbarg; 	 			/* Un argument en moins 	    */
    return(OK);	      			/* Ok pas de probleme, on a le droit*/
    }

if (stricmp("/S",arg) == 0)		/* Si on demande pas d'affic. copy  */
  if (copymsg!=DEFAUT)			/* Si on est deja passe 	    */
    return(CAVAMAL);			/* On sort avec un probleme	    */
  else
    {
    copymsg=0;				/* on lui met le non affichage      */
    --nbarg; 	 			/* Un argument en moins 	    */
    return(OK);	      			/* Ok pas de probleme, on a le droit*/
    }

if (stricmp("/NC",arg) == 0)		/* Si on demande pas NET COPY       */
  if (flagcopy!=DEFAUT)    		/* Si on est deja passe 	    */
    return(CAVAMAL);			/* On sort avec un probleme	    */
  else
    {
    flagcopy=1;				/* on lui met le copy standard      */
    --nbarg; 	 			/* Un argument en moins 	    */
    return(OK);				/* Ok pas de probleme, on a le droit*/
    }


 if (strnicmp("/C=",arg,3) == 0)	/* Si on demande nombre de copies   */
   if (copy != DEFAUT)	       		/* Si on est deja passe 	    */
     return(CAVAMAL);			/* On sort avec un probleme	    */
   else
     if(strlen(&arg[3]) > 0)		/* Si on a quelque chose derriere   */
       {
       copy=atoi(&arg[3]);		/* On prend notre nombre de copies  */
       if (copy == 0)        		/* si n'importe quoi                */
	 return(CAVAMAL);		/* on le dit !                      */
       else
	 {
         --nbarg;   			/* Un argument en moins 	    */
	 return(OK);			/* C'est Ok                         */
	 }
       }
     else
       return(CAVAMAL); 		/* On ne peut pas		    */


 if (strnicmp("/T=",arg,3) == 0)	/* Si on demande tab size           */
   if (sizetab != DEFAUT)	       	/* Si on est deja passe 	    */
     return(CAVAMAL);			/* On sort avec un probleme	    */
   else
     if(strlen(&arg[3]) > 0)		/* Si on a quelque chose derriere   */
       {
       sizetab=atoi(&arg[3]);		/* On prend notre nombre de copies  */
       if (sizetab < 0 || sizetab >18 )	/* si n'importe quoi                */
	 return(CAVAMAL);		/* on le dit !                      */
       else
	 {
         --nbarg;   			/* Un argument en moins 	    */
	 return(OK);			/* C'est Ok                         */
	 }
       }
     else
       return(CAVAMAL); 		/* On ne peut pas		    */


 if (strnicmp("/F=",arg,3) == 0)	/* Si on demande forms              */
   if (forms != DEFAUT)       		/* Si on est deja passe 	    */
     return(CAVAMAL);			/* On sort avec un probleme	    */
   else
     if(strlen(&arg[3]) > 0)		/* Si on a quelque chose derriere   */
       if(arg[3]<'0' || arg[3]>'9')	/* Si c'est de l'alphanumerique     */
	 {
         strcpy(formsname,&arg[3]);	/* On prend notre forms             */
         --nbarg;   			/* Un argument en moins 	    */
         forms=SRCHTXT;			/* on peut signaler que FORMS name  */
         return(OK);			/* C'est Ok                         */
         }
       else
	 {
         formsdef=atoi(&arg[3]);	/* On prend notre forms             */
         forms=SRCHNUM;			/* on peut signaler que FORMS num   */
         --nbarg;   			/* Un argument en moins 	    */
         return(OK);			/* C'est Ok                         */
	 }
     else
       return(CAVAMAL); 		/* On ne peut pas		    */
 return(CAVAMAL);
}

/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* copyfile( fichier a editer )                                             */
/* en sortie : Ok si tout va bien                                           */
/*             autrement code erreur                                        */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int copyfile
    (
    int hdleout, 			/* Dos handle fichier OUT           */
    char *nomfichier)			/* Nom du fichier en entree         */
{
int hdlein;				/* Handle fichier In                */
unsigned long longfic;			/* Longeur du fichier IN            */
unsigned long longcopied;		/* longueur deja effectue           */
unsigned long posit=0;			/* Position dans le fichier IN      */
int result; 				/* Resultat des fonctions           */
unsigned long taille=0;			/* Taille en Ko                     */

  hdlein=open(nomfichier,
	      O_RDONLY|O_DENYNONE|O_BINARY,
	      S_IFREG); 		/* Ouvre IN en SHARE/READ ONLY	    */
  if (hdlein==CAVAMAL)			/* Si le fichier n'existe pas       */
    return(CAVAMAL);			/* on le signale                    */
  longfic=filelength(hdlein);		/* On prend sa taille               */
  if (fullypath[1]==':' || flagcopy==1)	/* Drive local                      */
    result=1;				/* On force la copie maison         */
  else
    {
    longcopied=0;			/* On initialise la longueur copiee */
    printf("Server copy of %lu bytes.",longfic);
    gotoxy(1,wherey());			/* Debut de ligne                   */
    result=FileServerFileCopy(hdlein,hdleout,
		     0,0,longfic,       /* si la copie server ne marche pas */
		     (long *)&longcopied); /* on va essayer autre chose     */
    }
  printf("                                                 ");
  gotoxy(1,wherey());	       		/* Debut de ligne                   */
  if (result!=OK || longcopied!=longfic)/* En cas de probleme               */
    while(posit<longfic)		/* Tant qu'on doit copier           */
      {
      result=read(hdlein,buffer,(unsigned) TAILLEBUF);/* Lecture fichier IN */
      if (result==CAVAMAL)		/* En cas de probleme               */
	{
	close(hdlein);			/* On ferme le fichier              */
	return(CAVAMAL);		/* On le signale dehors             */
	}
      if (write(hdleout,buffer,result)!=result)
	{				/* Disk full.			    */
	close(hdleout);
	close(hdlein);			/* on termine                       */
	return(CAVAMAL);		/* On sort avec probleme            */
	}
      posit+=(unsigned int) result;	/* On signale ou on est             */
      taille+=(unsigned) result;	/* Quelques bytes de plus           */
      gotoxy(1,wherey());		/* Debut de ligne                   */
      if (copymsg==DEFAUT) printf("Spooling %lu Kb",taille/1024);
      }
   gotoxy(1,wherey());			/* Debut de ligne                   */
   printf("                                                 ");
   gotoxy(1,wherey());			/* Debut de ligne                   */
   close(hdlein);			/* On ferme notre fichier IN        */
   return(OK);				/* C'est ok                         */
}




/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* traitfile( fichier a editer )                                            */
/* en sortie : Ok si tout va bien                                           */
/*             autrement code erreur                                        */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int traitfile
    (
    char *nomfichier			/* Nom du fichier a editer          */
    )
{
long queueid;				/* ID de la queue demandee          */
JobStruct job;				/* Structure de type Job            */
WORD connect;				/* Connection number                */
int result;				/* Resultat fonction                */
char user[48];				/* Utilisateur                      */
WORD usertype;				/* Type du user                     */
long userid;				/* Object ID                        */
BYTE logintime[7];			/* Login Time                       */
char drive[MAXDRIVE];			/* Unite du disque		    */
char dir[MAXDIR];			/* Repertoire			    */
char filename[MAXFILE]; 		/* nom du fichier		    */
char ext[MAXEXT];			/* Extension			    */
struct ClientRecordArea *pcra;		/* Pointeur a la strcuture          */
int drivenb;				/* Numero de drive		    */
char *pdrivenb; 			/* pointeur au char drive	    */
int filehandle;				/* FIle handle file job             */
struct ftime ftimep;			/* structure informations date:time */
long lgfile;				/* Longueur du fichier              */
  memset(&job,0,sizeof(job));		/* Initialise a zero                */
  filehandle=open(nomfichier,
	      O_RDONLY|O_DENYNONE|O_BINARY,
	      S_IFREG); 		/* Ouvre IN en SHARE/READ ONLY	    */
  if(filehandle==CAVAMAL)		/* Si il n'existe pas               */
    {
    printf("File not found : %s\n\7",nomfichier);
    return(NOFILE);
    }
  else
    {
    lgfile=filelength(filehandle);	/* Longueur du fichier              */
    getftime(filehandle,&ftimep);	/* Date de modification fichier     */
    close(filehandle);			/* fichier plus ouvert              */
    }
  if (lgfile==0)			/* ca ne sert a rien                */
    {
    printf("File %s is empty.\n\7",nomfichier);
    return(OK);				/* erreur non critique              */
    }
  if (GetBinderyObjectID(qname, OT_PRINT_QUEUE, &queueid))
    {
    printf("Unable to locate print queue %s\n\7", strupr(qname));
    return(NOQUEUE);
    }
  connect=GetConnectionNumber();	/* Recupere Connection Number       */
  result=GetConnectionInformation(
  			connect,	/* par rapport a CONNECT            */
			user,		/* Object name                      */
			&usertype,	/* Type du user                     */
			&userid,	/* User ID                          */
			logintime);	/* Login time                       */
  printf("Submitting %s to %s (user %s).\n",nomfichier,
                                        strupr(qname),
					user);
  job.targetServerIDNumber=DEFAUT;	/* ID du serveur QUEUE              */
  strcpy(job.targetExecutionTime,"\xFF\xFF\xFF\xFF\xFF\xFF");
  job.jobType=forms;			/* Numero du forms                  */
  fnsplit(nomfichier,drive,dir,filename,ext);

  /* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
  /* Remplissage de la client record Area                                   */
  /* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
pcra = (struct ClientRecordArea *) job.clientRecordArea;
pcra->version=0;			/* Comme les autres soft            */
pcra->tabsize=sizetab;			/* Position des tabs                */
pcra->copies=IntSwap(copy);		/* Nombre d'exemplaires             */
pcra->cflags=(WORD) (0x80 + 0x40);	/* Banner printed                   */
if (stream!=DEFAUT)			/* Si on a demande le stream        */
  pcra->cflags=(WORD) (0x80);		/* Banner sans text stream          */
pcra->cflags=IntSwap(pcra->cflags);	/* ordre inverse                    */
pcra->maxlines= IntSwap(formslength);	/* Lignes au maximum                */
pcra->maxchar= IntSwap(formswidth); 	/* Characteres au maximum           */
strcpy(pcra->formname,formsname);	/* Pas de forms                     */
strncpy(pcra->b_name,user,12);		/* Nom utilisateur                  */
pcra->b_name[13]='\0';			/* On force la fin au cas ou        */
strcpy(pcra->b_filename,filename);	/* Filename sans extension          */
strcat(pcra->b_filename,ext);		/* Voila l'extension                */
strcpy(pcra->h_filename,pcra->b_filename);
sprintf(job.textJobDescription,
          "%s (%lu bytes, %02u-%02u-%04u %02u:%02u)",
			       pcra->b_filename,
                               lgfile,
			       ftimep.ft_month,
			       ftimep.ft_day,
			       ftimep.ft_year+1980,
			       ftimep.ft_hour,
			       ftimep.ft_min);
if (drive[0] == '\0')			/* pas de drive ?		    */
  {
  drivenb = getdisk();			/* drive courant		    */
  pdrivenb = (unsigned char *)&drivenb; /* adresse drive		    */
  drive[0] = (*pdrivenb) + 'A';		/* lettre drive 		    */
  drive[1] = ':'; 			/* + ':'			    */
  drive[2] = '\0';			/* + zero binaire		    */
  }
else
  {
  pdrivenb = drive;			/* lettre drive 		    */
  drivenb = (int)(pdrivenb[0] - 'A'); 	/* numero drive			    */
  }
strcpy(fullypath,drive);		/* Drive en cours                   */
strcat(fullypath,dir);			/* On a le path du fichier          */
strcat(fullypath,pcra->h_filename);	/* On a le nom complet              */
getnovellpath(fullypath,fullypath);	/* On regarde ce que ca donne       */
strncpy(pcra->path,fullypath,80);
result=CreateQueueJobAndFile(queueid,	/* ID de la queue                   */
    			&job,		/* Pointeur a la structure JOB      */
			&filehandle);	/* DOS file handle pour JobFIle     */
if (result!=OK)				/* Si on a eu des problemes         */
  {
  printf("CreateQueueJobAndFile failed, error %u. Aborted.\n\7",result);
  return(NEWJOBERR);			/* Error level                      */
  }
if(copyfile(filehandle,nomfichier)==CAVAMAL) /* copie des fichiers          */
  {
  printf("Error spooling data to %s \n\7",job.jobFileName);
  CloseFileAndAbortQueueJob(queueid,job.jobNumber,filehandle);
  return(COPYERR);			/* Error level                      */
  }
if (CloseFileAndStartQueueJob(queueid,job.jobNumber,filehandle)==OK)
  return(OK);				/* Pas de probleme                  */
else
  {
  CloseFileAndAbortQueueJob(queueid,job.jobNumber,filehandle);
  printf("CloseFileAndStartQueueJob failed. Aborted.\n\7");
  return(STARTERR);			/* Erreur lors de START             */
  }
}




/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* srchfrms : recherche le forms formname dans NET$PRN.DAT                  */
/* le nom du fichier est contenu dans ficcfg[]                              */
/* il faut trouver le nom du preferred server pour lui packer, ou celui     */
/* du Primary server (login), ou le Default server                          */
/* sortie : OK si tout va bien, CAVAMAL autrement                           */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int srchfrms( void )
{
int fic_in;				/* File handle                      */
int result;				/* resultat des fonctions appelees  */
long longfic;				/* longueur du fichier              */
long i;					/* indice de boucle                 */
int j;					/* idem                             */
char nomforms[12];			/* nom du forms                     */
char numforms;				/* Numero de forms                  */
int sizel;				/* Length de la page                */
int sizew;				/* width de la page                 */
int nbcol=4;				/* Nombre de colonne de forms       */

char *deplace;				/* pointeur a une chaine de caract. */
int nbforms;				/* Nombre de forms                  */
long *positf;				/* positionnement des forms         */
WORD serverpref;   			/* Preferred server                 */
char pluriel='s';			/* singulier ou pluriel ?           */

/* on va constituer le nom du fichier NET$PRN.DAT a l'aide du preferred serv*/
  serverpref=GetPreferredConnectionID();
  if (serverpref==0)			/* pas de Set preferred de fait     */
    {
    serverpref=GetPrimaryConnectionID();
    if (serverpref==0)			/* pas de Set preferred de fait     */
      serverpref=GetDefaultConnectionID();
    }
  GetFileServerName(serverpref,		/* connection ID du serveur princip.*/
		     fullypath);	/* Nom du serveur                   */
  strcat(fullypath,ficcfg);		/* On lui ajoute le nom du fichier  */
  fic_in=open(fullypath,
	      O_RDONLY|O_DENYNONE|O_BINARY,
	      S_IFREG); 		/* Ouvre IN en SHARE/READ ONLY	    */
  if(fic_in==CAVAMAL)			/* En cas de probleme               */
    {
    printf("%s not found.\7\n",fullypath);
    return(NOFRMSF);			/* No forms FIle                    */
    }
  longfic=filelength(fic_in);		/* longueur du fichier              */
  buffer=malloc((size_t) longfic); 	/* Alloue le buffer de lecture	    */
  if (buffer==NULL)
    {
    printf("Not enough heap memory...\n\7");
    close(fic_in);			/* on libere le fichier             */
    return(NOMEM);			/* Pas assez de memoire             */
    }
  result = read(fic_in,buffer,(int) longfic); /* On charge tout le fichier  */
  if (result!=longfic)			/* si on a pas le compte ...        */
    {
    printf("Bad %s !\7\n",fullypath);
    close(fic_in);			/* on ferme le fichier              */
    free(buffer);			/* on libere la memoire             */
    return(BADFRMSF);			/* On a un probleme                 */
    }
  deplace=buffer;			/* adresse du buffer alloue         */
  for(i=0;*deplace!='\x1A' && i<longfic;i++,deplace++); /* on recherche 1A  */
  if(i==longfic)			/* On est deja a la fin             */
    {
    printf("Bad %s !\7\n",fullypath);
    close(fic_in);			/* on le ferme                      */
    free(buffer);			/* on libere la memoire             */
    return(BADFRMSF);			/* on sort                          */
    }
  deplace+=17;				/* deplacement pour arriver au point*/
					/* info forms.                      */
  positf=(long *) deplace;           	/* on prend position en adr. long   */

					/* si on a pas de FORMS             */
  if (deplace==NULL || (char) buffer[(int) *positf]=='\0')
    {
    printf("No form defined in %s.\7\n",fullypath);
    close(fic_in);			/* on le ferme                      */
    free(buffer);			/* on libere la memoire             */
    return(ZEROFRMS);			/* on sort                          */
    }
  nbforms=(char) buffer[(int) *positf];	/* Nombre de forms                  */
  positf=(long *) &buffer[(int) *positf+2]; /* on prend positionnement +int */

  for(i=0;i<nbforms;i++)		/* on va regarder tous les forms    */
    {
    for(j=0;j<(int) buffer[(int)*positf]; j++) /* sur la longueur du forms  */
      nomforms[j]=buffer[(int)*positf+j+1];    /* recopie char par char     */
    nomforms[j++]='\0';			/* fin de chaine                    */

    numforms=(int) buffer[(int) *positf+j]; /* numero de forms              */
    j+=2;				/* un integer                       */
    sizew=(int) buffer[(int)*positf+j];	/* Width                            */
    j+=2;				/* un integer                       */
    sizel=(int) buffer[(int)*positf+j];	/* Length                           */
    if (numforms==formsdef && forms==DEFAUT)/* cas specifique du form '0'   */
      {
      forms=formsdef;			/* Numero de forms                  */
      formslength=sizel;		/* on sauve notre length par defaut */
      formswidth=sizew;	       		/* on sauve notre width par defaut  */
      strcpy(formsname,nomforms);	/* on sauve notre Nom par defaut    */
      printf("No form specified. Defaulting to form %u (%s)\n",
      			forms,formsname);
      close(fic_in);			/* On ferme le fichier              */
      free(buffer);			/* On libere notre buffer           */
      return(OK);			/* Pas de probleme                  */
      }
    if (numforms==formsdef && forms==SRCHNUM) /*cas specifique de form num  */
      {
      forms=formsdef;			/* Numero de forms                  */
      formslength=sizel;		/* on sauve notre length par defaut */
      formswidth=sizew;	       		/* on sauve notre width par defaut  */
      strcpy(formsname,nomforms);	/* on sauve notre Nom par defaut    */
      printf("Using form %u (%s)\n",forms,formsname);
      close(fic_in);			/* On ferme le fichier              */
      free(buffer);			/* On libere notre buffer           */
      return(OK);			/* Pas de probleme                  */
      }
					/* Si ils sont identiques           */
    if(strcmp(nomforms,formsname)==0 && forms==SRCHTXT)
      {
      forms=numforms;			/* Ok pour ce forms                 */
      formslength=sizel;		/* Length papier                    */
      formswidth=sizew;			/* Width papier                     */
      printf("Using form %u (%s)\n",forms,formsname);
      close(fic_in);			/* On ferme le fichier              */
      free(buffer);			/* On libere notre buffer           */
      return(OK);			/* Pas de probleme                  */
      }
    positf++;				/* On passe au suivant              */
    }
  if (forms==DEFAUT)			/* On a pas specifie de form        */
    {
    forms=formsdef;			/* Ok pour ce form                  */
    formslength=LENGTHDEF;     		/* Length papier                    */
    formswidth=WIDTHDEF; 		/* Width papier                     */
    printf("Using form %u\n",forms);
    close(fic_in);			/* On ferme le fichier              */
    free(buffer);			/* On libere notre buffer           */
    return(OK);				/* Pas de probleme                  */
    }
  else
    {
    printf("Unknown form.\7");		/* le form est inconnu ! -) LISTE   */
    printf(" Available forms are :\n\n");
    positf=(long *) deplace;           	/* on prend positionnement          */
    positf=(long *) &buffer[(int)*positf+2]; /* on prend position + int     */
    for(i=0;i<nbforms;i++)		/* on va lister   tout les forms    */
      {
      for(j=0;j<(int) buffer[(int)*positf]; j++) /* recopie du forms        */
        nomforms[j]=buffer[(int)*positf+j+1];/* charactere par charactere   */
      numforms=(int) buffer[(int)*positf+j+1];/* numero de forms            */
      for(;j<12;j++)
	nomforms[j]=' ';		/* On padde avec des blancs         */
      nomforms[j++]='\0';		/* fin de chaine                    */

      if (nbcol==4)			/* si on a deja une ligne pleine    */
	{
	nbcol=0;			/* on recommence a zero
	printf("\n");		/* on saute une ligne               */
	}
      printf("  %5u %s",numforms,nomforms);
      nbcol++;				/* Une colonne en plus              */
      positf++;				/* On passe au suivant              */
      }
    if (forms==1) pluriel=32;
    printf("\n\n  %5u form%c\n",nbforms,pluriel);
    close(fic_in);			/* On libere le fichier             */
    free(buffer);			/* On libere la memoire             */
    return(UNKNOWNF);			/* pas de forms comme indique       */
    }
}


/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* Procedure principale                                                     */
/*                                                                          */
/* ErrorLevel en sortie : 0 - Tout va bien                                  */
/*            ARGERR      1 - erreur d'argument                             */
/*            NOSERVER    2 - Pas attache au serveur                        */
/*            NOQUEUE     3 - Pas de queue                                  */
/*            NOPRINTSERV 4 - Pas de print server                           */
/*            NEWJOBERR   5 - Erreur de creation de job                     */
/*            NOFILE      6 - Pas de fichier                                */
/*            COPYERR     7 - Erreur lors de la copie                       */
/*            STARTERR    8 - Erreur lors de la validation du JOB           */
/*            VERSERR     9 - Version DOS trop vieille                      */
/*	      NOMEM	 10 - Pas assez de memoire (erreur MALLOC).         */
/*	      NOFRMSF    11 - pas de fichier NET$PRN.DAT                    */
/*	      BADFRMSF   12 - Mauvais fichier NET$PRN.DAT                   */
/*	      ZEROFRMS   13 - Pas de form dans NET$PRN.DAT                  */
/*	      UNKNOWNF   14 - Form inconnu                                  */
/*	      NONOVELL   15 - Pas de novell charge			    */
/*	      VERSNOVELL 16 - Netware trop vieux.			    */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int main
     (
     int argc, 				/* Nombre d'arguments               */
     char **arg				/* Pointeur aux arguments           */
     )
{
int retour;				/* Resultat des Fonctions           */
char *mask="*.LST";			/* Par defaut si pas de fichier     */
char path[MAXPATH];			/* nom du fichier a traiter         */
char drive[MAXDRIVE];			/* Unite                            */
char dir[MAXDIR];			/* Repertoire                       */
char filename[MAXFILE]; 		/* nom du fichier		    */
char ext[MAXEXT];			/* Extension			    */
struct ffblk c_file;
char work[1];				/* Chaine de travail                */
BYTE majorvers;				/* Novell major version             */
BYTE minorvers;				/* Novell minor version             */
BYTE revisionl;				/* revision level                   */
    nbarg = argc;			/* Nombre d'argument		    */
    retour = testarg(arg);		/* On teste nos arguments	    */

    printf("IPRINT - Net Print file   V 1.24  %s  C.m. I.R.C.I. \n\n",__DATE__);
    work[0]=_osmajor;
    work[1]=_osminor;
    if (work[0] < '\3')
      {
      printf("IPRINT requires a DOS 3.00 or later...(current is %u.%u)\n\7",
      		(int) work[0],
		(int) work[1]);
      return(VERSERR);
      }
    if(testnovell()!=OK || GetNetWareShellVersion(&majorvers,
    						      &minorvers,
						      &revisionl)==0)
      {
      printf("NET shell not loaded.\n\7");
      return(NONOVELL);
      }
    if (majorvers<2 || (majorvers>1 && minorvers<10))
      {
      printf("IPRINT requires NW 2.10 or later...(This one is %u.%u.%c)\n\7",
      		(int) majorvers,
		(int) minorvers,
		(char) revisionl+'A');
      return(VERSNOVELL);
      }
    if (nbarg==2)			/* Si iprint /f=0 /...              */
      mask=arg[1];			/* Parametre passe au programme     */
    if (nbarg != 2 || retour == CAVAMAL) /* Si on a pas trop d'argument     */
      {
      puts("Usage       : IPRINT file_spec [options..]");
      puts("              File_spec may be generic.");
      puts(" ");
      puts("Options are :            Default");
      puts(" ");
      printf("      File extension      [.LST]\n");
      printf("      /F=Form name/number [%u]\n",formsdef);
      printf("      /Q=Queue name       [%s]\n",qdefault);
      puts("      /C=number of Copies [1]");
      puts("      /T=Tab size         [8]");
      puts("      /NT No tabs");
      puts("      /NC Inhibit internal server copy");
      puts("      /S  Silent mode. Suppress copy progression display");
      puts(" ");
      retour=ARGERR; 		        /* Arg error			  */
      }
    else
      {
      retour=srchfrms();		/* Met les forms par defaut         */
      if (retour!=OK) return(retour);	/* On rend l'errorlevel             */
      if(qname==NULL)			/* Si on a pas specifie de Queue    */
	qname=qdefault;			/* On lui met la QUEUE par defaut   */
      if(copy==DEFAUT)			/* Nombre d'exemplaires             */
	copy=1;				/* defaut 1 exemplaire              */
      if(forms==DEFAUT)			/* Forms par defaut                 */
	forms=0;			/* Defaut par forms                 */
      if(sizetab==DEFAUT)		/* Tab size par defaut              */
	sizetab=8;			/* Defaut pour tab size             */
      fnsplit(mask,drive,dir,filename,ext); /* Decoupage du nom du fichier  */
      if (ext[0]=='\0')
	strcpy(ext,".LST");		/* Normal, ensuite on mettra *.LST  */
      if (filename[0]=='\0')		/* Si on a rien mis                 */
	strcpy(filename,"*");		/* Caractere generique              */
      fnmerge(path,drive,dir,filename,ext);
      if (findfirst(path,&c_file,0)!=CAVAMAL)
	{
	buffer=malloc((size_t) TAILLEBUF);/* Alloue le buffer de copie.	    */
	if (buffer==NULL)
	  {
	  printf("Not enough heap memory...\n\7");
	  return(NOMEM);
	  }
	do
	  {
	  fnsplit(c_file.ff_name,work,work,filename,ext);
	  fnmerge(path,drive,dir,filename,ext);
	  retour=traitfile(strupr(path)); /* On traite le fichier path        */
	  }
	while (findnext(&c_file)!=CAVAMAL && retour==0);
	free(buffer);
	}
      else
	{
	printf("File %s not found.\n\7",strupr(path));
	retour=NOFILE;			/* Error level                      */
	}
      }
    return(retour);			/* On sort avec errorlevel	    */
}

