/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:AFPMD.C   
**
**   Desc: Creates a Machintosh directory on a server volume under the dos
**         environment.   
**
**        
**   Programmers:
**   Ini   Who         Firm
**   ------------------------------------------------------------------
**   KB    Karl Bunnell       Novell Developer Support.
**   ARM   A. Ray Maxwell     Novell Developer Support.
**
**   History:
**       
**   ------------------------------------------------------------------
**   02-14-94   ARM   Added the header, comments and disclaimer.
*/

/***************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

   /*------------------------------------------------------------------
   **   ANSI
   */
   #include <stdlib.h>          /* exit(), atol()        */
   #include <stdio.h>           /* sprintf()             */
   #include <string.h>

   /*------------------------------------------------------------------
   **   NetWare
   */
   #include <nwcalls.h>      



/****************************************************************************
**   Program Start
*/

void main(int argc, char *argv[])
{
	NWAFP_FILE_INFO	fileInfo;
	NWAFP_ENTRY_ID		entryID1, entryID2;
	NWFINDER_INFO		finderInfo = 0;
	NWDIR_HANDLE	 	dirHandle;
	NWCONN_HANDLE		conn;
	NWVOL_NUM			volNumber;
	NWCCODE				ccode;
	char					afpPathString[32];
	char					path[256] = "";
	char					volName[16];
	char					serverName[48];
	int					i;


	if(argc < 3)
		{
		printf("Usage: AFPMD <server\path> <directory name> \n");
		printf("       server\path= servername\sys:\n");
      printf("       directory name= Whatever you want the name to be\n");

		exit(1);
		}

	strcpy(afpPathString + 1, argv[2]);
	for (i = 3; i < argc; i++)
		{
		strcat(afpPathString + 1, " ");
		strcat(afpPathString + 1, argv[i]);
		}

	afpPathString[0] = strlen(afpPathString + 1);

	ccode = NWCallsInit(NULL, NULL);
	if (ccode)
		{
		printf("\nNWCallsInit returned %04X\n", ccode);
		exit(1);
		}


	strupr(argv[1]);
	ccode = NWParseNetWarePath(
           /* > path to parse                        */ argv[1],
           /* < server connection Handle             */ &conn,
           /* < directory Handle                     */ &dirHandle,
           /* <new path relative to directory Handle */ path);

	if (ccode)
		{
		printf("\nNWParseNetWarePath returned %04X\n", ccode);
		exit(1);
		}

	ccode = NWParsePath(
			  /* > Path to parse                */ path,
			  /* < server name (optional)       */ serverName,
			  /* < connection handle (optional) */ NULL,
			  /* < volume name (optional)       */ volName,
			  /* < directory path (optional)    */ NULL);

	if (ccode)
		{
		printf("\nNWParsePath returned %04X\n", ccode);
		exit(1);
		}

	printf("\nVolume name = %s\n", volName);

	ccode = NWGetVolumeNumber(
			  /* > connection Handle    */ conn,
			  /* > volume name          */ volName,
			  /* < volume Number        */ &volNumber);

	printf("\nVolume number = %d\n", volNumber);


	printf("\nFile Server name associated with this handle %s\n", serverName);

	ccode = NWAFPGetEntryIDFromPathName(
           /* > connection handle  */ conn,
           /* > directory handle   */ dirHandle,
           /* > path               */ path, 
           /* < AFP base ID        */ &entryID1);

	if (ccode)
		{
		printf("\nNWAFPGetEntryIDFromPathName returned %04X\n", ccode);
		exit(1);
		}


	ccode = NWAFPCreateDirectory(
           /* > connection Handle                */ conn,
           /* > volume number                    */ volNumber,
           /* > AFP base ID                      */ entryID1,
           /* > pointer to finder info           */ &finderInfo,
			  /* > AFP dir path relative to entryID */ afpPathString,
           /* < ID of newly created directory    */ &entryID2);

	printf("\nDirectory name is : %s\t Length = %d\n", 
           (afpPathString + 1), afpPathString[0]);

	if (ccode)
		{
		printf("Unable to create \"%s\".\n CCODE = %04X", 
              (afpPathString + 1), ccode);
		exit(1);
		}

	printf("Directory \"%s\" created successfully. \n", afpPathString + 1);

}
