unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, DBCtrls, Grids, DBGrids, DB, DBTables,
  Report, Tabs, ExtCtrls, VBXCtrl;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    WipEdit: TEdit;
    NameEdit: TEdit;
    Label1: TLabel;
    Name: TLabel;
    FdateEdit: TEdit;
    Label2: TLabel;
    CntyEdit: TEdit;
    Label3: TLabel;
    LdateEdit: TEdit;
    Label4: TLabel;
    Query1: TQuery;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Label5: TLabel;
    CheckBox4: TCheckBox;
    CSAEdit: TEdit;
    Panel2: TPanel;
    RbEnt: TRadioButton;
    RbEff: TRadioButton;
    Panel3: TPanel;
    Image1: TImage;
    Panel4: TPanel;
    SpeedButton2: TSpeedButton;
    TabSet1: TTabSet;
    BitBtn1: TBitBtn;
    Report1: TReport;
    procedure FormActivate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    Procedure RbEntDblClick(Sender: TObject);
    procedure RbEffDblClick(Sender: TObject);
    procedure RbEffClick(Sender: TObject);
    procedure RbEntClick(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure TabSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure BitBtn1Click(Sender: TObject);
    procedure WipEditEnter(Sender: TObject);
    procedure NameEditEnter(Sender: TObject);
    procedure LdateEditEnter(Sender: TObject);
    procedure CSAEditEnter(Sender: TObject);
    procedure CntyEditEnter(Sender: TObject);
   
{    procedure FormClose(Sender: TObject; var Action: TCloseAction);}

  private
    { Private declarations }
  public

  end;

var
  Form1: TForm1;
  QActive:       Boolean;
  CurQuery:      String;
  ActiveQuery: Array[0..1] of  String;

 implementation

{$R *.DFM}


procedure TForm1.FormActivate(Sender: TObject);
begin
    QActive := False;
    WIPEdit.Color  := ClGray;
    CntyEdit.Color := ClGray;
    NameEdit.Color := ClGray;
    FdateEdit.Color:= ClGray;
    LdateEdit.Color:= ClGray;
    WIPEdit.Enabled  := false;
    CntyEdit.Enabled := false;
    NameEdit.Enabled := False;
    FdateEdit.Enabled:= false;
    LdateEdit.Enabled:= false;
    DBGrid1.SetFocus;
end;



procedure TForm1.CheckBox1Click(Sender: TObject);
begin
    If CheckBox1.Checked Then
      Begin
       WipEdit.Color := ClWindow;
       WipEdit.Enabled := True;
       WipEdit.TabStop := True ;
       CheckBox2.Checked := false;
       CheckBox3.Checked := false;
       CheckBox4.Checked := false;
       WipEdit.SetFocus;
      End;
    If not(CheckBox1.Checked) then
      Begin
       WipEdit.Text := '';
       WipEdit.Color := ClGray ;
       WipEdit.Enabled := False;
       WipEdit.TabStop := False;
      End;
    end;
procedure TForm1.CheckBox2Click(Sender: TObject);
begin
    If CheckBox2.Checked Then
      Begin
       NameEdit.Color := ClWindow;
       NameEdit.Enabled := True;
       NameEdit.SetFocus;
      End;
    If not(CheckBox2.Checked) then
      Begin
       NameEdit.Color := ClGray ;
       NameEdit.Enabled := False;
       NameEdit.Text := '';
      end;
    end;
procedure TForm1.CheckBox3Click(Sender: TObject);
begin
     If CheckBox3.Checked Then
      Begin
       CntyEdit.Color := ClWindow;
       CntyEdit.Enabled := True;
       CntyEdit.SetFocus;
      End;
     If not(CheckBox3.Checked) then
      Begin
       CntyEdit.Color := ClGray ;
       CntyEdit.Enabled := False;
       CntyEdit.Text := '';
      end;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
    If CheckBox4.Checked Then
      Begin
       CSAEdit.Color := ClWindow;
       CSAEdit.Enabled := True;
       CsaEdit.SetFocus;
      End;
    If not(CheckBox4.Checked) then
      Begin
       CSAEdit.Color := ClGray ;
       CSAEdit.Enabled := False;
       CSAEdit.Text := '';
      end;
end;



procedure TForm1.RbEntDblClick(Sender: TObject);
begin
     RBEnt.Checked := False;
     FdateEdit.Color := ClGray;
     FdateEdit.Enabled := False;
     FdateEdit.Text := '';
     LdateEdit.Color := ClGray;
     LdateEdit.Enabled := False;
     LdateEdit.Text := '';
end;

procedure TForm1.RbEffDblClick(Sender: TObject);
begin
     RBeff.Checked := False;
     FdateEdit.Color := ClGray;
     FdateEdit.Enabled := False;
     FdateEdit.Text := '';
     LdateEdit.Color := ClGray;
     LdateEdit.Enabled := False;
     LDateEdit.Text := '';
end;

procedure TForm1.RbEffClick(Sender: TObject);
begin
     FdateEdit.Color := ClWindow;
     FdateEdit.Enabled := True;
     FdateEdit.SetFocus;
     LdateEdit.Color := ClWindow;
     LdateEdit.Enabled := True;
end;

procedure TForm1.RbEntClick(Sender: TObject);
begin
     FdateEdit.Color := ClWindow;
     FdateEdit.Enabled := True;
     FdateEdit.SetFocus;
     LdateEdit.Color := ClWindow;
     LdateEdit.Enabled := True;
end;
procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
    Report1.InitialValues.Add('@PARMS=<'+Query1.Sql[1]+'>') ;
    Report1.Run;
    Report1.Print;
end;

procedure TForm1.TabSet1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
Var
   S,Qcon,q0:      String;
begin
     q0 := 'Where ';
     Qcon := ' and ' ;
     s := Tabset1.Tabs.Strings[NewTab];
     Query1.close;
     If Not QActive then
        Begin
             Query1.SQL.CLEAR;
             Query1.Sql.Add('Select * from WIPS');
             Query1.Sql.Add(' Name_Of_Insured like '''+s+'''%'')');
        End
     Else
        query1.Sql[1] := CurQuery+qcon+'(Name_Of_Insured Like '''+s+'%'')';
        ActiveQuery[0] := Query1.Sql[0];
        ActiveQuery[1] := Query1.Sql[1];
     Query1.sql[1] := q0+'('+Query1.sql[1]+')';
     query1.open;
End;


procedure TForm1.BitBtn1Click(Sender: TObject);
Var
   x:                         Integer;
   Compound:                  Boolean;
   Q0,Q1,Q2,Q3,Q4,Q5,Q6,Q7:   String;
   ck1,ck2,ck3,ck4,Rb1,Rb2:   Boolean;
   Qcon:                      String;
   begin
     query1.close;
     query1.SQL.clear;
     Compound := False;
     Qcon := ' and ';
     q1 := 'Select * from  WIPS';
     q2 := '(WIP_No = '''+ WipEdit.Text + ''')';
     q3 := '(Name_Of_Insured Like ''' + NameEdit.text + ''')';
     q4 := '(County Like ''' + CntyEdit.text + ''')';
     q5 := '(CSA Like ''' +CSAEdit.text + ''')';
     q6 := '(Date_Entered BETWEEN '''+FdateEdit.Text+''' AND '''+LdateEdit.Text+''')';
     q7 := '(Pol_Eff_Date BETWEEN '''+FdateEdit.Text+''' AND '''+LdateEdit.text+''')';
     q0 := 'Where ';
     ck1 := CheckBox1.Checked;
     ck2 := CheckBox2.Checked;
     ck3 := CheckBox3.Checked;
     ck4 := CheckBox4.Checked;
     Rb1 := RbEnt.Checked;
     Rb2 := RbEff.Checked;
     Query1.sql.add(q1);
     query1.sql.add('');
     Compound := False;
     If ck1 then
        Query1.sql[1] := q2
     Else
         Begin
              If Ck2 then
                 Begin
                      Query1.sql[1] := Query1.sql[1]+q3;
                      If (ck3 or ck4 or Rb1 or Rb2) then
                         Begin
                              Query1.sql[1] := Query1.sql[1]+Qcon;
                              Compound := True;
                         End;
                 End;
              If Ck3 then
                 Begin
                      Query1.sql[1] := query1.sql[1]+q4;
                      If (ck4 or Rb1 or Rb2) then
                         Begin
                              Query1.sql[1] := Query1.sql[1]+Qcon;
                              Compound := True;
                         End;
                 End;
              If Ck4 then
                 Begin
                      Query1.sql[1] := Query1.Sql[1]+q5;
                      If (Rb1 or Rb2) Then
                         Begin
                              Query1.sql[1] := Query1.sql[1]+Qcon;
                              Compound := True;
                         End;
                 End;
              If Rb1 then
                 Query1.sql[1] := Query1.Sql[1]+q6;
              If Rb2 Then
                 Query1.sql[1] := Query1.Sql[1]+q7;
         End;
   If Compound then Query1.sql[1] := '('+Query1.sql[1]+')';
   If Not (Ck1 or Ck2 or Ck3 or Ck4 or Rb1 Or Rb2) then
      Begin
           Query1.sql[1] := '';
           CurQuery := Query1.Sql[1];
           Qactive := False;
      End
   Else
       Begin
            CurQuery := Query1.Sql[1];

            QActive := True;
       End;
   ActiveQuery[0] := Query1.Sql[0];
   ActiveQuery[1] := Query1.Sql[1];
   Query1.sql[1] := q0+query1.sql[1];
   query1.open;
end;

procedure TForm1.WipEditEnter(Sender: TObject);
begin
     BitBtn1.Default:=True
end;

procedure TForm1.NameEditEnter(Sender: TObject);
begin
     BitBtn1.Default:=True
end;

procedure TForm1.LdateEditEnter(Sender: TObject);
begin
     BitBtn1.Default:=True
end;

procedure TForm1.CSAEditEnter(Sender: TObject);
begin
     BitBtn1.Default:=True
end;

procedure TForm1.CntyEditEnter(Sender: TObject);
begin
     BitBtn1.Default:=True
end;

{procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     MessageDlg(Query1.sql[0]+' '+query1.sql[1],mtInformation,[mbOK],0);
end;}



End.
