{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit Splash;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls
, UserInfo, MiscComp;


type
  TSplashScreenForm = class(TDemoForm)
    Panel1: TPanel;
    Bevel1: TBevel;
      {bevels are really weird! try doing anything with the image and you'll see what
      i mean. that when opening/changing the dfm file with the editor can make a difference}
    Label1: TLabel;
    Label2: TLabel;
    Image1: TImage;
    procedure FormDeactivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
  private
    { Private declarations }
    fTimer: TTimer;
    fOnDeactivating:TNotifyEvent;
    procedure TimerOff(Sender: TObject);
  public
    { Public declarations }
    procedure ShowFor(PauseTime,FloatTime:Longint);
    property OnDeactivating:TNotifyEvent read fOnDeactivating write fOnDeactivating;
  end;

 TSplashScreen = class(TDialogShell) {see userinfo.pas for details}
 private
   fPauseTime: Longint;
   fFloatTime: Longint;
   fOnExecute:TNotifyEvent;
   fOnDeactivating:TNotifyEvent;
 protected
   function GetTest:Boolean; override;
 public
   constructor Create(aOwner:TComponent); override;
   procedure Execute; override;
 published
   property PauseTime:LongInt read fPauseTime write fPauseTime default 1000;
   property FloatTime:LongInt read fFloatTime write fFloatTime default 200;
   property OnDeactivating:TNotifyEvent read fOnDeactivating write fOnDeactivating;
   end;

implementation

{$R *.DFM}

Type
  TSplashFlag=(splInitialized,splInDCL);
  TSplashFlags= set of TSplashFlag;
Const
  SplashFlags:TSplashFlags=[];         {1byte}
  SplashScreen:TSplashScreenForm=nil;  {4bytes}

{ This will make the form disappear, and get freed, when ANY other form or window pops up.}

procedure TSplashScreenForm.ShowFor(PauseTime,FloatTime:Longint);
begin
  Show;                        {bring up the form}
  Update;                       {the display}
  if PauseTime>0 then begin
    fTimer:=TTimer.Create(self); {make a timer}
    with fTimer do try
      Enabled:=False;            {begin setting it}
      Interval:=PauseTime;         {set duration and event}
      OnTimer:=TimerOff;
      Enabled:=True;             {start the time}
      while Enabled do
        Application.ProcessMessages;     {AND WAIT RIGHT HERE TILL THE PAUSE TIME IS UP}
    finally
      fTimer.Free;
      fTimer:=nil;
      end;
    end;
  if FloatTime>0 then begin
    fTimer:=TTimer.Create(self); {make a timer}
    with fTimer do begin
      Enabled:=False;            {begin setting it}
      Interval:=FloatTime;         {set duration and event}
      OnTimer:=TimerOff;
      Enabled:=True;             {start the time}
      end;                       {DO NOT WAIT HERE BUT GO ON WITH OTHER INITS.}
    end;
end;

procedure TSplashScreenForm.TimerOff(Sender: TObject);
begin
  fTimer.Enabled:=False;
end;

procedure TSplashScreenForm.FormDeactivate(Sender: TObject);
begin
  Close;
end;

procedure TSplashScreenForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  try
    if assigned(fOnDeactivating) then
      fOnDeactivating(Self); {can turn off the timer!}
    if fTimer<>nil then      {normally we wait till the float elapses}
      try
        while fTimer.Enabled do
          Application.ProcessMessages;
      finally
        fTimer.Free;
        fTimer:=nil;
        end;
  finally
    Action:=caFree;
    {SplashScreen.Free;  {release the memory}
    SplashScreen:= nil; {zero out the pointer}
    end;
end;

{}

constructor TSplashScreen.Create(aOwner:TComponent);
begin
  inherited create(aOwner);
  fPauseTime:=0;
  fFloatTime:=200;
  if (aOwner=nil) then
    Execute;
end;

procedure TSplashScreen.Execute; {make the splash-screen form. it will free/nil itself.}
begin
  if SplashScreen=nil then begin
    SplashScreen:= TSplashScreenForm.Create(nil);
    With SplashScreen do begin
      OnDeActivate:=FormDeactivate;
      OnDeactivating:=Self.OnDeactivating;
      if splInDCL in SplashFlags then
        SplashScreen.Show {do not use timers while in a library}
      else
        SplashScreen.ShowFor(fPauseTime,fFloatTime);
      end;
    end; {else already active}
end;


function TSplashScreen.GetTest:Boolean;
begin
  Result:= Assigned(SplashScreen);
end;

{}

function InDcl:Boolean;
var
 i:integer;
 p:pchar;
begin
  Result:=False;
  getmem(p,80);
  try
    i:=GetModuleFileName(hInstance,p,80);
    Result:=StrPos(StrUpper(p),'.DCL')<>nil;
  finally
    FreeMem(p,80);
    end;
end;

procedure Initialize;
begin
  SplashFlags:=SplashFlags+[splInitialized];
  if InDcl then
    SplashFlags:=SplashFlags+[splInDCL] {store the flag so we can suppress delay during design}
  else
    with TSplashScreen.Create(nil) do   {tada!; make/free the _component_ that makes the form}
      Free;
end;

{ Here's the call to automatically show the SplashScreen when this unit is initialized!}
procedure TSplashScreenForm.FormClick(Sender: TObject);
begin
  Close;
end;

procedure TSplashScreenForm.Image1Click(Sender: TObject);
begin
  tForm(Owner).Close;
end;

initialization
  if not (splInitialized in SplashFlags) then
    Initialize;
end.

