{ DOS Shell and Service components by Michael Ax; Inspired by Ken Henderson}

Unit UserDOS;

interface
Uses
  Forms, WinTypes, Controls, Classes, WinProcs, SysUtils, Messages
  , WinDos
, PasUtils
, UserInfo;

Type

  TDosInfo = class(TUserInfo)
  {this isn't really an object and should be thought of as a function collection or
  wrapper to WinDOS}
  private
  protected
    function GetComSpec     : String; {returns environment entry}
    function GetOSVersion   : String;
    function GetCurrentDir  : String;
    function GetPrompt      : String;
    function GetPath        : String;
    function GetTemp        : String;
    function GetDOSDate     : String;
    function GetDOSTime     : String;
    function GetDiskSpace   : LongInt;
    function GetFreeSpace   : LongInt;
    function GetCtrlBreak   : Boolean;
    function GetDOSVerify   : Boolean;
    procedure SetCtrlBreak(Value:Boolean);
    procedure SetDOSVerify(Value:Boolean);
    procedure SetNoLongint(Value:Longint);
    procedure SetDOSDate(const Value:String);
    procedure SetDOSTime(const Value:String);
    procedure SetCurrentDir(const Value:String);
    procedure SetNoString(const Value:String);

  public
    constructor Create(AOwner: TComponent); override;

  published
    property CurrentDir  : String read GetCurrentDir write SetCurrentDir stored false;
    property ComSpec     : String read GetComSpec write SetNoString stored false;
    property Prompt      : String read GetPrompt write SetNoString stored false;
    property Path        : String read GetPath write SetNoString stored false;
    property Temp        : String read GetTemp write SetNoString stored false;
    property OSVersion   : String read GetOSVersion write SetNoString stored false;
    property DOSDate     : String read GetDOSDate write SetNoString stored false;
    property DOSTime     : String read GetDOSTime write SetNoString stored false;
    property DiskSpace   : Longint read GetDiskSpace write SetNoLongInt stored false;
    property FreeSpace   : Longint read GetFreeSpace write SetNoLongInt stored false;
    property CtrlBreak   : Boolean read GetCtrlBreak write SetCtrlBreak stored false;
    property Verify      : Boolean read GetDOSVerify write SetDOSVerify stored false;
  end;


implementation

{-----------------------------------------------------------------------------------------}
{ TDosInfo                                                                                }
{-----------------------------------------------------------------------------------------}

constructor TDosInfo.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

function TDosInfo.GetOSVersion:String;
var
  TempVer : word;
begin
  TempVer:= DosVersion;
  Result:=IntToStr(Lo(TempVer))+'.'+IntToStr(Hi(TempVer));
end;

function TDosInfo.GetCurrentDir:String;
begin
  Result:=ReceivePChar(GetCurDir(MakePChar(''),0));
end;

function TDosInfo.GetComSpec: String;
begin
  Result:=StrPas(GetEnvVar('COMSPEC'));
end;

function TDosInfo.GetPrompt:String;
begin
  Result:=StrPas(GetEnvVar('PROMPT'));
end;

function TDosInfo.GetPath:String;
begin
  Result:=StrPas(GetEnvVar('PATH'));
end;

function TDosInfo.GetTemp:String;
begin
  Result:=StrPas(GetEnvVar('TEMP'));
end;

function TDosInfo.GetDiskSpace:LongInt;
begin
  Result:=DiskSize(0);
end;

function TDosInfo.GetFreeSpace:LongInt;
begin
  Result:=DiskFree(0);
end;

function TDosInfo.GetDOSDate:String;
var
  Year, Month, Day, Dow : Word;
begin
  GetDate(Year,Month,Day,Dow);
  Result:=LeftPadZero(IntToStr(Month),2)
     +'/'+LeftPadZero(IntToStr(Day),2)
     +'/'+LeftPadZero(IntToStr(Year),4);
end;

function TDosInfo.GetDOSTime:String;
var
  Hour, Minute, Second, Sec100 : Word;
begin
  GetTime(Hour, Minute, Second, Sec100);
  Result:=LeftPadZero(IntToStr(Hour),2)+':'+LeftPadZero(IntToStr(Minute),2)+':'
             +LeftPadZero(IntToStr(Second),2)+'.'+LeftPadZero(IntToStr(Sec100),2);
end;

function TDosInfo.GetCtrlBreak:Boolean;
begin
  GetCBreak(Result);
end;

function TDosInfo.GetDOSVerify:Boolean;
begin
  GetVerify(Result);
end;

procedure TDosInfo.SetCurrentDir(const Value:String);
var
  Temp : array[0..255] of char;
begin
  SetCurDir(StrPCopy(Temp,Value));
end;

procedure TDosInfo.SetDOSDate(const Value:String);
var
  Year, Month, Day : Word;
begin
  Month:=StrToInt(Copy(Value,1,2));
  Day:=StrToInt(Copy(Value,4,2));
  Year:=StrToInt(Copy(Value,7,4));
  SetDate(Year,Month,Day);
end;

procedure TDosInfo.SetDOSTime(const Value:String);
var
  Hour, Minute, Second, Sec100 : Word;
begin
  Hour:=StrToInt(Copy(Value,1,2));
  Minute:=StrToInt(Copy(Value,4,2));
  Second:=StrToInt(Copy(Value,7,2));
  Sec100:=StrToIntDef(Copy(Value,10,2),0);
  SetTime(Hour,Minute,Second, Sec100);
end;

procedure TDosInfo.SetCtrlBreak(Value:Boolean);
begin
  SetCBreak(Value);
end;

procedure TDosInfo.SetDOSVerify(Value:Boolean);
begin
  SetVerify(Value);
end;

procedure TDosInfo.SetNoString(const Value:String);
begin
end;

procedure TDosInfo.SetNoLongint(Value:Longint);
begin
end;

{-----------------------------------------------------------------------------------------}
{                                                                                         }
{-----------------------------------------------------------------------------------------}

end.

