{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit UserBDE;

{-----------------------------------------------------------------------------------------}
{ USERBDE                                                                                 }
{-----------------------------------------------------------------------------------------}

interface

uses
  Classes
  ,dbiTypes
  ,UserInfo;

Type
  TBDEUserInfo = class(TUserInfo)
  {this wrapper for a couple of bde status calls demonstrates initializing vis UpdateOK}
  private
    fLocalShare     : Boolean;       { If Local files will be shared }
    fNetProtocol    : Word;          { Net Protocol (35, 40 etc.) }
    fNetShare       : Boolean;       { True if connected to network }
    fzNetType       : DBINAME;       { Network type }
    fzUserName      : DBIUSERNAME;   { Network user name }
    fzIniFile       : DBIPATH;       { Configuration file }
    fzLangDriver    : DBINAME;       { System language driver }
  protected
    function GetPath:String;
    function GetDriver:String;
    function GetNetType:String;
    function GetUserName:String;
    procedure SetNoWord(Value:Word);
    procedure SetNoBool(Value:Boolean);
    procedure SetNoString(const Value:String);
  public
    Constructor Create(aOwner:TComponent); Override;
    function UpdateOK:boolean; Override;
  published
    property NetProtocol   : Word read fNetProtocol write SetNoWord;   { Net Protocol (35, 40 etc.) }
    property LocalShare    : Boolean read fLocalShare write SetNoBool; { If Local files will be shared }
    property NetShare      : Boolean read fNetShare write SetNoBool;   { True if connected to network }
    property NetType       : String read GetNetType write SetNoString; { Network type }
    property UserName      : String read GetUserName write SetNoString;{ Network user name }
    property IniFile       : String read GetPath write SetNoString;    { Configuration file }
    property LangDriver    : String read GetDriver write SetNoString;  { System language driver }
    end;

implementation

uses
  dbiProcs, sysUtils;

{-----------------------------------------------------------------------------------------}
{ OBJECT CREATION                                                                         }
{-----------------------------------------------------------------------------------------}

Constructor TBDEUserInfo.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  fzNetType[0]    := #0;
  fzUserName[0]   := #0;
  fzIniFile[0]    := #0;
  fzLangDriver[0] := #0;
end;

function TBDEUserInfo.UpdateOK:boolean;
var
  BDEcfg: SYSConfig;      { BDE Configuration information record }
begin
  Result:=inherited UpdateOK;
  if not Result then
    Exit;
  DbiGetSysConfig(BDEcfg);
  with BDEcfg do begin
    fNetProtocol    := iNetProtocol;
    fLocalShare     := bLocalShare;
    fNetShare       := bNetShare;
    fzNetType       := fzNetType;
    fzUserName      := szUserName;
    fzIniFile       := fzIniFile;
    fzLangDriver    := fzLangDriver;
    end;
end;

{-----------------------------------------------------------------------------------------}
{ OBJECT PLUMBING  (convert PChar to Pascal String)                                       }
{-----------------------------------------------------------------------------------------}

function TBDEUserInfo.GetPath:String;
begin
  Result:=StrPas(fzIniFile);
end;

function TBDEUserInfo.GetDriver:String;
begin
  Result:=StrPas(fzLangDriver);
end;

function TBDEUserInfo.GetNetType:String;
begin
  Result:=StrPas(fzNetType);
end;

function TBDEUserInfo.GetUserName:String;
begin
  Result:=StrPas(fzUserName);
end;

{}

procedure TBDEUserInfo.SetNoWord(Value:Word);
begin
end;

procedure TBDEUserInfo.SetNoBool(Value:Boolean);
begin
end;

procedure TBDEUserInfo.SetNoString(const Value:String);
begin
end;

{-----------------------------------------------------------------------------------------}
{                                                                                         }
{-----------------------------------------------------------------------------------------}

end.
