{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit TxtGrid;

{this stringgrid component autosizes its columns as you set the
added FitCells[] property. A default spacing of 5 pixels from
the end of the widest text to the gridline is in effect}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids;

type
  TTextGrid = class(TStringGrid)
  private
    fFromRight: Byte;
    fSuspendFit: Boolean;  {use cells[] 'instead' if true}
  protected
    procedure SetFitCells(ACol, ARow: Integer; const Value: string);
  public
    constructor Create(aOwner:TComponent); override;
    property FitCells[ACol,ARow:Integer]: string write SetFitCells;
  published
    property FromRight: Byte read fFromRight write fFromRight default 5;
    property SuspendFit: Boolean read fSuspendFit write fSuspendFit;
  end;

{------------------------------------------------------------------------------}

implementation

{------------------------------------------------------------------------------}

constructor TTextGrid.Create(aOwner:TComponent);
begin
  inherited create(aOwner);
  fFromRight:=5;
  DefaultColWidth:= 10;
  DefaultRowHeight:= 18;
end;

procedure TTextGrid.SetFitCells(ACol, ARow: Integer; const Value: string);
var
  i:integer;
begin
  if not fSuspendFit then begin
    i:=Canvas.textwidth(Value)+fFromRight;
    if ColWidths[aCol]<i then
      ColWidths[aCol]:=i;
    end;
  Cells[aCol,aRow]:=Value;
end;

end.
