{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit Restorer;


interface

uses Classes, Forms,
  UserInfo
  ,IniLink;

type
 TRestorerFlag = (resLoad,resSave);
 TRestorerFlags = set of TRestorerFlag;

 TGenericRestorer = class(TUserInfo)
 private
   fFlags: TRestorerFlags;
   fFormClose: TCloseEvent;
 protected
   function GetActive: Boolean;
   procedure SetActive(Value: Boolean); {will save when setting true in designmode}
   procedure FormClose(Sender: TObject; var Action: TCloseAction);
 public
   constructor Create(AOwner: TComponent); override;
   destructor Destroy; override;
   function UpdateOK:Boolean; Override;
   procedure Save; virtual; abstract;
   procedure Load; virtual; abstract;
 published
   property Active: Boolean read GetActive write SetActive stored false;
   property Flags: TRestorerFlags read fFlags write fFlags default [resLoad,resSave];
   end;

 TFormRestorer = class(TGenericRestorer)
 private
   fIniFileLink: TIniFileLink;
 protected
 public
   procedure Notification(AComponent: TComponent; Operation: TOperation); Override;
   procedure Save; Override;
   procedure Load; Override;
 published
   property IniFileLink: TIniFileLink read fIniFileLink write fIniFileLink;
   end;

implementation

constructor TGenericRestorer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Active:=True;
end;

function TGenericRestorer.UpdateOK:Boolean;
begin
{  ComponentIndex:=0; }
  Result:= inherited UpdateOK;
  if Result and (resLoad in fFlags) then
    Load;
  if not cx.Designing then begin            {when initializing at runtime}
    with TForm(Owner) do begin         {hook the save proc into the form's onclose handler}
      fFormClose:=OnClose;
      OnClose:=FormClose;
      end;
    end;
end;

destructor TGenericRestorer.Destroy;
{the action performed in here is normally not required as the form close proc has
been called and we're on the way to destroying the form.. but aha! if you instantiate
the component on the fly and remove it it would leave a hole in the close chain it you
were not to clear the pointer here anyway. luckily the form first destroys its children,
then itself, so the action here succeeds in either case.}
begin
  if assigned(fFormClose) then   {unhook}
    with TForm(Owner) do begin
      OnClose:=fFormClose;
      fFormClose:=nil;
      end;
  inherited Destroy;
end;


function TGenericRestorer.GetActive: Boolean;
begin
  Result:=fFlags<>[];
end;

procedure TGenericRestorer.SetActive(Value: Boolean);
begin
  if Value then begin
    fFlags:=[resLoad,resSave];
    if cx.Designing and (resSave in fFlags) then
      Save;
    end
  else
    fFlags:=[];
end;

{}

procedure TGenericRestorer.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if assigned(fFormClose) then
    fFormClose(Sender,Action);
  if (resSave in fFlags) then
    Save;
end;


{}

procedure TFormRestorer.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Operation = opRemove then begin
    cx.NilIfSet(fIniFileLink,AComponent);
    end;
end;

procedure TFormRestorer.Save;
var
  wp: TWindowPosValue;
begin
  cx.MakeIfNil(fIniFileLink,TIniFileLink);
  with tForm(Owner) do begin
    wp.Top:=Top;
    wp.Left:=Left;
    wp.Height:=Height;
    wp.Width:=Width;
    end;
  with fIniFileLink do begin
    Section:='WindowPos';
    WindowPosEntry[owner.classname]:=wp;
    end;
end;

procedure TFormRestorer.Load;
var
  wp: TWindowPosValue;
begin
  cx.MakeIfNil(fIniFileLink,TIniFileLink);
  with fIniFileLink do begin
    Section:='WindowPos';
    wp:=WindowPosEntry[owner.classname];
    end;
  if wp.Width>0 then
    with tForm(Owner) do begin
      Top:=wp.Top;
      Left:=wp.Left;
      Height:=wp.Height;
      Width:=wp.Width;
      end;
end;


end.
