{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit Resizer;

{ The ReSizer is a work in progress.
  Ulimately I will get it to work the way I want to but for the moment is rests with
  some issues unresolved. You will receive a working version once I get back to it.}


interface

uses Forms, SysUtils, WinProcs,
  Classes, Controls, Buttons, StdCtrls, ExtCtrls
, Toolbar;

type
  TReSizerPanelControl = class(TControl);
  TReSizerPanel = class(TExtendedPanel)
  private
    fAdjoined: TControl;
    fBoundControl: TControl;
    fFormDragOver: TDragOverEvent;
    fControlDragOver: TDragOverEvent;
    function GetAlign:TAlign; {override;}
    procedure SetAlign(Value:TAlign); {override; }
  protected
    procedure SetBoundControl(Value:TControl);
    procedure SetAdjoined(Value:TControl);
    function StoreBoundControl:Boolean;
    procedure LinkDragDrop;
    procedure UnLinkDragDrop;
    procedure PositionViaForm(x,y:Integer);
    procedure PositionViaControl(x,y:Integer);
    procedure PositionViaAdjoined(x,y:Integer);
    procedure AlignSelf;
  public
    constructor Create(aOwner:TComponent); Override;
    constructor CreateFor(aOwner:TComponent;aControl:TControl);
    procedure DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    destructor Destroy; Override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); Override;
  published
    property Align: TAlign read GetAlign write SetAlign;
    property Adjoined: TControl read fAdjoined write SetAdjoined;
    property BoundControl: TControl read fBoundControl write SetBoundControl Stored StoreBoundControl;
    end;

{------------------------------------------------------------------------------}

implementation

{------------------------------------------------------------------------------}

constructor TReSizerPanel.CreateFor(aOwner:TComponent;aControl:TControl);
{create a ResizerPanel from another control's creator using this proc. function actually.}
begin
  Create(aOwner); {call official constructor shown below/next}
  Parent:=TForm(aOwner); {this may blow up of course.}
  BoundControl:=TReSizerPanelControl(aControl); {note the typecasting!}
  UniqueName:='ReSizerPanel'; {see the panel code. setting the name now }
end;

constructor TReSizerPanel.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  Hint:='Drag to resize the area';
  Caption:='';
  Width := 3;
  Align := alNone;
  DragMode := dmAutomatic;
  BevelInner := bvRaised;
end;

destructor TReSizerPanel.Destroy;
begin
  UnLinkDragDrop;
  inherited Destroy;
end;

procedure TReSizerPanel.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Operation = opRemove then begin
    if fAdjoined=aComponent then
      fAdjoined:=nil;
    if fBoundControl=aComponent then
      fBoundControl:=nil;
    end;
end;

procedure TReSizerPanel.SetAdjoined(Value:TControl);
begin
  if Value=nil then
    Value:=TForm(Owner);
  if fAdjoined<>Value then begin
    UnLinkDragDrop;
    fAdjoined:=Value;
    LinkDragDrop;
    end;
end;


procedure TReSizerPanel.SetBoundControl(Value:TControl);
begin
  if fBoundControl<>Value then begin
    UnLinkDragDrop;
    fBoundControl:=Value;
    LinkDragDrop;
    Align:=fBoundControl.Align;
    AlignSelf;
    end;
end;


procedure TReSizerPanel.PositionViaAdjoined(x,y:Integer);
begin
  case Align of
    alLeft:   fBoundControl.Width:=  fBoundControl.Width+x;
    alRight:  fBoundControl.Width:=  fBoundControl.Width+fAdjoined.Width-x-1-self.Width;
    alTop:    fBoundControl.Height:= fBoundControl.Height+y;
    alBottom: fBoundControl.Height:= fBoundControl.Height+fAdjoined.Height-y-self.Height;
    end;
end;


procedure TReSizerPanel.PositionViaForm(x,y:Integer);
const
  i=2;
begin
  case Align of
    alBottom:
      if y+self.Height+i>=tForm(Owner).ClientHeight then
        y:=tForm(Owner).ClientHeight-self.Height-i;
    end;
  case Align of
    alLeft:   fBoundControl.Width:=  x-fBoundControl.Left;
    alRight:  fBoundControl.Width:=  fBoundControl.Width+fBoundControl.Left-x-self.Width;
    alTop:    fBoundControl.Height:= y-fBoundControl.Top;
    alBottom: fBoundControl.Height:=fBoundControl.Height+fBoundControl.Top-y-self.Height;
    end;
end;


procedure TReSizerPanel.PositionViaControl(x,y:Integer);
const
  i=2;
begin
  case Align of
    alRight:
      if x+i>=fBoundControl.Width then
        x:=fBoundControl.Width-i;
    alBottom:
      if y+i>=fBoundControl.Height then
        y:=fBoundControl.Height-i;
    end;
  case Align of
    alLeft:   fBoundControl.Width:=  x;
    alRight:  fBoundControl.Width:=  fBoundControl.Width-x;
    alTop:    fBoundControl.Height:= y;
    alBottom: fBoundControl.Height:= fBoundControl.Height-y;
    end;
end;


procedure TReSizerPanel.AlignSelf;
begin
  case Align of
    alLeft:   Left:= fBoundControl.Left+fBoundControl.Width;
    alRight:  Left:= fBoundControl.Left-Width;
    alTop:    Top:=  fBoundControl.Top+fBoundControl.Height;
    alBottom: Top:=  fBoundControl.Top-Height;
    end;
end;


function TReSizerPanel.StoreBoundControl:Boolean;
begin
{  UnLinkDragDrop;}
  Result:=True;
end;

function TReSizerPanel.GetAlign:TAlign;
begin
  result:=TExtendedPanel(Self).Align;
end;


procedure TReSizerPanel.SetAlign(Value:TAlign);
var
  c:TCursor;
  b:TPanelBevel;
begin
  if fBoundControl<>nil then
    fBoundControl.Align:=Value;
  TExtendedPanel(Self).Align:=Value;
  if fBoundControl<>nil then
    AlignSelf;
  {}
  case Value of
  alLeft,
  alRight:  Width := 3;
  alTop,
  alBottom: Height := 3;
    end;
  {}
  case Value of
  alLeft,
  alRight:  c:= crHSplit;
  alTop,
  alBottom: c:= crVSplit;
  else      c:= crDrag;
    end;
  Cursor := c;
  DragCursor := c;
  {}
  case Value of
  alBottom,
  alRight:  b:= bvRaised;
  alTop,
  alLeft:   b:= bvLowered;
  else      b:= bvLowered;
    end;
  if b=bvRaised then b:=bvLowered else b:=bvRaised;
  BevelOuter:=b;
  BevelInner:=b;
  {}
end;


procedure TReSizerPanel.UnLinkDragDrop;
begin {by casting we can access the private parts}
  if (fBoundControl<>nil) and assigned(fControlDragOver) then
    TReSizerPanelControl(fBoundControl).OnDragOver:=fControlDragOver;
  if (fAdjoined<>nil) and assigned(fFormDragOver) then
    TReSizerPanelControl(fAdjoined).OnDragOver:=fFormDragOver;
end;


procedure TReSizerPanel.LinkDragDrop;
begin
  if fBoundControl<>nil then
    with TReSizerPanelControl(fBoundControl) do begin
      fControlDragOver:=OnDragOver;
      OnDragOver:=DragOver;
      end;
  if fAdjoined<>nil then
    with TReSizerPanelControl(fAdjoined) do begin
      fFormDragOver:=OnDragOver;
      OnDragOver:=DragOver;
      end;
end;


procedure TReSizerPanel.DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
const
  i=2;
begin
{  tlabel(tform(owner).findcomponent('Label1')).Caption:=
    'Self: '+name+'/'+fBoundControl.ClassName+'.'+fBoundControl.Name;
  tlabel(tform(owner).findcomponent('Label2')).Caption:=
    'Sender: '+sender.classname+'.'+tcomponent(sender).name+'  '
   +'Source: '+source.classname+'.'+tcomponent(source).name+'  ';   {}

  if Self=TReSizerPanel(Source) then begin
    if y<i then
      y:=i;
    if x<i then
      x:=i;
    if Sender = TObject(fAdjoined) then
      if fAdjoined=Owner then
        PositionViaForm(x,y)
      else
        PositionViaAdjoined(x,y)
    else
      PositionViaControl(x,y);
    AlignSelf;
    end;
{  else}
    if Sender = TObject(fAdjoined) then
      if assigned(fFormDragOver) then
        fFormDragOver(fAdjoined,Source,X,Y,State,Accept)
      else
    else
      if Sender = TObject(fBoundControl) then
        if assigned(fControlDragOver) then
          fControlDragOver(Sender,Source,X,Y,State,Accept); {}
end;

{------------------------------------------------------------------------------}

end.

