{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit LoginDlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, dbiTypes
, UserInfo, MiscComp;

{------------------------------------------------------------------------------}
{                                                                              }
{------------------------------------------------------------------------------}

type
  TLoginDialogForm = class(TDemoForm)
    Label1: TLabel;
    Password: TEdit;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label2: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

{------------------------------------------------------------------------------}
{                                                                              }
{------------------------------------------------------------------------------}

  TLoginDialog = class(TDialogShell)
  private
    fPassword: string;
        {type plain/network/windows; include screen save pw coder and tests against bindery}
    fRetries: Integer;
    fRequired: Boolean;
    fPasswordOk: Boolean;
    fCaseSensitive: Boolean;
  protected
  public
    constructor Create(aOwner:Tcomponent); Override;
    procedure Execute; Override;
    function Login(MasterPassword:String):Boolean;
  published
    property CaseSensitive: Boolean read fCaseSensitive write fCaseSensitive;
    property PassWord: String read fPassWord write fPassword;
    property PassWordOk: Boolean read fPassWordOk write fPasswordOk stored false;
    property Required: Boolean read fRequired write fRequired default true;
    property Retries: Integer read fRetries write fRetries default 2;
    end;

{------------------------------------------------------------------------------}
{                                                                              }
{------------------------------------------------------------------------------}

implementation

uses SysUtils;

{$R *.DFM}


constructor TLoginDialog.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  fRequired:=True;
  fRetries:=2;
end;

procedure TLoginDialog.Execute;
var
  Cursor:TCursor;
  i: integer;
begin
  if (not fRequired) or (fPassword='') then begin
    fPasswordOk:=True;
    exit;
    end;
  fPasswordOk:=False;
  Cursor:=Screen.Cursor;
  Screen.Cursor:=crDefault;
  With TLoginDialogForm.Create(Application) do try
    for i:=0 to fRetries do begin
      Password.SelectAll;
      if ShowModal<>IdOk then
        break;
      if fCaseSensitive then
        fPasswordOk:= (Password.Text=fPassword)
      else
        fPasswordOk:= (uppercase(Password.Text)=uppercase(fPassword));
      if fPasswordOk then
        break;
      end;
  finally
    Free;
    end;
  Screen.Cursor:=Cursor;
end;

function TLoginDialog.Login(MasterPassword:String):boolean;
begin
  fPassWord:= MasterPassword;
  Execute;
  fPassword:='';
  Result:= fPasswordOk;
end;

end.

