{------------------------------------------------------------------------------}
{UNREGISTERED VERSION (6/1/95) PLEASE REDISTRIBUTE IN tPACK.ZIP!
 This revision does not contain everything, nor are the exciting
 DataSetReporter and ExtendedMenu[Item] components included.
 Use SWREG#5906 to receive these, icons and a help file for $130.
 You must register when using this code in a business application!
 You'll receive a license to use this code in up to 50 copies of
 any app you write. In turn you will get responsive e-mail
 tech support and enhancements till I run out of registrations
 or suggestions. Meanwhile.. enjoy the code. Bye! I'll make more.
 {(C)'1995 Michael/Ax-Systems, 71560,1754@Compuserve.com}
{------------------------------------------------------------------------------}

unit IniLink;

{THE POINT: To provide a delphiesque link to INI files using delphi's ini class as a
starting point for a component by wrapping that class into a component.}

{FUNCTION: Think of it as an INI file you can visually put on a form. The file can be
opened, closed manually or implicitly when accessed. The filehandele itself is accessible
so you get direct access to TIniFile, plus the support offered by the ..Value Properties}

{IT GOES BEYOND THAT: the component is actually three layers.
first we hook up to the file providing a host of features to automate setting the name
  and path as well as providing defaults for the section name.
the second layer adds 'retry' support for reading and writing to the ini file even when
  at first the file is busy. in addition to the standard data types the second layer adds
  support for the Char, Extended, TPoint and TRect types as well as the custom
  TWindowPosValue type that can be used to store/restore control positions and/or
  windowframes using built in procedures. you can access the section/entry item using the
  second level's  ...Value properties.
the third and final layers adds array syntax allowing you to access the supported datatypes
  as arrays in a section. you can access items in a section by name using the third level's
  ...Entry[Entry:String] properties.}

{TO USE: do nothing and once you place the component on a form you can access the default
entry in the default section in the default ini file using any ...Value property.
These properties don't show up in the object inspector as every entry in the file could be
of any of the supported types but they are there. see the code below. }

interface

uses
  SysUtils, Classes, Forms, IniFiles, WinTypes, Controls
  ,Retry
  ,PasUtils
  ,UserInfo
  ,UserWin;
  {define condititional and code flPrivateDirectory}

type
  TFileLocation = (flWindowsDir, flNamed, flSystemDir, flExePath); {defaults to flWindowsDir}
  TNameType = (ftNamed, ftExeName, ftWindows, ftSystem, ftControl); {defaults to ftNamed (TEMP.INI)}

  TIniFileLinkFile = class(TDialogShell)
    Handle: TIniFile;  {NOTE! Handle to TIniFile is herewith published!}
  private
    fFileName: PString;
    fFilePath: PString;
    fSection: PString;
    fEntry: PString;

    fLeaveOpen: Boolean;
    fNameType: TNameType;
    fLocationType: TFileLocation;
    fWindowsUserInfo: TWindowsUserInfo;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); Override;

    function GetIniFileName:string;
    procedure SetIniFileName(const Value:String);
    function GetFileName:String;
    procedure SetFileName(const Value:String);
    function GetFilePath:String;
    procedure SetFilePath(const Value:String);

    function GetSection:String;
    procedure SetSection(const Value:String);
    function GetEntry:String;
    procedure SetEntry(const Value:String);

    procedure SetFileLocation(Value: TFileLocation);
    procedure SetNameType(Value: TNameType);
    function StoreFileName:Boolean;
    function StoreFilePath:Boolean;

  public
    constructor Create(AOwner: TComponent); Override;
    destructor Destroy; Override;
    function FileSectionEntry:String;
    function  IsOpen:Boolean;
    procedure Open; {this WILL open the file!}
    procedure Close;
  published
    property FileType: TNameType read fNameType write SetNameType;
    property FileLocation: TFileLocation read fLocationType write SetFileLocation;
    property IniFileName: String read GetIniFileName write SetIniFileName stored false;
    property IniName: String read GetFileName write SetFileName stored StoreFileName;
    property IniPath: String read GetFilePath write SetFilePath stored StoreFilePath;
    property Section: String read GetSection write SetSection;
    property Entry:   String read GetEntry write SetEntry;
    property LeaveOpen: Boolean read fLeaveOpen write fLeaveOpen;      {trigger caching!}
    property WindowsUserInfo: TWindowsUserInfo read fWindowsUserInfo write fWindowsUserInfo;
  end;

{-------------------------------------------------------------------------}
{  ADD ADDTL datatypes to the ini inteface                                }
{-------------------------------------------------------------------------}

  TWindowPosValue = record
    Top,Left,Height,Width: integer;
    end;

  TIniActions = (iaEraseSection,iaEraseEntry

                ,iaGetBool,iaSetBool
                ,iaGetInt,iaSetInt
                ,iaGetString,iaSetString

                ,iaGetChar,iaSetChar
                ,iaGetExt,iaSetExt
                ,iaGetPoint,iaSetPoint
                ,iaGetRect,iaSetRect
                ,iaGetWPos,iaSetWPos
                );

  TIniFileLinkData = class(TIniFileLinkFile)
  protected
    fRetry: TRetry;
    fAction: TIniActions;

    fString: PString;
    fBool: Boolean;
    fInteger: Longint;
    fExt: Extended;
    fRect: TRect;

  private
    procedure DoAction(Sender:TObject);
    procedure DoIniAction(Action:TIniActions);

    function GetBooleanValue:Boolean;
    procedure SetBooleanValue(Value:Boolean);
    function GetLongIntValue:LongInt;
    procedure SetLongIntValue(Value:LongInt);
    function GetStringValue:String;
    procedure SetStringValue(const Value:String);
    function GetCharacterValue:Char;
    procedure SetCharacterValue(Value:Char);
    function GetExtendedValue:Extended;
    procedure SetExtendedValue(Value:Extended);
    function GetPointValue:TPoint;
    procedure SetPointValue(Value:TPoint);
    function GetRectValue:TRect;
    procedure SetRectValue(Value:TRect);
    function GetWindowPosValue:TWindowPosValue;
    procedure SetWindowPosValue(Value:TWindowPosValue);
    function GetOnException:TRetryExceptionEvent;
    procedure SetOnException(Value:TRetryExceptionEvent);

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure EraseSection;    {does what it says}
    procedure EraseEntry;      {so does this}         {properties your code reads/sets}
    procedure StoreControlPos(Control:TControl);
    procedure LoadControlPos(Control:TControl);
    property BooleanValue: Boolean read GetBooleanValue write SetBooleanValue stored false;
    property LongIntValue: LongInt read GetLongIntValue write SetLongIntValue stored false;
    property StringValue: String read GetStringValue write SetStringValue stored false;
    property CharacterValue: char read GetCharacterValue write SetCharacterValue stored false;
    property ExtendedValue: Extended read GetExtendedValue write SetExtendedValue stored false;
    property PointValue: TPoint read GetPointValue write SetPointValue stored false;
    property RectValue: TRect read GetRectValue write SetRectValue stored false;
    property WindowPosValue: TWindowPosValue read GetWindowPosValue write SetWindowPosValue stored false;
  published
    property Retry:      TRetry read fRetry write fRetry;
    property OnException: TRetryExceptionEvent read GetOnException write SetOnException;
  end;


  TIniFileLink = class(TIniFileLinkData)
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  private
    constructor Create(AOwner: TComponent); override;
      {needs a constructor or virtual methods will not kick in!}
      {try to get this to work without a notification proc at this level! vcl seems
      to be writte with that in mind? can't be!}

    function GetBooleanEntry(const aEntry:String):Boolean;
    procedure SetBooleanEntry(const aEntry:String;Value:Boolean);
    function GetLongIntEntry(const aEntry:String):LongInt;
    procedure SetLongIntEntry(const aEntry:String;Value:LongInt);
    function GetStringEntry(const aEntry:String):String;
    procedure SetStringEntry(const aEntry:String;const Value:String);
    function GetCharacterEntry(const aEntry:String):Char;
    procedure SetCharacterEntry(const aEntry:String;Value:Char);
    function GetExtendedEntry(const aEntry:String):Extended;
    procedure SetExtendedEntry(const aEntry:String;Value:Extended);
    function GetPointEntry(const aEntry:String):TPoint;
    procedure SetPointEntry(const aEntry:String;Value:TPoint);
    function GetRectEntry(const aEntry:String):TRect;
    procedure SetRectEntry(const aEntry:String;Value:TRect);
    function GetWindowPosEntry(const aEntry:String):TWindowPosValue;
    procedure SetWindowPosEntry(const aEntry:String;Value:TWindowPosValue);
  public
    property BooleanEntry[const aEntry:String]: Boolean read GetBooleanEntry write SetBooleanEntry;
    property LongIntEntry[const Entry:String]: LongInt read GetLongIntEntry write SetLongIntEntry;
    property StringEntry[const Entry:String]: String read GetStringEntry write SetStringEntry;
    property CharacterEntry[const Entry:String]: char read GetCharacterEntry write SetCharacterEntry;
    property ExtendedEntry[const Entry:String]: Extended read GetExtendedEntry write SetExtendedEntry;
    property PointEntry[const Entry:String]: TPoint read GetPointEntry write SetPointEntry;
    property RectEntry[const Entry:String]: TRect read GetRectEntry write SetRectEntry;
    property WindowPosEntry[const Entry:String]: TWindowPosValue read GetWindowPosEntry write SetWindowPosEntry;
  published
    end;

{-------------------------------------------------------------------------}

implementation

uses wincrt;

{-------------------------------------------------------------------------}

constructor TIniFileLinkFile.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  cx.SetIfFound(fWindowsUserInfo,TWindowsUserInfo);
  fFileName := NullStr;
  fFilePath := NullStr;
  fSection := NullStr;
  fEntry := NullStr;
  Handle := nil;
end;

destructor TIniFileLinkFile.Destroy;
begin
  Close;
  DisposeStr(fEntry);
  DisposeStr(fSection);
  DisposeStr(fFilePath);
  DisposeStr(fFileName);
  inherited Destroy;
end;

procedure TIniFileLinkFile.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Operation = opRemove then begin
    cx.NilIfSet(fWindowsUserInfo,AComponent);{say what you mean}
    end;
end;

{-------------------------------------------------------------------------}

procedure TIniFileLinkFile.SetFileName(const Value: String);
begin
  if Value <> fFileName^ then begin
    Close;
    AssignStr(fFileName,Value);
    end;
end;

function TIniFileLinkFile.StoreFileName:Boolean;
begin
  Result:= fNameType=ftNamed;
end;

procedure TIniFileLinkFile.SetFilePath(const Value: String);
begin
  if Value <> fFilePath^ then begin
    Close;
    AssignStr(fFilePath,Value);
    end;
end;

function TIniFileLinkFile.StoreFilePath:Boolean;
begin
  Result:= fLocationType=flNamed;
end;

{-------------------------------------------------------------------------}

procedure TIniFileLinkFile.SetFileLocation(Value: TFileLocation);
begin
  if Value <> fLocationType then begin
    case fNameType of
    ftWindows,
    ftSystem,
    ftControl: Value := flWindowsDir;
    ftNamed: AssignStr(fFilePath,'');
      end;
    if Value <> fLocationType then begin
      Close;
      fLocationType := Value;
      end;
    end;
end;

procedure TIniFileLinkFile.SetNameType(Value: TNameType);
begin
  if Value <> fNameType then begin
    Close;
    fNameType := Value;
    case Value of
    ftWindows,
    ftSystem,
    ftControl: fLocationType := flWindowsDir;
    ftNamed: AssignStr(fFileName,'');
      end;
    end;
end;

{-------------------------------------------------------------------------}

function TIniFileLinkFile.GetFileName: String;
begin
  Result:='';
  case fNameType of
  ftNamed: Result:=fFileName^; {as is, might be blank}
  ftExeName: if cx.Designing then
               Result:='(exename)';
  ftWindows: Result:='Windows';
  ftSystem:  Result:='System';
  ftControl: Result:='Control';
    end;
  if not cx.Designing then
    if (fNameType=ftExeName) or (fFileName^='') then
      Result:=ExtractFileName(paramstr(0));
  if Result='' then
    Result:='Temp';
  if Result<>fFileName^ then
    AssignStr(fFileName,Result);
  Result:=ChangeFileExt(Result,'.INI');
end;

function TIniFileLinkFile.GetFilePath: String;
begin
  Result:='';
  if (fLocationType in [flWindowsDir, flSystemDir]) then
    cx.MakeIfNil(fWindowsUserInfo,TWindowsUserInfo);
  case fLocationType of
  flNamed: Result:=fFilePath^; {as is, might be blank}
  flExePath:
    if cx.Designing then
      Result:='(exepath)'; {will set below at runtime}
  flWindowsDir: Result:=fWindowsUserInfo.WindowsPath;
  flSystemDir: Result:=fWindowsUserInfo.SystemPath;
    end;
  if not cx.Designing then
    if (fLocationType=flExePath) or (fFilePath^='') then
      Result:=ExtractFilePath(paramstr(0)); {default}
  if Result='' then
    Result:='C:\';
  if not cx.Designing then
    Result:=TrailingBackSlash(Result);
  if Result<>fFilePath^ then
    AssignStr(fFilePath,Result);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkFile.GetIniFileName: String;
begin
  Result:=IniPath+IniName; {read properties vis get functions}
end;

procedure TIniFileLinkFile.SetIniFileName(const Value: String);
begin
  fLocationType:=flNamed;  {reset the flags so everything's consistent}
  fNameType:=ftNamed;
  AssignStr(fFilePath,TrailingBackSlash(ExtractFilePath(Value)));
  AssignStr(fFileName,ExtractFileName(Value));
end;

{-------------------------------------------------------------------------}

function TIniFileLinkFile.GetSection:String;
begin
  if fSection^='' then
    Result:='(blank)'
  else
    Result:=fSection^;
end;

procedure TIniFileLinkFile.SetSection(const Value:String);
begin
  AssignStr(fSection,Value);
end;

function TIniFileLinkFile.GetEntry:String;
begin
  if fEntry^='' then
    Result:='(blank)'
  else
    Result:=fEntry^;
end;

procedure TIniFileLinkFile.SetEntry(const Value:String);
begin
  AssignStr(fEntry,Value);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkFile.FileSectionEntry:String;
begin
  Result:=IniFileName+'['+Section+']'+Entry;
end;

{-------------------------------------------------------------------------}

function TIniFileLinkFile.IsOpen:Boolean;
begin
  Result:=Handle<>nil;
end;

procedure TIniFileLinkFile.Open;
begin
  if cx.Designing then begin
    if fNameType=ftExeName then
      Raise Exception.Create('No ExeName available while designing!'+#13
                            +'Specify another INI-name type for now.');
    if (fLocationType in [flWindowsDir, flSystemDir]) then
      cx.MakeIfNil(fWindowsUserInfo,TWindowsUserInfo);
    end;
  if not IsOpen then
    Handle:=TIniFile.Create(GetIniFileName);
end;

procedure TIniFileLinkFile.Close;
begin
  if Handle<>nil then
    Handle.Free;
  Handle:=nil;
end;

{-------------------------------------------------------------------------}
{ TIniFileLinkData                                                        }
{-------------------------------------------------------------------------}

constructor TIniFileLinkData.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fRetry:=TRetry.Create;
  fString:=NullStr;;
end;

destructor TIniFileLinkData.Destroy;
begin
  DisposeStr(fString);
  fRetry.Free;
  inherited Destroy;
end;

{-------------------------------------------------------------------------}

procedure TIniFileLinkData.DoAction(Sender:TObject);
{this proc is called via the retry mechanism}
{compond types based on StringValue will trigger a one level recursion on 'Get'.
 this allows us to do the entire conversion inside the retry shell.}
var
  a1,a2:string;
begin
  Open; {no need to worry about recursing. open/close work via pointer=nil}

  with Handle do     {actions listed but not used will probably never trigger errors}
    case fAction of                                               {see procs below}
  iaEraseSection: EraseSection(Section);
    iaEraseEntry:  WriteString(Section,Entry,'');
       iaSetBool:    WriteBool(Section,Entry,fBool);
        iaSetInt: WriteInteger(Section,Entry,fInteger);
     iaSetString:  WriteString(Section,Entry,fString^);
       iaGetBool:       fBool:=ReadBool(Section,Entry,false);
        iaGetInt: fInteger:=ReadInteger(Section,Entry,0);
     iaGetString:   AssignStr(fString,ReadString(Section,Entry,''));
       iaGetChar: ;
       iaSetChar: ;
        iaGetExt: begin
                  a1:=StringValue; {one recursion}
                  fAction:=iaGetExt; {returns here in error}
                  fExt:=StrToFloat(a1);
                  end;
        iaSetExt: ;
      iaGetPoint: with fRect.Topleft do begin
                  SplitString(StringValue,',',a1,a2);
                  fAction:=iaGetPoint;
                  x:=StrToInt(a1);
                  y:=StrToInt(a2);
                  end;
      iaSetPoint: ;
       iaGetRect: with fRect do begin
                  SplitString(StringValue,',',a1,a2);
                  fAction:=iaGetRect;
                  Left:=StrToIntDef(a1,0);
                  SplitString(a2,',',a1,a2);
                  Top:=StrToIntDef(a1,0);
                  SplitString(a2,',',a1,a2);
                  Right:=StrToIntDef(a1,0);
                  Bottom:=StrToIntDef(a2,0);
                  end;
       iaSetRect: ;
       iaGetWPos: with TWindowPosValue(fRect) do begin
                  SplitString(StringValue,',',a1,a2);
                  fAction:=iaGetWPos;
                  Top:=StrToIntDef(a1,0);
                  SplitString(a2,',',a1,a2);
                  Left:=StrToIntDef(a1,0);
                  SplitString(a2,',',a1,a2);
                  Height:=StrToIntDef(a1,0);
                  Width:=StrToIntDef(a2,0);
                  end;
       iaSetWPos: ;
    end;

  if not LeaveOpen then
    Close;
end;

procedure TIniFileLinkData.DoIniAction(Action:TIniActions);
begin
  fAction:=Action;
  fRetry.RetryAction(DoAction);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetOnException:TRetryExceptionEvent;
begin
  Result:=fRetry.OnException;
end;

procedure TIniFileLinkData.SetOnException(Value:TRetryExceptionEvent);
begin
  fRetry.OnException:=Value;
end;

{-------------------------------------------------------------------------}

procedure TIniFileLinkData.EraseSection;
begin
  DoIniAction(iaEraseSection);
end;

procedure TIniFileLinkData.EraseEntry;
begin
  DoIniAction(iaEraseEntry);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetBooleanValue:Boolean;
begin
  DoIniAction(iaGetBool);
  Result:=fBool;
end;

procedure TIniFileLinkData.SetBooleanValue(Value:Boolean);
begin
  fBool:=Value;
  DoIniAction(iaSetBool);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetStringValue:String;
begin
  DoIniAction(iaGetString);
  Result:=fString^;
end;

procedure TIniFileLinkData.SetStringValue(const Value:String);
begin
  AssignStr(fString,Value);
  DoIniAction(iaSetString);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetLongIntValue:LongInt;
begin
  DoIniAction(iaGetInt);
  Result:=fInteger;
end;

procedure TIniFileLinkData.SetLongIntValue(Value:LongInt);
begin
  fInteger:=Value;
  DoIniAction(iaSetInt);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetCharacterValue:Char;
begin
  DoIniAction(iaGetString);
  Result:=fString^[1];
end;

procedure TIniFileLinkData.SetCharacterValue(Value:Char);
begin
  AssignStr(fString,Value);
  DoIniAction(iaSetString);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetExtendedValue:Extended;
begin
  fExt:=0;
  DoIniAction(iaGetExt);
  Result:=fExt;
end;

procedure TIniFileLinkData.SetExtendedValue(Value:Extended);
begin
  StringValue:=FloatToStr(Value);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetPointValue:TPoint;
begin
  DoIniAction(iaGetPoint);
  Result:=fRect.TopLeft;
end;

procedure TIniFileLinkData.SetPointValue(Value:TPoint);
begin
  with Value do
    StringValue:=inttostr(x)+','+inttostr(y);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetRectValue:TRect;
begin
  DoIniAction(iaGetRect);
  Result:=fRect;
end;

procedure TIniFileLinkData.SetRectValue(Value:TRect);
begin
  with Value do
    StringValue:=inttostr(Left)+','+inttostr(Top)+','
                +inttostr(Right)+','+inttostr(Bottom);
end;

{-------------------------------------------------------------------------}

function TIniFileLinkData.GetWindowPosValue:TWindowPosValue;
begin
  DoIniAction(iaGetWPos);
  Result:=TWindowPosValue(fRect);
end;

procedure TIniFileLinkData.SetWindowPosValue(Value:TWindowPosValue);
begin
  with Value do
    StringValue:=inttostr(Top)+','+inttostr(Left)+','
                +inttostr(Height)+','+inttostr(Width);
end;

{-------------------------------------------------------------------------}

procedure TIniFileLinkData.StoreControlPos(Control:TControl);
var
  wp:TWindowPosValue;
begin
  with Control do begin
    wp.Top:=Top;
    wp.Left:=Left;
    wp.Width:=Width;
    wp.Height:=Height;
    end;
  WindowPosValue:=wp;
end;

procedure TIniFileLinkData.LoadControlPos(Control:TControl);
var
  wp:TWindowPosValue;
begin
  wp:=WindowPosValue;
  with wp do begin
    Control.Top:=Top;
    Control.Left:=Left;
    Control.Width:=Width;
    Control.Height:=Height;
    end;
end;

{-------------------------------------------------------------------------}
{ TIniFileLink                                                            }
{-------------------------------------------------------------------------}

constructor TIniFileLink.Create(AOwner: TComponent);
begin {required to activate virtual methods. would compile without but works wrong then!}
  inherited Create(AOwner);
end;

procedure TIniFileLink.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
end;

{-------------------------------------------------------------------------}

function TIniFileLink.GetBooleanEntry(const aEntry:String):Boolean;
begin
  Entry:=aEntry;
  Result:=BooleanValue;
end;

procedure TIniFileLink.SetBooleanEntry(const aEntry:String;Value:Boolean);
begin
  Entry:=aEntry;
  BooleanValue:=Value;
end;

{-------------------------------------------------------------------------}
function TIniFileLink.GetLongIntEntry(const aEntry:String):LongInt;
begin
  Entry:=aEntry;
  Result:=LongIntValue;
end;

procedure TIniFileLink.SetLongIntEntry(const aEntry:String;Value:LongInt);
begin
  Entry:=aEntry;
  LongIntValue:=Value;
end;

{-------------------------------------------------------------------------}
function TIniFileLink.GetStringEntry(const aEntry:String):String;
begin
  Entry:=aEntry;
  Result:=StringValue;
end;

procedure TIniFileLink.SetStringEntry(const aEntry:String;const Value:String);
begin
  Entry:=aEntry;
  StringValue:=Value;
end;

{-------------------------------------------------------------------------}
function TIniFileLink.GetCharacterEntry(const aEntry:String):Char;
begin
  Entry:=aEntry;
  Result:=CharacterValue;
end;

procedure TIniFileLink.SetCharacterEntry(const aEntry:String;Value:Char);
begin
  Entry:=aEntry;
  CharacterValue:=Value;
end;

{-------------------------------------------------------------------------}
function TIniFileLink.GetExtendedEntry(const aEntry:String):Extended;
begin
  Entry:=aEntry;
  Result:=ExtendedValue;
end;

procedure TIniFileLink.SetExtendedEntry(const aEntry:String;Value:Extended);
begin
  Entry:=aEntry;
  ExtendedValue:=Value;
end;

{-------------------------------------------------------------------------}
function TIniFileLink.GetPointEntry(const aEntry:String):TPoint;
begin
  Entry:=aEntry;
  Result:=PointValue;
end;

procedure TIniFileLink.SetPointEntry(const aEntry:String;Value:TPoint);
begin
  Entry:=aEntry;
  PointValue:=Value;
end;

{-------------------------------------------------------------------------}
function TIniFileLink.GetRectEntry(const aEntry:String):TRect;
begin
  Entry:=aEntry;
  Result:=RectValue;
end;

procedure TIniFileLink.SetRectEntry(const aEntry:String;Value:TRect);
begin
  Entry:=aEntry;
  RectValue:=Value;
end;

{-------------------------------------------------------------------------}

function TIniFileLink.GetWindowPosEntry(const aEntry:String):TWindowPosValue;
begin
  Entry:=aEntry;
  Result:=WindowPosValue;
end;

procedure TIniFileLink.SetWindowPosEntry(const aEntry:String;Value:TWindowPosValue);
begin
  Entry:=aEntry;
  WindowPosValue:=Value;
end;

{-------------------------------------------------------------------------}

end.
