unit Strprn;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls,
  StdCtrls, DBTables, DB, Sysutils, Grids, Printers,dialogs;

type
  tempfile = text;
  TFStrPrn = class(TForm)
    DatabaseListbox: TListBox;
    TableListbox: TListBox;
    FieldListbox: TListBox;
    IndexListbox: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Table: TTable;
    FCBox: TEdit;
    StringGrid1: TStringGrid;
    Button1: TButton;
    Button2: TButton;
    CreateTButton: TButton;
    Button3: TButton;
    procedure TableListboxClick(Sender: TObject);
    procedure DatabaseListboxClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  end;

var
  FStrPrn: TFStrPrn;

implementation


{$R *.DFM}
const syntaxtbl: array[1..15,1..3] of string[15]=
   (('Boolean','BOOLEAN','BOOLEAN'),
    ('BCD','DECIMAL(x,y)','N/A'),
    ('Blob','BLOB(size,1)','BLOB(size,1)'),
    ('Byte','BYTES(size)','BYTES(size)'),
    ('Currency','MONEY','MONEY'),
    ('Date','DATE','DATE'),
    ('DateTime','Define','Define'),
    ('Float','FLOAT(10,2)','FLOAT(10,2)'),
    ('Graphic','BLOB(size,type)','BLOB(size,type'),
    ('Integer','INTEGER','INTEGER'),
    ('Memo','BLOB(len,1)','BLOB(len,1)'),
    ('Smallint','SMALLINT','SMALLINT'),
    ('String','CHARACTER','CHARACTER'),
    ('Time','TIME','N/A'),
    ('VarBytes','BYTES(n)','BYTES(n)'));

    PDX=2;
    DBASE=3;
Function dmap(s:string; dbtype: byte):string;
  var n:byte;
  begin
    dmap:='';
    for n:=1 to 15 do
      if s=syntaxtbl[n,1] then
        begin
          dmap:=syntaxtbl[n,dbtype];
          exit;
        end;
   end;

procedure TFStrPrn.TableListboxClick(Sender: TObject);
var n,r:integer;
    s:string;
begin
  FieldListbox.Clear;
  IndexListbox.Clear;
  {FCBox.Clear;}
  StringGrid1.ColCount:=4;
  StringGrid1.RowCount:=100;
  if FCBox.Text='' then FCBox.Text:='0';
  for n:=0 to strtoint(FCBox.Text)do
    for r:=0 to 4 do
      StringGrid1.Cells[r,n]:='';
  {Stringgrid1.refresh;}
  Table.DatabaseName := DatabaseListbox.Items[DatabaseListbox.ItemIndex];
  Table.TableName := TableListbox.Items[TableListbox.ItemIndex];
  Table.GetFieldNames(FieldListbox.Items);
  Table.GetIndexNames(IndexListbox.Items);
  Table.open;
  FCBox.Text:=inttostr(Table.FieldCount);
  StringGrid1.cells[0,0]:='Field Name';
  StringGrid1.cells[1,0]:='Data Type';
  StringGrid1.cells[2,0]:='Data Size';
  StringGrid1.cells[3,0]:='Indexed';
  With Table do
  for n:=0 to FieldCount-1 do
    begin
      Stringgrid1.cells[0,n+1]:=Fieldlistbox.items[n];
      if Fields[n].isindexfield then
        Stringgrid1.cells[3,n+1]:='*';
      s:='';
      case Fields[n].datatype of
         ftBoolean:  s:='Boolean';
         ftBCD:      s:='BCD';
         ftBlob:     s:='Blob';
         ftBytes:    s:='Byte';
         ftCurrency: s:='Currency';
         ftDate:     s:='Date';
         ftDateTime: s:='DateTime';
         ftFloat:    s:='Float';
         ftGraphic:  s:='Graphic';
         ftInteger:  s:='Integer';
         ftMemo:     s:='Memo';
         ftSmallint: s:='Smallint';
         ftString:   s:='String';
         ftTime:     s:='Time';
         ftUnknown:  s:='Unknown';
         ftVarBytes: s:='VarBytes';
         ftWord:     s:='Word';
       end; {case}
       StringGrid1.cells[1,n+1]:=s;
       Stringgrid1.cells[2,n+1]:=(inttostr(Fields[n].DataSize));
       if s='String' then
         Stringgrid1.cells[2,n+1]:=(inttostr(Fields[n].DataSize-1));

    end;
  Table.close;
end;

procedure TFStrPrn.DatabaseListboxClick(Sender: TObject);
begin
  TableListbox.Clear;
  FieldListbox.Clear;
  IndexListbox.Clear;
  Session.GetTableNames(DatabaseListbox.Items[DatabaseListbox.ItemIndex],
    '', True, False, TableListbox.Items);
end;

procedure TFStrPrn.FormCreate(Sender: TObject);
begin
  Session.GetDatabaseNames(DatabaseListbox.Items);
end;

procedure TFStrPrn.Button2Click(Sender: TObject);
begin
FStrPrn.close;
end;

procedure TFStrPrn.Button1Click(Sender: TObject);
var f:tempfile;
    viewer: string;
    St:Array[0..255] of Char;
    r,c,x: byte;
    s,stemp,indexstr:string;
    ttype: byte;

  function constr(ch:char;n:byte):string;
    var t:string;
    begin
      fillchar(t,n+1,ch);
      t[0]:=chr(n);
      constr:=t;
    end;

  function pad(s:string; n: byte):string;
    var t:string;
    begin
      pad:=s+constr(' ',n-length(s));
    end;

  function leftpad(s:string; n: byte):string;
    var t:string;
    begin
      leftpad:=constr(' ',n-length(s))+s;
    end;

  function center(s:string; w:byte):string;
    var n:byte;
    begin
      n:=(w div 2)-(length(s) div 2);
      center:=constr(' ',n)+s;
    end;

  function tab(n:byte):string;
    begin
      tab:=constr(' ',n);
    end;

  function nameonly(s:string):string;
    var p:byte;
    begin
      p:=pos('.',s);
      if p=0 then nameonly:=s
      else nameonly:=copy(s,1,p-1);
    end;

  Function upcasestr(s:string):string;
    var n: byte;
    begin
      for n:=1 to length(s) do s[n]:=upcase(s[n]);
    end;

  Function NoSpace(s:string):string;
    var n: byte;
    begin
      for n:=1 to length(s) do if s[n]=' ' then
         s[n]:='_';
      Nospace:=s;
    end;

  Function TblType(s:string):string;
     var p:byte;
     begin
       TblType:='{Undefined}';
       p:=pos('.',s);
       if p=0 then exit;
       s:=(copy(s,p+1,length(s)));
       s:=upcasestr(s);
       if (s='DB') then TblType:='ttParadox';
       if (s='DBF') then TblType:='ttDBase';
     end;

  Function opentextforWrite(var f:tempfile; const ss:string):boolean;
    begin
    if ss<>'' then
      begin
        {$i-}
        Assignfile(f,ss);
        rewrite(f);
        {$i-}
        OpenTextforWrite:=(ioresult=0);
      end
    else OpenTextForWrite:=False;
    end;

begin
 if sender=button1 then
  begin
  Table.active:=true;
  OpenTextForWrite(f,'x.txt');
  writeln(f,center(table.tablename+' Structure',70));
  writeln(f);
  writeln(f,pad('Field',25)+pad('Type',10)+
           pad('Size',10)+'Indexed');
  writeln(f);
  with stringgrid1 do
    for r:=1 to table.fieldcount do
      writeln(f,pad(cells[0,r],25)+
                pad(cells[1,r],10)+
                pad(cells[2,r],10)+
                cells[3,r]);
  writeln(f);
  writeln(f,'Additional Indexes:');
  writeln(f);
  if indexlistbox.items.count<>0 then
   for r:=0 to indexlistbox.items.count-1 do
     begin
       s:=indexlistbox.items[r];
       write(f,pad(s,15),':  ');
       table.active:=false;
       table.indexname:=s;
       table.active:=true;
       s:='';
       if table.indexfieldcount<>0 then
       for x:=0 to table.indexfieldcount-1 do
          s:=s + table.indexfields[x].fieldname+';';
       writeln(f,s);
     end;

  system.closefile(f);
  Table.Active:=false;
  end {if sender=button1}
  else if Sender = CreateTButton
  then

  begin {write CreateTable file}
  messagedlg('Not working correctly yet',mtInformation, [mbOK],0);
  exit;
  Table.active:=true;
  OpenTextForWrite(f,'x.txt');
  Writeln(f,tab(2),'with Table1 do');
  writeln(f,tab(4),'begin');
  writeln(f,tab(4),'active := False;');
  writeln(f,tab(4),'DatabaseName:=''TEST''; {change as needed}');
  writeln(f,tab(4),'TableName := ''',nameonly(table.tablename),''';');
  writeln(f,tab(4),'TableType := ',TblType(Table.Tablename),';');
  writeln(f,tab(4),'with FieldDefs do');
  writeln(f,tab(6),'begin');
  writeln(f,tab(6),'Clear;');
  indexstr:='';
  with stringgrid1 do
    for r:=1 to table.fieldcount do
      begin
      write(f,tab(6),'Add(''',cells[0,r],''', ft',cells[1,r],', ');
      if (cells[1,r]='String') or (cells[1,r]='Memo')
      then write (f,cells[2,r])
       else write(f,0);
      writeln(f,', false);');
      if cells[3,r]='*' then indexstr:=indexstr+cells[0,r]+';';
      end;
  writeln(f,tab(6),'end;');
  if indexstr<>'' then
    begin
      writeln(f,tab(4),'with indexdefs do');
      writeln(f,tab(6),'begin');
      writeln(f,tab(6),'Clear;');
      writeln(f,tab(6),'Add (''Prim Index'', ''',+
          copy(indexstr,1,length(indexstr)-1),''', [ixprimary, ixunique]);');
      writeln(f,tab(6),'end;');
    end;
  {Now create aux indexes}
  if indexlistbox.items.count<>0 then

   for r:=0 to indexlistbox.items.count-1 do
     begin
       s:=indexlistbox.items[r];
       write(f,tab(4),'AddIndex(''',s,'''');
       table.active:=false;
       table.indexname:=s;
       table.active:=true;
       indexstr:='';
       if table.indexfieldcount<>0 then
       for x:=0 to table.indexfieldcount-1 do
          indexstr:=indexstr + table.indexfields[x].fieldname+';';
       writeln(f,', ''',copy(indexstr,1,length(indexstr)-1),''', []);');
     end;


  writeln(f,tab(4),'CreateTable;');
  writeln(f,tab(4),'end;');
  system.closefile(f);
  Table.active:=false;
  end {else}
  else
  {SQL Create Table method}
  begin
  Table.active:=true;
  OpenTextForWrite(f,'x.txt');
  writeln(f,tab(2),'with Query1 do');
  writeln(f,tab(4),'begin');
  writeln(f,tab(4),'Databasename:= ''TEST''; {edit as needed}');
  writeln(f,tab(4),'with SQL do');
  writeln(f,tab(6),'begin');
  writeln(f,tab(6),'Clear;');
  writeln(f,tab(6),'Add(''CREATE TABLE "',Table.TableName,
          '" ('');');
  if TblType(Table.Tablename)='ttDBase' then ttype:=DBase else
     ttype:=PDX;
  indexstr:='';
  {Add the fields}
  with stringgrid1 do
    for r:=1 to table.fieldcount do
      begin
      write(f,tab(8),'Add(''',NoSpace(cells[0,r]),' ');
      write(f,dmap(cells[1,r],ttype));
      stemp:=dmap(cells[1,r],ttype);
      if (cells[1,r]='String') then
        write(f,'(',cells[2,r],')');
      if ((r<Table.fieldcount) or (indexstr<>''))
      then writeln(f,','');')
      else writeln(f,''');');
      if cells[3,r]='*' then indexstr:=indexstr+NoSpace(cells[0,r])+', ';
      end;

  if indexstr<>'' then {add the primary index}
    writeln(f,tab(6),'ADD(''PRIMARY KEY(',
      copy(indexstr,1,length(indexstr)-2),')'');');
  writeln(f,tab(6),'Add('')'');');
  writeln(f,tab(6),'ExecSQL;');

  {Now check for and add secondary indexes}
  if indexlistbox.items.count<>0 then
  for r:=0 to indexlistbox.items.count-1 do
    begin
     writeln(f,tab(6),'Clear;');
     s:=indexlistbox.items[r];
     table.active:=false;
     {table needs to be active with the correct index in order to
        see the fields}
     table.indexname:=s;
     table.active:=true;
     indexstr:='';
     if table.indexfieldcount<>0 then
     for x:=0 to table.indexfieldcount-1 do
        indexstr:=indexstr + nospace(table.indexfields[x].fieldname)+',';
     indexstr:=copy(indexstr,1,length(indexstr)-1);
     writeln(f,tab(6),'Add(''CREATE INDEX ',s,' ON "',table.tablename,'" (',
        indexstr,')'');');
     writeln(f,tab(6),'ExecSQL;');
   end;

  writeln(f,tab(4),'end;');
  writeln(f,tab(2),'end;');

  system.closefile(f);
  Table.indexname:='';
  Table.active:=false;
  end; {Create table with SQL}

 {check the results}
 WinExec(StrPCopy(St,'Notepad x.txt'),SW_SHOWMAXIMIZED);

end;

end.
