unit F_glyph;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Menus, ExtCtrls, DBCtrls;

type
  TGlyphViewer = class(TForm)
    GlyphBtn: TSpeedButton;
    NewBtn: TButton;
    CloseBtn: TBitBtn;
    GlyphPathEdit: TEdit;
    Label1: TLabel;
    GlyphName: TLabel;
    PrevBtn: TButton;
    AboutBtn: TButton;
    GlyphBtn2: TSpeedButton;
    ResetBtn: TButton;
    procedure NewBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PrevBtnClick(Sender: TObject);
    procedure AboutBtnClick(Sender: TObject);
    procedure GlyphPathEditChange(Sender: TObject);
    procedure ResetBtnClick(Sender: TObject);
  private
    { Private declarations }
    Function LoadGlyphFile( FName : string ) : boolean;
  public
    { Public declarations }
  end;

var
  GlyphViewer: TGlyphViewer;

implementation

const
   iCurrentFile : integer = -1;
var
   SearchRec : TSearchRec;
   aszFileList : TStringList;
{$R *.DFM}

Function TGlyphViewer.LoadGlyphFile( FName : string) : boolean;
begin
   GlyphName.Caption := FName;
   try
      GlyphBtn.Glyph.LoadFromFile( GlyphPathEdit.Text + FName );
      GlyphBtn2.Glyph := GlyphBtn.Glyph;
      GlyphBtn2.NumGlyphs := 2;
      Result := TRUE;
   except
      MessageDlg( 'Error! - Unable to load ' + FName + ' into button',
                  mtError, [mbOK], 0 );
      Result := FALSE;
   end;
end;

procedure TGlyphViewer.NewBtnClick(Sender: TObject);
var
   iResult : integer;
begin
   iCurrentFile := -1;
   if aszFileList.Count = 0 then begin
      iResult := findfirst( GlyphPathEdit.Text + '*.bmp', faAnyFile, SearchRec );
      if iResult <> 0 then begin
         MessageDlg( 'No files found - check your path',
                     mtError, [mbOK], 0 );
         exit;
      end;

   end else begin
      iResult := FindNext( SearchRec );
      if iResult <> 0 then begin
         MessageDlg( 'No more files found in this path',
                     mtInformation, [mbOK], 0 );
         exit;
      end;
   end;

   if LoadGlyphFile( SearchRec.Name ) then begin
      aszFileList.Add( SearchRec.Name );
      PrevBtn.Enabled := aszFileList.Count > 1;
   end;
end;

procedure TGlyphViewer.FormCreate(Sender: TObject);
begin
   aszFileList := TStringList.Create;
   if aszFileList = nil then
      showMessage( 'create failed' );
end;

procedure TGlyphViewer.PrevBtnClick(Sender: TObject);
begin
   if iCurrentFile = -1 then
      iCurrentFile := aszFileList.Count - 2
   else
      dec( iCurrentFile );
   if iCurrentFile >= 0 then
      LoadGlyphFile( AszFileList.Strings[ iCurrentFile ] );
   PrevBtn.Enabled := iCurrentFile >= 1;
end;

procedure TGlyphViewer.AboutBtnClick(Sender: TObject);
begin
   MessageDlg( 'Glyph Viewer produced by '#13#10 +
        'John Braga'#13#10'Crown Systems'#13#10 +
        'Huntingdon, UK'#13#10'CIS 70134,201'#13#10#10'Enjoy!',
        mtInformation, [mbOK], 0 );
end;

procedure TGlyphViewer.GlyphPathEditChange(Sender: TObject);
begin
   aszFileList.Clear;
   PrevBtn.Enabled := FALSE;
end;

procedure TGlyphViewer.ResetBtnClick(Sender: TObject);
begin
   aszFileList.Clear;
   iCurrentFile := -1;
   PrevBtn.Enabled := FALSE;
end;

end.
