unit Aboutdlg;

{ Freeware by Jeff Atwood

  This unit provides a standard About.. box
  for your application. It is modified from the
  example in the Delphi Component Writer's Guide.

  This is my first Delphi project of any scale,
  so if you can improve this code in any way,
  send me a copy!

  To use, select Options/Install Components...
  and select this file (ABOUTDLG.PAS)

  Thanks, Jeff
  JAtwood159@AOL.COM
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, About;

type
  TAboutBoxDlg = class(TComponent)

  private
    FProductName, FVersion, FCopyright, FComments: string;
    fileHandle: THandle;
    fileBuffer: Array [0..29] of Char;
    wVersion: Word;
    dVersion: Word;
    winFlags: LongInt;

  public
    function Execute: Boolean;

  published
    property ProductName: string read FProductName write FProductName;
    property Version: string read FVersion write FVersion;
    property Copyright: string read FCopyright write FCopyright;
    property Comments: string read FComments write FComments;
  end;

var
  AboutBox: TAboutBox;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Dialogs', [TAboutBoxDlg]);
end;

function TAboutBoxDlg.Execute: Boolean;
begin

     { Create dialog in memory }
     AboutBox := TAboutBox.Create(Application);

     { Set dialog strings }
     AboutBox.ProductName.Caption := ProductName;
     AboutBox.Version.Caption := Version;
     AboutBox.Copyright.Caption := Copyright;
     AboutBox.Comments.Caption := Comments;
     AboutBox.Caption := 'About ' + ProductName;

     { Get Win/Dos version numbers }
     wVersion := LoWord(GetVersion);
     dVersion := HiWord(GetVersion);
     AboutBox.WinVersion.Caption := IntToStr(LO(wVersion)) + '.' +
                                    IntToStr(HI(wVersion));
     AboutBox.DosVersion.Caption := IntToStr(HI(dVersion)) + '.' +
                                    IntToStr(LO(dVersion));

     winFlags := GetWinFlags;

     { Get math coprocessor status }
     If winFlags And WF_80x87 > 0 Then
        AboutBox.Coprocessor.Caption := 'Present'
     Else
        AboutBox.Coprocessor.Caption := 'Not Present';

     { Get CPU type }
     If winFlags And WF_CPU486 > 0 Then
        AboutBox.CPU.Caption := '486';
     If winFlags And WF_CPU386 > 0 Then
        AboutBox.CPU.Caption := '386';
     If winFlags And WF_CPU286 > 0 Then
        AboutBox.CPU.Caption := '286';

     { Get free memory, resources, disk space }
     AboutBox.FreeMemory.Caption := IntToStr(GetFreeSpace(0) div 1000) + ' KB';
     AboutBox.FreeResources.Caption := IntToStr(GetFreeSystemResources(GFSR_SYSTEMRESOURCES))
                                       + '%';
     AboutBox.FreeDisk.Caption := IntToStr(DiskFree(3) div 1000000) + ' MB';

     { Get user name and company name }
     fileHandle := LoadLibrary('USER');

     if fileHandle >= HINSTANCE_ERROR then begin
       If LoadString(fileHandle, 514, @fileBuffer, 30) <> 0 Then
          AboutBox.userName.Caption := fileBuffer;
       If LoadString(fileHandle, 515, @fileBuffer, 30) <> 0 Then
          AboutBox.companyName.Caption := fileBuffer;
       FreeLibrary(fileHandle);
     end;

     with AboutBox do
     begin
       ProgramIcon.Picture.Graphic := Application.Icon;
       Result := (ShowModal = IDOK);
     end;
end;

end.
