'**********************************************************************
'* OLEACCES.BAS
'*
'* Contains support functions for data access.
'*
'* DisplayOLEBitmap    -  Displays a bitmap stored in an Access database
'*                        in a VB picture control.
'* CopyOLEBitmapToFile -  Used by DisplayOLEBitmap.
'*
'**********************************************************************
Option Explicit

Global Const LENGTH_FOR_SIZE = 4
Global Const OBJECT_SIGNATURE = &H1C15
Global Const OBJECT_HEADER_SIZE = 20
Global Const CHECKSUM_SIGNITURE = &HFE05AD00
Global Const CHECKSUM_STRING_SIZE = 4

'PT : Window sizing information for object
'     Used in OBJECTHEADER type
Type PT
   Width As Integer
   Height As Integer
End Type

'OBJECTHEADER : Contains relevant information about object
'
Type OBJECTHEADER
   Signature As Integer         'Type signature (0x1c15)
   HeaderSize As Integer        'Size of header (sizeof(struct
                                'OBJECTHEADER) + cchName +
                                'cchClass)
   ObjectType As Long           'OLE Object type code (OT_STATIC,
                                'OT_LINKED, OT_EMBEDDED)
   NameLen As Integer           'Count of characters in object
                                'name (CchSz(szName) + 1)
   ClassLen As Integer          'Count of characters in class
                                'name (CchSz(szClass) + 1)
   NameOffset As Integer        'Offset of object name in
                                'structure (sizeof(OBJECTHEADER))
   ClassOffset As Integer       'Offset of class name in
                                'structure (ibName + cchName)
   ObjectSize As PT             'Original size of object (see
                                'code below for value)
   OleInfo As String * 256
End Type

Type OLEHEADER
   OleVersion As Long
   Format As Long
   OleInfo As String * 512
End Type

'Enter the following Declare statement as one, single line:
Declare Function GetTempFileName Lib "Kernel" (ByVal cDriveLetter As Integer, ByVal lpPrefixString As String, ByVal wUnique As Integer, ByVal lpTempFileName As String) As Integer

'Enter the following Declare statement as one, single line:
Declare Sub hmemcpy Lib "Kernel" (dest As Any, source As Any, ByVal bytes As Long)

'**********************************************************************
'* Title
'*      CopyOleBitmapToFile
'*
'* Description
'*      Copies the bitmap contained in a OLE field to a file.
'**********************************************************************
Function CopyOleBitmapToFile (OleField As Field) As String

   Const BUFFER_SIZE = 8192

   Dim tempFileName As String
   Dim Handle As Integer
   Dim Buffer As String

   Dim BytesNeeded As Long

   Dim Buffers As Long
   Dim Remainder As Long

   Dim OLEHEADER As OBJECTHEADER
   Dim sOleHeader As String

   Dim ObjectOffset As Long
   Dim BitmapOffset As Long
   Dim BitmapHeaderOffset As Integer

   Dim r As Integer
   Dim i As Long

   tempFileName = ""
   If OleField.FieldSize() > OBJECT_HEADER_SIZE Then

      'Get the Microsoft Access OLE header:
      sOleHeader = OleField.GetChunk(0, OBJECT_HEADER_SIZE)
      hmemcpy OLEHEADER, ByVal sOleHeader, OBJECT_HEADER_SIZE

      'Calculate the offset where the OLE object starts:
      ObjectOffset = OLEHEADER.HeaderSize + 1

      'Get enough bytes after the OLE header so that we get the
      'bitmap header
      Buffer = OleField.GetChunk(ObjectOffset, 512)

      'Make sure the class of the object is a Paint Brush object
      If Mid(Buffer, 12, 6) = "PBrush" Then

         BitmapHeaderOffset = InStr(Buffer, "BM")

         If BitmapHeaderOffset > 0 Then

            'Calculate the beginning of the bitmap:
            BitmapOffset = ObjectOffset + BitmapHeaderOffset - 1

            'Calculate the size of the bitmap:
            'Enter the following BytesNeeded statement as a single line:
            BytesNeeded = OleField.FieldSize() - OBJECT_HEADER_SIZE - BitmapHeaderOffset - CHECKSUM_STRING_SIZE + 1

            'Calculate the number of buffers needed to copy
            'the OLE object based on the bitmap size:
            Buffers = BytesNeeded \ BUFFER_SIZE
            Remainder = BytesNeeded Mod BUFFER_SIZE

            'Get a unique, temp filename:
            tempFileName = Space(255)
            r = GetTempFileName(0, "", -1, tempFileName)

            'Copy the bitmap to the temporary file chunk by chunk:
            Handle = FreeFile
            Open tempFileName For Binary As #Handle

            For i = 0 To Buffers - 1
               'Enter the following Buffer statement as a single line:
               Buffer = OleField.GetChunk(BitmapOffset + i * BUFFER_SIZE, BUFFER_SIZE)
               Put #Handle, , Buffer
            Next

            'Copy the remaining chunk of the bitmap to the file:
            'Enter the following Buffer statement as a single line:
            Buffer = OleField.GetChunk(BitmapOffset + Buffers * BUFFER_SIZE, Remainder)
            Put #Handle, , Buffer

            Close #Handle

         End If

      End If

   End If

   CopyOleBitmapToFile = Trim(tempFileName)

End Function

'**********************************************************************
'* Title
'*      DisplayOleBitmap
'*
'* Description
'*      Causes the OLE bitmap in the given data field to be
'*      copied to a temporary file. The bitmap is then
'*      displayed in the given picture.
'*
'* Parameters
'*      ctlPict         Picture control in which to display the
'*                      bitmap image
'*      OleField        Database field containing the OLE
'*                      embedded Microsoft Paint Brush bitmap
'**********************************************************************
Sub DisplayOleBitmap (ctlPict As Control, OleField As Field)

   Const DT_LONGBINARY = 11

   Dim r As Integer
   Dim Handle As Integer
   Dim OleFileName As String

   If OleField.Type = DT_LONGBINARY Then

      OleFileName = CopyOleBitmapToFile(OleField)

      If OleFileName <> "" Then

         'Display the bitmap:
         picTest.picImage.Picture = LoadPicture(OleFileName)

         'Delete the temporary file:
         Kill OleFileName

      End If

   End If

End Sub

