Option Explicit           ' Force declaration off all variables
'
'   Declare constants used
'
Const WF_CPU286 = &H2
Const WF_CPU386 = &H4
Const WF_CPU486 = &H8
Const WF_80x87 = &H400
Const WF_STANDARD = &H10
Const WF_ENHANCED = &H20
Const WF_WINNT = &H4000

Const WNNC_NET_MultiNet = &H8000
Const WNNC_SUBNET_WinWorkgroups = 4
Const WNNC_NET_TYPE = 2

'/* General */

Const WN_SUCCESS = &H0
Const WN_NOT_SUPPORTED = &H1
Const WN_NET_ERROR = &H2
Const WN_MORE_DATA = &H3
Const WN_BAD_POINTER = &H4
Const WN_BAD_VALUE = &H5
Const WN_BAD_PASSWORD = &H6
Const WN_ACCESS_DENIED = &H7
Const WN_FUNCTION_BUSY = &H8
Const WN_WINDOWS_ERROR = &H9
Const WN_BAD_USER = &HA
Const WN_OUT_OF_MEMORY = &HB
Const WN_CANCEL = &HC
Const WN_CONTINUE = &HD

'/* Connection */

Const WN_NOT_CONNECTED = &H30
Const WN_OPEN_FILES = &H31
Const WN_BAD_NETNAME = &H32
Const WN_BAD_LOCALNAME = &H33
Const WN_ALREADY_CONNECTED = &H34
Const WN_DEVICE_ERROR = &H35
Const WN_CONNECTION_CLOSED = &H36

'/* Printing */

Const WN_BAD_JOBID = &H40
Const WN_JOB_NOT_FOUND = &H41
Const WN_JOB_NOT_HELD = &H42
Const WN_BAD_QUEUE = &H43
Const WN_BAD_FILE_HANDLE = &H44
Const WN_CANT_SET_COPIES = &H45
Const WN_ALREADY_LOCKED = &H46

Const WN_NO_ERROR = &H50
'
'   API Declaration
'
Declare Function KRN_GetWinFlags Lib "Kernel" Alias "GetWinFlags" () As Long
Declare Function USR_WNetGetCaps Lib "User" Alias "WNetGetCaps" (ByVal nIndex As Integer) As Integer
Declare Function WFW_MNetNetworkEnum Lib "WFWNET.DRV" Alias "MNetNetworkEnum" (nIndex As Integer) As Integer
Declare Function WFW_MNetSetNextTarget Lib "WFWNET.DRV" Alias "MNetSetNextTarget" (ByVal nIndex As Integer) As Integer
Declare Function USR_WNetGetUser Lib "User" Alias "WNetGetUser" (ByVal sUser As String, nBufferSize As Integer) As Integer

Private Function IsWFW () As Integer
'
'   This routine will determine if Windows for Workgroups is running.
'   It will return TRUE if it is and FALSE otherwise.
'
    Dim nNetType As Integer
    
    IsWFW = False
    
    nNetType = USR_WNetGetCaps(WNNC_NET_TYPE)
    If (nNetType And WNNC_NET_MultiNet) Then
	IsWFW = ((nNetType And &HFFFF) And WNNC_SUBNET_WinWorkgroups) <> 0
    End If
End Function

Private Function IsWOW () As Integer
'
'   This routine will determine if the user is running
'   under the Windows NT WOW system.
'
    Dim lStatus As Long
    IsWOW = False
    lStatus = KRN_GetWinFlags()
    If lStatus And WF_WINNT Then
	IsWOW = True
    End If
End Function

Function NetworkUserId () As String
'
'   This routine will get the name of the user signed onto the network.
'   If no username is found it will return an UnknownUser string.
'
    Dim sUser As String * 255      ' Buffer for name
    Dim nBufferSize As Integer     ' Buffer length
    Dim nReturnValue As Integer    ' Return status (not used)
    Dim nNetworkHandle As Integer  ' Network handle
    Dim nRetEnum As Integer

    nBufferSize = 254              ' one less than string length due to zero padding
'
'   Check to see if we are running under WOW
'
    If IsWOW() Then
	nReturnValue = USR_WNetGetUser(sUser, nBufferSize)
	If (nReturnValue = WN_SUCCESS) Then
	    NetworkUserId = Left$(sUser, InStr(sUser, Chr(0)) - 1)
	    Exit Function
	End If
    Else
'
'   Check to see if we are running Windows for Workgroups
'
	If IsWFW() Then
'
'   Set network handle to nothing and then look for the first one
'
	    nNetworkHandle = 0
	    nRetEnum = WN_SUCCESS
	    nRetEnum = WFW_MNetNetworkEnum(nNetworkHandle)
'
'   Scan through the networks until we get a name
'
	    While (nRetEnum = WN_SUCCESS)
		nReturnValue = WFW_MNetSetNextTarget(nNetworkHandle)
		nReturnValue = USR_WNetGetUser(sUser, nBufferSize)
		If (nReturnValue = WN_SUCCESS) Then
		    NetworkUserId = Left$(sUser, InStr(sUser, Chr(0)) - 1)
		    Exit Function
		End If
		nRetEnum = WFW_MNetNetworkEnum(nNetworkHandle)
	    Wend
	Else
'
'   If aren't running Windows for Workgroups, then try for a name anyway.
'
	    nReturnValue = USR_WNetGetUser(sUser, nBufferSize)
	    If (nReturnValue = WN_SUCCESS) Then
		NetworkUserId = Left$(sUser, InStr(sUser, Chr(0)) - 1)
		Exit Function
	    End If
       End If
    End If
'
'   We didn't get a name anywhere, so lets go
'
   NetworkUserId = "UnknownUser"
End Function

