Option Explicit
Global Const GMEM_SHARE = &H2000
Global Const DDEACCESS_ERROR = 2

Declare Function FindWindow Lib "User" (ByVal lpClassName As Any, ByVal lpWindowName As Any) As Integer
Declare Function WinExec Lib "Kernel" (ByVal lpCmdLine As String, ByVal nCmdShow As Integer) As Integer
Declare Function lstrcpy Lib "Kernel" (ByVal lpString1 As Any, ByVal lpString2 As Any) As Long
Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer

Function DDEAccess (strCmd As String, strArguments As String) As Integer
    Const COMMAND_FAILED = 285

    Dim varRetCode As Variant
    Dim hdlAccess As Integer

    Static intGlobal As Integer
    Static lpGlbAddress As Long

    On Error GoTo ErrorDDEAccess
    
    hdlAccess = FindWindow(0&, "Microsoft Access")
    If hdlAccess = 0 Then
        intGlobal = GlobalAlloc(GMEM_SHARE, 128)
        hdlAccess = WinExec("MSARN200.EXE D:\LMS\DUBAI\REPORTS /CMD " & intGlobal, 7)
        If hdlAccess <= 32 Then
            hdlAccess = WinExec("C:\ACCESS\MSACCESS.EXE D:\LMS\DUBAI\REPORTS /CMD " & intGlobal, 7)
            If hdlAccess <= 32 Then
                MsgBox "Can't find MSACCESS to generate reports", 16
                intGlobal = GlobalFree(intGlobal)
                DDEAccess = False
                Exit Function
            End If
        End If
    End If

    If strArguments <> "" Then
        lpGlbAddress = GlobalLock(intGlobal)
        lpGlbAddress = lstrcpy(lpGlbAddress, strArguments)
    End If

    DDELink.DDE.LinkTimeout = -1
    DDELink.DDE.LinkTopic = "MSACCESS|System"
    DDELink.DDE.LinkMode = LINK_MANUAL
    DDELink.DDE.LinkExecute "[" & strCmd & "]"
    DDEAccess = True
    
    If strArguments <> "" Then
        varRetCode = GlobalUnlock(intGlobal)
    End If
    
ExitDDEAccess:
    DDELink.DDE.LinkMode = 0
    If strCmd = "Quit" Then
        Unload DDELink
        intGlobal = GlobalFree(intGlobal)
    End If
    Exit Function

ErrorDDEAccess:
    DDEAccess = False
    If Err = COMMAND_FAILED Then
        MsgBox "DDE to MSACCESS failed to execute the command '" & strCmd & "'", 16
    Else
        MsgBox Error$, 16
    End If
    Resume ExitDDEAccess

End Function

