'[Editor : You can just run the following code]
'Date: 05-22-92 (22:05)
'From: FRANK HAGAN
'Subj: Network Id's
'------------------------------------------------------------------------
'  Ķ MARTY KANE
'  Does anybody have a routine to check either the network node ID or the
'  card id on a NetBios based network, such as LanTastic?

'There is a couple of things in Ethan Winer's book BASIC Techniques
'and Utilities (Ziff Davis Press, ISBN 1-56276-008-4).  First, an
'include file, REGTYPE.BI:

        TYPE RegType
         AX    AS INTEGER
         BX    AS INTEGER
         CX    AS INTEGER
         DX    AS INTEGER
         BP    AS INTEGER
         SI    AS INTEGER
         DI    AS INTEGER
         Flags AS INTEGER
         DS    AS INTEGER
         ES    AS INTEGER
        END TYPE

'Then, a short program fragment with three functions:

'NETCHECK.BAS, identifies which network is running

DEFINT A-Z
''$INCLUDE: 'regtype.bi'

DIM SHARED Registers AS RegType

DECLARE FUNCTION NWThere% ()
DECLARE FUNCTION BVThere% ()
DECLARE FUNCTION MSThere% ()


'NOTE: Do not change the order in which these
'      tests are performed.

PRINT "I think the network is ";

IF NWThere% THEN
  PRINT "Novell Netware"
ELSEIF BVThere% THEN
  PRINT "Banyon Vines"
ELSEIF MSThere% THEN
  PRINT "Lantastic or other MS compatible"
ELSE
  PRINT "Something I don't recognize, or no network"
END IF

FUNCTION BVThere% STATIC
BVThere% = -1
Registers.AX = &HD701
CALL Interrupt(&H2F, Registers, Registers)
  AL = Registers.AX AND 255
  IF AL <> 0 THEN BVThere% = 0
END FUNCTION

FUNCTION MSThere% STATIC
  MSThere% = -1
  Registers.AX = &HB800
    CALL Interrupt(&H2F, Registers, Registers)
    AL = Registers.AX AND 255
    IF AL = 0 THEN MSThere% = 0
END FUNCTION

FUNCTION NWThere% STATIC
  NWThere% = -1
  Registers.AX = &H7A00
  CALL Interrupt(&H2F, Registers, Registers)
    AL = Registers.AX AND 255
    IF AL <> &HFF THEN NWThere% = 0
END FUNCTION
'----------------------------------------------------
'The book is a very good one; I heartily recommend it.
