'Date: 04-10-92 (01:16)
'From: BOB IRVINE
'Subj: BSAVE/BLOAD

'These routines will BSAVE/BLOAD screens 9 or 12. in 4 files,
'?????.PC0, ?????.PC1, ?????.PC2, ?????.PC3.
'The sub LoadEGAscreen requests that the mode be specified in order
'to correctly set up the correct count for the save.  LoadEGAscreen
'will only load the bitcount that was specified in the original
'BSAVE
'
'The OUT statements bump the port address of the video ram on the
'graphics board, so as the screen loads you will see each succesive
'screen painted on the screen.  Only in screen 9 can you switch the
'active page while you load.  When the load is complete you can flip
'the completed page into view.  SCREEN 12 does not support page swapping
'as there is only one page.


SUB LoadEGAscreen (FileName$)
 P = INSTR(FileName$, ".")                'STRIP OFF EXTENSION IF
 IF P > 0 THEN                            'PRESENT
   FileName$ = LEFT$(FileName$, P - 1)
 END IF
 DEF SEG = &HA000                         'POINT TO VIDEO RAM
 OUT &H3C4, 2
 OUT &H3C5, 1
 BLOAD FileName$ + ".PC0", 0              'LOAD BIT PLANE 0
 OUT &H3C4, 2                             '964,2
 OUT &H3C5, 2                             '965,2
 BLOAD FileName$ + ".PC1", 0              'LOAD BIT PLANE 1
 OUT &H3C4, 2
 OUT &H3C5, 4
 BLOAD FileName$ + ".PC2", 0              'LOAD BIT PLANE 2
 OUT &H3C4, 2
 OUT &H3C5, 8
 BLOAD FileName$ + ".PC3", 0              'LOAD BIT PLANE 3
 OUT &H3C4, 2
 OUT &H3C5, &HF
 DEF SEG
END SUB


SUB SaveEGAscreen (FileName$, MODE)
 SELECT CASE MODE
   CASE 9
     BitCount& = 28000
   CASE 12
     BitCount& = 38400
   CASE ELSE
     BEEP
     PRINT "***********************************************"
     PRINT "**  MODE SELECTION ERROR IN SAVE EGA SCREEN  **"
     PRINT "***********************************************"
 END SELECT
 P = INSTR(FileName$, ".")                'STRIP OFF EXTENSION IF
 IF P > 0 THEN                            'PRESENT
   FileName$ = LEFT$(FileName$, P - 1)
 END IF
 DEF SEG = &HA000                         'POINT TO VIDEO RAM
 OUT &H3CE, 4
 OUT &H3CF, 0
 BSAVE FileName$ + ".PC0", 0, BitCount&    'SAVE BIT PLANE 0
 OUT &H3CE, 4
 OUT &H3CF, 1
 BSAVE FileName$ + ".PC1", 0, BitCount&    'SAVE BIT PLANE 1
 OUT &H3CE, 4
 OUT &H3CF, 2
 BSAVE FileName$ + ".PC2", 0, BitCount&    'SAVE BIT PLANE 2
 OUT &H3CE, 4
 OUT &H3CF, 3
 BSAVE FileName$ + ".PC3", 0, BitCount&    'SAVE BIT PLANE 3
 OUT &H3CE, 4                             'RESTORE EGA CARD
 OUT &H3CF, 0                             'REGISTERS
 DEF SEG
END SUB