'Date: 05-11-92 (22:51)
'From: BRENT ASHLEY
'---------------------------------------------------------------------------
'Speaking of contests...

'I got a call today from none other than Ethan Winer, saying I've won
'Crescent's "word count" programming contest!  The idea was to write
'the fastest all-qb program to count the words in a text file.  This one
'does it on a 350k file in 1.4 seconds on my SX.  Ethan said I could post
'it about, so here goes:

' Compile:  BC /o/a wc,,wc;
' Link:     LINK /ex/noe wc+nocom;
'
DEFINT A-Z
DIM FBuf AS STRING * 8192              ' Use fixed string to fix
                                       ' position

WCount% = -32768                       ' Init count to bottom of integer
                                       ' range
                                       ' to get 65535 counts available

DEF SEG = VARSEG(FBuf)                 ' Point to fixed buffer in memory
BufStart% = VARPTR(FBuf)
BufLen% = 8192

NotOnWord = -1                         ' Assume not on word to start

OPEN COMMAND$ FOR BINARY AS #1         ' Open file and store length
AmtLeft& = LOF(1)

DO                                     ' Process file

  IF AmtLeft& >= BufLen% THEN GOTO NotLastBlock

  BufLen% = AmtLeft&                   ' Last block - size accordingly
  Done% = -1                           '  and flag end of loop
  GOTO GetBuf                          ' Less likely event gets GOTO

NotLastBlock:                          ' More likely event falls thru to
                                       ' GetBuf
  AmtLeft& = -BufLen% + AmtLeft&       ' Negative first saves bytes

GetBuf:
  GET #1, , FBuf                       ' Fill buffer

  FOR Ofs% = BufStart% TO BufStart% + BufLen% - 1  ' Traverse buffer

    IF PEEK(Ofs%) > 32 THEN GOTO NotWhiteSpace

    IF NotOnWord% THEN GOTO NextByte   ' If already white space...

    NotOnWord% = -1                    ' Trailing edge of word
    WCount% = WCount% + 1              '  triggers counter
    GOTO NextByte

NotWhiteSpace:                         ' Not white space is more likely
    NotOnWord% = 0                     '  so comparison done on white
                                       '  space

NextByte:
  NEXT
LOOP UNTIL Done%                       ' post-compare saves bytes

PRINT WCount% + 32768                  ' display word count


'---- end of program ----
