DEFINT A-Z

'$INCLUDE: 'QB.BI'

DECLARE FUNCTION KeyInBuf ()

'***********************************************************************
'* FUNCTION KeyInBuf
'*
'* PURPOSE
'*    Uses BIOS ISR 16H, Service 01H (Report Whether Character Ready)
'*    to return a keypress if one is waiting in the keyboard buffer.
'*    If the key pressed is a normal key, this function will return the
'*    ASCII value for that key; if the key pressed is an extended key
'*    (such as F1) this function will return the ascii value for that
'*    key negated.  This function does not remove the key from the
'*    keyboard buffer.
'*
'* EXTERNAL ROUTINE(S)
'*    QBX.LIB:
'*    --------
'*    SUB Interrupt (IntNum, InRegs AS RegType, OutRegs AS RegType)
'***********************************************************************
FUNCTION KeyInBuf STATIC
   InRegs.ax = &H100
   Interrupt &H16, InRegs, OutRegs

   IF ((OutRegs.flags AND 64) \ 64) = 0 THEN '0 if a key is pending
      'If the key pressed is a normal key, alReg holds the ASCII code for
      'that key and ahReg holds the standard PC-keyboard scan code;
      'otherwise, (a special key was pressed such as F1) alReg holds 0
      'and ahReg holds the character ID.
      alReg = OutRegs.ax AND &HFF
      ahReg = OutRegs.ax \ &HFF

      IF alReg THEN
         KeyInBuf = alReg
      ELSE
         KeyInBuf = -ahReg
      END IF
   ELSE
      KeyInBuf = 0
   END IF
END FUNCTION
