100 ' MEESCALL.BAS  demonstrates how to call mouse functions in GW-BASIC
110 '
120 '   Author:     Christy Gemmell
130 '   Date:       15/9/1991
140 '
150 ' Load general-purpose interrupt service interface.
160 '
170 DEFINT A-Z: CLS: PRINT: KEY OFF
180 DIM REG.IN(7), REG.OUT(7)
190 AX = 0: BX = 1: CX = 2: DX = 3: SI = 4: DI = 5: DS = 6: ES = 7
200 SYSINT$ = SPACE$(116)
210 FOR X = 1 TO 116
220     READ A$: MID$(SYSINT$, X, 1) = CHR$(VAL("&H" + A$))
230 NEXT
240 '
250 '  Test out some mouse functions with it.
260 '
270 INT.NO = &H33   ' Microsoft Mouse driver interrupt number
280 '
290 '  Reset Mouse and get status
300 '
310 REG.IN(AX) = 0: GOSUB 770
320 IF REG.OUT(AX) = 0 THEN PRINT "Mouse not installed!": BEEP: STOP
330 PRINT "A"; REG.OUT(BX); "- button mouse is available"
340 PRINT "Turning on the Mouse pointer"
350 PRINT: PRINT "Press the <Esc> key to quit"
360 '
370 '  Show Mouse pointer
380 '
390 REG.IN(AX) = 1: GOSUB 770
400 '
410 ' Main control loop
420 '
430 IF INKEY$ = CHR$(27) THEN GOTO 600
440 '
450 '  Get Mouse pointer and button status
460 '
470    REG.IN(AX) = 3: GOSUB 770
480    LOCATE 10, 1: PRINT "X ="; REG.OUT(CX); " "
490    LOCATE 11, 1: PRINT "Y ="; REG.OUT(DX); " "
500    LOCATE 13, 1
510    IF REG.OUT(BX) = 1 THEN PRINT "Left Button Down" ELSE PRINT SPACE$(20)
520    LOCATE 14, 1
530    IF REG.OUT(BX) = 3 THEN PRINT "Centre Button Down" ELSE PRINT SPACE$(20)
540    LOCATE 15, 1
550    IF REG.OUT(BX) = 2 THEN PRINT "Right Button Down" ELSE PRINT SPACE$(20)
560 GOTO 430
570 '
580 '  Hide Mouse pointer
590 '
600 REG.IN(AX) = 2: GOSUB 770
610 END
620 '
630 '  Machine-language opcodes
640 '
650 DATA 55, 8B, EC, 8B, 5E, 0A, 8B, 07, 8B, 5E, 06, 8B, CB
660 DATA 8B, 5E, 08, 06, 1E, E8, 05, 00, 00, 00, CD, 00, C3
670 DATA 5D, 88, 46, 03, 89, 4E, 00, 8B, 4F, 04, 8B, 57, 06
680 DATA 8B, 77, 08, 8B, 7F, 0A, 8B, 47, 0E, 3D, FF, FF, 74
690 DATA 02, 8E, C0, 8B, 47, 0C, 3D, FF, FF, 74, 02, 8E, D8
700 DATA 36, 8B, 07, 36, 8B, 5F, 02, E8, CC, FF, 53, 8B, 5E
710 DATA 00, 36, 89, 07, 36, 8F, 47, 02, 8C, D8, 36, 89, 47
720 DATA 0C, 1F, 8C, C0, 89, 47, 0E, 07, 89, 4F, 04, 89, 57
730 DATA 06, 89, 77, 08, 89, 7F, 0A, 5D, CA, 06, 00, 00
740 '
750 '  Call machine-language routine
760 '
770 X = VARPTR(SYSINT$)
780 SYSINT! = PEEK(X + 1) + 256 * PEEK(X + 2)
790 CALL SYSINT!(INT.NO, REG.IN(0), REG.OUT(0))
800 RETURN

'BTW That assembly-language routine can be used for other things than
'the mouse. It is actually a general-purpose program which you can use
'to make DOS (INT 21h) and BIOS (INT 10h, INT 16h etc) interrupt calls.
'In effect a GW-BASIC version of QuickBASIC's CALL INTERRUPT.