'Date: 05-27-92 (01:13)
'From: JOE NEGRON
'------------------------------------------------------------------------

DEFINT A-Z

'$INCLUDE: 'QB.BI'

DECLARE FUNCTION GetDir$ (Drive$)
DECLARE FUNCTION GetDrv$ ()

CurDrv$ = GetDrv$
CurDir$ = GetDir$("")

PRINT "Current drive is " + CurDrv$
PRINT "Current directory is " + CurDir$

END

'***********************************************************************
'* FUNCTION GetDir$
'*
'* PURPOSE
'*    Uses DOS ISR 21H, Function 47H (Get Current Directory) to retrieve
'*    the current directory for the specified drive.  Drive$ may be null
'*    to indicate the default drive.
'*
'* PARAMETER(S)
'*    Drive$
'***********************************************************************
FUNCTION GetDir$ (Drive$) STATIC
   DIM Temp AS STRING * 64

   InRegsX.ax = &H4700

   'must convert drive to integer
   'current = 0, A: = 1, B: = 2, C: = 3, etc.
   IF Drive$ > "" THEN
      InRegsX.dx = ASC(UCASE$(Drive$)) - 64
   ELSE
      InRegsX.dx = 0
   END IF

   InRegsX.ds = VARSEG(Temp$)
   InRegsX.si = VARPTR(Temp$)

   InterruptX &H21, InRegsX, OutRegsX

   GetDir$ = "\" + LEFT$(Temp$, INSTR(Temp$, CHR$(0)) - 1)
END FUNCTION

'***********************************************************************
'* FUNCTION GetDrv$
'*
'* PURPOSE
'*    Uses DOS ISR 21H, Function 19H (Get Current Disk) to return the
'*    currently logged disk drive.
'***********************************************************************
FUNCTION GetDrv$ STATIC
   InRegs.ax = &H1900
   Interrupt &H21, InRegs, OutRegs
   GetDrv$ = CHR$((OutRegs.ax AND &HFF) + 65) + ":"
END FUNCTION
