'  Program CLINE.BAS
'  Version 1.00
'  Parses the command tail into an array holding all
'  command line arguments.
'  Written by: J. Derek Lyons.
'  November 1991
'  Released into the public domain to the extent of my ability to do so.

DECLARE SUB ParCline (Arg$(), MaxArg%, Res%)

DEFINT A-Z
OPTION BASE 0

DIM Arg$(5)             'Array to hold the arguments
MaxArg% = 5             'Maximum number of arguments
'
'  To demonstrate CLINE, simply compile this program inside Quick Basic
'  or from the command line.
'
'  Many more options are discussed in CLINE.DOC
'
CLS
CALL ParCline(Arg$(), MaxArg%, Res%)
FOR x = 1 TO 5: PRINT Arg$(x): NEXT x
IF Res% = -1 THEN PRINT "Too Many Arguments"
IF Res% = 0 THEN PRINT "Sucessful Processing"
IF Res% = 1 THEN PRINT "No Arguments Found"
END

SUB ParCline (Arg$(), MaxArg%, Res%)
'  Inputs
'     MaxArg%   Maximum number of arguments
'     Arg$()    Empty array to hold the arguments
'               To work properly should be DIMed as Arg$(MaxArg%)
'  Outputs
'     Res%      Result of subroutine
'               -1 = Too many arguments
'                0 = Sucessful processing
'                1 = No arguments found
'     Arg$()    Array holding the arguments
'
                        'numarg and argpos must be initialized
                        'because QB initializes them as 0
NumArg = 1              'Because there is no leading space for the
                        'first argument we must add 1 to the total
                        'number of space to find the total number
                        'of arguments
ArgPos = 1              'The first position in the array

Cline$ = LTRIM$(RTRIM$(COMMAND$))
                        'Get the command line and trim all the spaces
Clen = LEN(Cline$)      'Get the length of the command line

IF Clen = 0 THEN        'There are no arguments so there is no reason
                        'to continue processing the command line
   Res% = 1
   EXIT SUB
END IF

FOR Scount = 1 TO Clen  'Get the number of arguments
   IF MID$(Cline$, Scount, 1) = " " THEN NumArg = NumArg + 1
                        'Each time a space is found in the command line
                        'the number of arguments is incremented
NEXT Scount

IF NumArg > MaxArg% THEN
                        'So we don't crash the program by trying to
                        'write past the end of the array
   Res% = -1
   EXIT SUB
END IF

FOR wcount = 1 TO Clen
   IF MID$(Cline$, wcount, 1) <> " " THEN
      Arg$(ArgPos) = Arg$(ArgPos) + MID$(Cline$, wcount, 1)
                        'If a character is found, then add it to the
                        'current string
   ELSEIF MID$(Cline$, wcount, 1) = " " THEN
      ArgPos = ArgPos + 1
                        'If a space is found, start processing the
                        'next string
   END IF
NEXT wcount

END SUB
'     CLINE.BAS
'     Version 1.00
'     Mountain Bay Software
'     James Derek Lyons
'
'     A subroutine to parse the command line for
'     QUICK BASIC programs.

'CLINE.BAS is hereby released into the public domain to the extent
'of my legal rights to do so.
'The author makes no warranty as to the fitness of this code for any
'given application.  The responsibility for determining fitness of
'use and for any damages caused lies with the user.

'CLINE.BAS has been tested using MSDOS V3.3 and Quick Basic V4.5.
'QUICK BASIC and MSDOS are registered trademarks of the Microsoft
'Corporation.

'INDEX

'1.      Overview
'2.      Program Logic.
'2A.     The Parsing Algorithm
'3A.     Error Handling.

'1. OVERVIEW

'     One of the most useful functions of MSDOS is the ability to
'use a 'command tail'.  That is to say, a set of variables which
'can be read by a program at run-time and used to modify it's
'operation.
'     In QUICK BASIC the COMMAND$ function can be used to read the
'command tail into your program.  However, this function returns the
'entire command tail as a single string.  Unless you are using only
'one run-time option, this is fairly useless.
'     CLINE offers the QUICK BASIC programmer a method of importing
'this command tail and parsing it into useful string variables.

'2. PROGRAM LOGIC

'     The algorithm used by CLINE is fairly simple.  The requirements
'for using this subroutine are deliberately held to a minimum.
'     Three variables are required to use the subroutine.  Two must
'be declared in advance.

'     These variables are:
'     MaxArg%, which is the maximum number of arguments expected.
'     Arg$(),  which is a string array to hold the returned, parsed,
'              arguments.
'     Res%,    which is a variable to hold the result flag for the
'              subroutine.

'     The following assumptions apply these variables;

'     MaxArg% is the total number of arguments that the user can
'legally use when loading the program.  As will be shown later each
'argument is assumed to be separated by a space.  Thus "/FILE DUMMY
'would be counted as two arguments.  "/FILE:DUMMY and "-AJ2" would
'both be considered to be one argument.

'     ARG$() is a string array to hold the arguments when they are
'parsed.  To prevent programs from bombing, ARG$() is best
'dimensioned by using DIM ARG$(MaxArg%).

'     Res% is an integer flag that returns the result of the parsing
'process.  These results are defined as follows;

'     -1   indicates that too many arguments were found.  Processing
'           is halted and control returned to the calling program.
'      0   indicates that processing was successful and the parsed
'          arguments will be found in ARG$().
'      1   Indicates that no command line was found.  Processing is
'          halted and control is returned to the calling program.

'     No error handling is performed by CLINE other than the setting
'of Res% to the appropriate value.

'2A. The Parsing Algorithm

'     The command tail retrieved by COMMAND$ is processed as
'follows;
'     First all leading and trailing spaces are removed using the
'LTRIM$() and RTRIM$() functions.  Since the algorithm determines
'the number of arguments by counting the number of spaces, any
'extraneous ones at the beggining and end must be removed.
'     Because there is no leading space for the first argument, the
'NUMARG and ARGPOS() variables are initialized to 1.
'     The length of the command tail is then determined.  If no tail
'is found, processing is returned to the calling program.  A flag
'is set to inform the calling program that no command line options
'were found.
'     Each position in the string is then examined using the
'MIDSTRING$() function.  Each time a space is encountered, the
'argument count is increased by one.
'     The total number of arguments found by this statement is then
'compared to the maximum allowable number.  If the number found
'exceeds the number allowed, processing is halted and control
'returned to the calling program.  The programmer must provide code
'to handle this error and inform the user of the failure.
'     Each position in the string is then examined.  If a non-space
'character is encountered, the character is added to the current
'string.  If a space is encountered, the string number is
'incremented by one and processing continues with the next
'character.

'     Hence the string /FILE DUMMY /A -AQD2 /OUTFILE:TEST would
'parse as follows;

'     String #1     /FILE
'     String #2     DUMMY
'     String #3     /A
'     String #4     -AQD2
'     String #5     /OUTFILE:TEST

'     Note that because of the way COMMAND$ functions, all
'alphabetic characters will be in upper case.

'     Control is then returned to the calling program.

'3A. ERROR HANDLING

'     Other than errors relating to the number of arguments, and the
'lack of a command tail, no native error handling is provided.

'     If too many arguments are encountered, the programmer must
'provide routines to inform the user of the syntax error and recover
'from the error condition.

'     If no arguments are provided then a flag is set to inform the
'calling program.  The programmer must provide code for his program
'to respond approprietly.

'     It is suggested that if too many, or no, command line
'arguments are found, that any defaults be loaded and the user
'informed.

'     If this code is used in a command line utility, (a program
'that is run only from the command line), that the program inform
'the user and exit gracefully.
