'ISAMSORT.BAS
'Uses the ISAM to sort a flat file.
'Syntax:
'ISAMSORT x$ y z1a z1b z2a z2b ...
' x$   = File to Sort
' y    = Record Length
' z1a  = Offset of first field to sort
' z1b  = Length of first field to sort
' z2a  = Offset of second field to sort
' z2b  = Length of second field to sort

'Parse Command Line Parameters
'Make sure there's only one space between each
'entry on the command line

CLS
CL$ = COMMAND$ + " "
IF RTRIM$(CL$) = "" THEN PRINT "Invalid Command Line": END
IF INSTR(CL$, "  ") THEN
 EndC = LEN(CL$)
 CurLoc = 1
 WHILE CurLoc < EndC
  IF MID$(CL$, CurLoc, 2) = "  " THEN
   CL$ = LEFT$(CL$, CurLoc) + MID$(CL$, CurLoc + 2)
   EndC = LEN(CL$)
  ELSE
   CurLoc = CurLoc + 1
  END IF
 WEND
END IF

'Get the first two command line entries:
' The file name and the record length

PRINT "Parsing Command Line"
CurLoc = 1
SpaceLoc = INSTR(CurLoc, CL$, " ") - 1
OutFile$ = LEFT$(CL$, SpaceLoc)
CurLoc = SpaceLoc + 1
SpaceLoc = INSTR(CurLoc + 1, CL$, " ")
RECLEN = VAL(MID$(CL$, CurLoc, SpaceLoc - CurLoc))
CurLoc = SpaceLoc + 1
SpaceLoc = INSTR(CurLoc + 1, CL$, " ")

'Get the sort field entries and place them
'in the array ArrayEntry(i,j) where
'i=0 is the offset, i=1 is the length
'j is the entry number

OPTION BASE 0
ArrayEntry = 0
WHILE SpaceLoc <> 0
 IF ArrayEntry = 0 THEN
  REDIM KeyArray(1, 0)
 ELSE
  REDIM PRESERVE KeyArray(1, UBOUND(KeyArray, 2) + 1)
 END IF
 OffSet = VAL(MID$(CL$, CurLoc, SpaceLoc - CurLoc))
 CurLoc = SpaceLoc + 1
 SpaceLoc = INSTR(CurLoc + 1, CL$, " ")
 IF SpaceLoc <> 0 THEN
   Length = VAL(MID$(CL$, CurLoc, SpaceLoc - CurLoc))
 ELSE
   PRINT "Invalid Number of parameters"
   END
 END IF
 CurLoc = SpaceLoc + 1
 SpaceLoc = INSTR(CurLoc + 1, CL$, " ")
 KeyArray(0, ArrayEntry) = OffSet
 KeyArray(1, ArrayEntry) = Length
 ArrayEntry = ArrayEntry + 1
WEND


'Verify the entries are accurate
PRINT "Verifying Command Line entries"

OutFileNo = FREEFILE
OPEN OutFile$ FOR BINARY AS #OutFileNo
OutFileLen = LOF(OutFileNo)
CLOSE OutFileNo

IF OutFileLen = 0 OR OutFileLen < RECLEN THEN
 PRINT "Not a valid input file"
 END
END IF

FOR I = 0 TO UBOUND(KeyArray, 2)
 IF KeyArray(0, I) + KeyArray(1, I) > RECLEN + 1 THEN
  PRINT "Invalid field definitions"
  PRINT "Field "; I + 1; " extends past the length of the record"
  END
 END IF
NEXT I

PRINT "Sorting "; OutFile$
'Create dummy TYPE to hold keys
TYPE Entry
 RecordNum AS LONG
 Keys AS STRING * 255
END TYPE
 
DIM B AS Entry
'Create temp file name
ISAMFile$ = "TEMPISAM." + CHR$(254)
IsamFileNo = FREEFILE
OPEN ISAMFile$ FOR ISAM Entry "SortEntries" AS #IsamFileNo
RECLEN = 86
OutFileNo = FREEFILE
OPEN OutFile$ FOR RANDOM AS #OutFileNo LEN = RECLEN
FIELD #OutFileNo, RECLEN AS StrIn$

GET #OutFileNo
WHILE NOT EOF(OutFileNo)
 In$ = StrIn$
 B.RecordNum = LOC(OutFileNo)
 AllKeys$ = ""
  FOR I = 0 TO UBOUND(KeyArray, 2)
   KeySegment$ = MID$(In$, KeyArray(0, I), KeyArray(1, I))
   AllKeys$ = AllKeys$ + KeySegment$
  NEXT I
  B.Keys = AllKeys$
 INSERT IsamFileNo, B
 PRINT B.RecordNum, RTRIM$(B.Keys)
 GET #OutFileNo
WEND

CREATEINDEX IsamFileNo, "SortColumns", 0, "Keys"
SETINDEX IsamFileNo, "SortColumns"

TempFile$ = "TEMPFILE." + CHR$(254)
TempFileNo = FREEFILE
OPEN TempFile$ FOR OUTPUT AS #TempFileNo
MOVEFIRST IsamFileNo
WHILE NOT EOF(IsamFileNo)
 RETRIEVE IsamFileNo, B
  'PRINT B.RecordNum, RTRIM$(B.Keys)
  'Write the records out in the new order
  GET #OutFileNo, B.RecordNum
  PRINT #TempFileNo, StrIn$;
 MOVENEXT IsamFileNo
WEND

CLOSE
KILL OutFile$
KILL ISAMFile$
NAME TempFile$ AS OutFile$

