OPTION EXPLICIT
'$FORM frmDemo
'
'Demonstration of how to change/read file attributes
'using VBDOS/CALL INTERRUPT. Andy Chevin 18/01/93
'
'Start VBDOS as follows:
' VBDOS /l vbdos.qlb
' (include interrupt library)
'
'$INCLUDE: 'vbdos.bi'
' (include defines for interrupt library)
'
'File Attribute Type:
'Noramlly should put Types that are referenced more than once
'in an INCLUDE file.

	TYPE FileAttType
		ReadOnly AS INTEGER
		Hidden AS INTEGER
		System AS INTEGER
		Archive AS INTEGER
		Result AS INTEGER
	END TYPE

	frmDemo.SHOW 1

	END

SUB GetAttrib (FileName$, Att AS FileAttType)
	'file attributes for FileName$ will be returned in Att

	DIM regX AS RegTypeX   'Define local register type
	DIM f$                 'variable to hold file name

	regX.ax = &H4300          'Dos Services no. 43h, 00 = Get file attributes
	f$ = FileName$ + CHR$(0)  'String must be in asciiz format
	regX.ds = SSEG(f$)        'Far string segment
	regX.dx = SADD(f$)        'Offset of string
	INTERRUPTX &H21, regX, regX    'call Dos Services

	'Check for errors
	IF regX.flags AND 1 THEN    'If CF is set then error occured
		Att.Result = regX.ax      '& is held in AX (std Dos Error code)
	ELSE
		Att.Result = 0            'No error occurred
		'Bit fiddling:
		'Move the relevant bits into position 0 & mask off to obtain result
		'Attributes are held in CX register
		'Bit 0 = ReadOnly
		'Bit 1 = Hidden
		'Bit 2 = System
		'Bit 3 = Not used
		'Bit 4 = Not used
		'Bit 5 = Archive
		Att.ReadOnly = regX.CX AND 1
		Att.Hidden = (regX.CX \ 2) AND 1
		Att.System = (regX.CX \ 4) AND 1
		Att.Archive = (regX.CX \ 32) AND 1
	END IF

END SUB

SUB SetAttrib (FileName$, Att AS FileAttType)
	'file attributes for FileName$ will be set to values
	'passed to this routine in Att

	DIM regX AS RegTypeX   'Define local register type
	DIM f$                 'variable to hold file name

	regX.ax = &H4301       'Dos Services no. 43h, 01 = Set file attributes

	regX.CX = Att.ReadOnly  'Clear & Set correct attributes
	regX.CX = regX.CX OR ((Att.Hidden * 2) AND 2)
	regX.CX = regX.CX OR ((Att.System * 4) AND 4)
	regX.CX = regX.CX OR ((Att.Archive * 32) AND 32)

	f$ = FileName$ + CHR$(0)  'String must be in asciiz format
	regX.ds = SSEG(f$)      'address of string
	regX.dx = SADD(f$)
	INTERRUPTX &H21, regX, regX    'call Dos Services

	'Check for errors
	IF regX.flags AND 1 THEN    'If CF is set then error occured
		Att.Result = regX.ax      '& is held in AX (std Dos Error code)
	ELSE
		Att.Result = 0            'No error occurred
	END IF

END SUB

